package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AlertmanagerConfigSpecFluent<A extends AlertmanagerConfigSpecFluent<A>> extends BaseFluent<A>{
  public AlertmanagerConfigSpecFluent() {
  }
  
  public AlertmanagerConfigSpecFluent(AlertmanagerConfigSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<InhibitRuleBuilder> inhibitRules = new ArrayList<InhibitRuleBuilder>();
  private ArrayList<ReceiverBuilder> receivers = new ArrayList<ReceiverBuilder>();
  private RouteBuilder route;
  private ArrayList<TimeIntervalBuilder> timeIntervals = new ArrayList<TimeIntervalBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AlertmanagerConfigSpec instance) {
    instance = (instance != null ? instance : new AlertmanagerConfigSpec());
    if (instance != null) {
          this.withInhibitRules(instance.getInhibitRules());
          this.withReceivers(instance.getReceivers());
          this.withRoute(instance.getRoute());
          this.withTimeIntervals(instance.getTimeIntervals());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToInhibitRules(int index,InhibitRule item) {
    if (this.inhibitRules == null) {this.inhibitRules = new ArrayList<InhibitRuleBuilder>();}
    InhibitRuleBuilder builder = new InhibitRuleBuilder(item);
    if (index < 0 || index >= inhibitRules.size()) { _visitables.get("inhibitRules").add(builder); inhibitRules.add(builder); } else { _visitables.get("inhibitRules").add(index, builder); inhibitRules.add(index, builder);}
    return (A)this;
  }
  
  public A setToInhibitRules(int index,InhibitRule item) {
    if (this.inhibitRules == null) {this.inhibitRules = new ArrayList<InhibitRuleBuilder>();}
    InhibitRuleBuilder builder = new InhibitRuleBuilder(item);
    if (index < 0 || index >= inhibitRules.size()) { _visitables.get("inhibitRules").add(builder); inhibitRules.add(builder); } else { _visitables.get("inhibitRules").set(index, builder); inhibitRules.set(index, builder);}
    return (A)this;
  }
  
  public A addToInhibitRules(io.fabric8.openshift.api.model.monitoring.v1beta1.InhibitRule... items) {
    if (this.inhibitRules == null) {this.inhibitRules = new ArrayList<InhibitRuleBuilder>();}
    for (InhibitRule item : items) {InhibitRuleBuilder builder = new InhibitRuleBuilder(item);_visitables.get("inhibitRules").add(builder);this.inhibitRules.add(builder);} return (A)this;
  }
  
  public A addAllToInhibitRules(Collection<InhibitRule> items) {
    if (this.inhibitRules == null) {this.inhibitRules = new ArrayList<InhibitRuleBuilder>();}
    for (InhibitRule item : items) {InhibitRuleBuilder builder = new InhibitRuleBuilder(item);_visitables.get("inhibitRules").add(builder);this.inhibitRules.add(builder);} return (A)this;
  }
  
  public A removeFromInhibitRules(io.fabric8.openshift.api.model.monitoring.v1beta1.InhibitRule... items) {
    if (this.inhibitRules == null) return (A)this;
    for (InhibitRule item : items) {InhibitRuleBuilder builder = new InhibitRuleBuilder(item);_visitables.get("inhibitRules").remove(builder); this.inhibitRules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInhibitRules(Collection<InhibitRule> items) {
    if (this.inhibitRules == null) return (A)this;
    for (InhibitRule item : items) {InhibitRuleBuilder builder = new InhibitRuleBuilder(item);_visitables.get("inhibitRules").remove(builder); this.inhibitRules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInhibitRules(Predicate<InhibitRuleBuilder> predicate) {
    if (inhibitRules == null) return (A) this;
    final Iterator<InhibitRuleBuilder> each = inhibitRules.iterator();
    final List visitables = _visitables.get("inhibitRules");
    while (each.hasNext()) {
      InhibitRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<InhibitRule> buildInhibitRules() {
    return this.inhibitRules != null ? build(inhibitRules) : null;
  }
  
  public InhibitRule buildInhibitRule(int index) {
    return this.inhibitRules.get(index).build();
  }
  
  public InhibitRule buildFirstInhibitRule() {
    return this.inhibitRules.get(0).build();
  }
  
  public InhibitRule buildLastInhibitRule() {
    return this.inhibitRules.get(inhibitRules.size() - 1).build();
  }
  
  public InhibitRule buildMatchingInhibitRule(Predicate<InhibitRuleBuilder> predicate) {
      for (InhibitRuleBuilder item : inhibitRules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingInhibitRule(Predicate<InhibitRuleBuilder> predicate) {
      for (InhibitRuleBuilder item : inhibitRules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withInhibitRules(List<InhibitRule> inhibitRules) {
    if (this.inhibitRules != null) {
      this._visitables.get("inhibitRules").clear();
    }
    if (inhibitRules != null) {
        this.inhibitRules = new ArrayList();
        for (InhibitRule item : inhibitRules) {
          this.addToInhibitRules(item);
        }
    } else {
      this.inhibitRules = null;
    }
    return (A) this;
  }
  
  public A withInhibitRules(io.fabric8.openshift.api.model.monitoring.v1beta1.InhibitRule... inhibitRules) {
    if (this.inhibitRules != null) {
        this.inhibitRules.clear();
        _visitables.remove("inhibitRules");
    }
    if (inhibitRules != null) {
      for (InhibitRule item : inhibitRules) {
        this.addToInhibitRules(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasInhibitRules() {
    return this.inhibitRules != null && !this.inhibitRules.isEmpty();
  }
  
  public InhibitRulesNested<A> addNewInhibitRule() {
    return new InhibitRulesNested(-1, null);
  }
  
  public InhibitRulesNested<A> addNewInhibitRuleLike(InhibitRule item) {
    return new InhibitRulesNested(-1, item);
  }
  
  public InhibitRulesNested<A> setNewInhibitRuleLike(int index,InhibitRule item) {
    return new InhibitRulesNested(index, item);
  }
  
  public InhibitRulesNested<A> editInhibitRule(int index) {
    if (inhibitRules.size() <= index) throw new RuntimeException("Can't edit inhibitRules. Index exceeds size.");
    return setNewInhibitRuleLike(index, buildInhibitRule(index));
  }
  
  public InhibitRulesNested<A> editFirstInhibitRule() {
    if (inhibitRules.size() == 0) throw new RuntimeException("Can't edit first inhibitRules. The list is empty.");
    return setNewInhibitRuleLike(0, buildInhibitRule(0));
  }
  
  public InhibitRulesNested<A> editLastInhibitRule() {
    int index = inhibitRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last inhibitRules. The list is empty.");
    return setNewInhibitRuleLike(index, buildInhibitRule(index));
  }
  
  public InhibitRulesNested<A> editMatchingInhibitRule(Predicate<InhibitRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<inhibitRules.size();i++) { 
    if (predicate.test(inhibitRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching inhibitRules. No match found.");
    return setNewInhibitRuleLike(index, buildInhibitRule(index));
  }
  
  public A addToReceivers(int index,Receiver item) {
    if (this.receivers == null) {this.receivers = new ArrayList<ReceiverBuilder>();}
    ReceiverBuilder builder = new ReceiverBuilder(item);
    if (index < 0 || index >= receivers.size()) { _visitables.get("receivers").add(builder); receivers.add(builder); } else { _visitables.get("receivers").add(index, builder); receivers.add(index, builder);}
    return (A)this;
  }
  
  public A setToReceivers(int index,Receiver item) {
    if (this.receivers == null) {this.receivers = new ArrayList<ReceiverBuilder>();}
    ReceiverBuilder builder = new ReceiverBuilder(item);
    if (index < 0 || index >= receivers.size()) { _visitables.get("receivers").add(builder); receivers.add(builder); } else { _visitables.get("receivers").set(index, builder); receivers.set(index, builder);}
    return (A)this;
  }
  
  public A addToReceivers(io.fabric8.openshift.api.model.monitoring.v1beta1.Receiver... items) {
    if (this.receivers == null) {this.receivers = new ArrayList<ReceiverBuilder>();}
    for (Receiver item : items) {ReceiverBuilder builder = new ReceiverBuilder(item);_visitables.get("receivers").add(builder);this.receivers.add(builder);} return (A)this;
  }
  
  public A addAllToReceivers(Collection<Receiver> items) {
    if (this.receivers == null) {this.receivers = new ArrayList<ReceiverBuilder>();}
    for (Receiver item : items) {ReceiverBuilder builder = new ReceiverBuilder(item);_visitables.get("receivers").add(builder);this.receivers.add(builder);} return (A)this;
  }
  
  public A removeFromReceivers(io.fabric8.openshift.api.model.monitoring.v1beta1.Receiver... items) {
    if (this.receivers == null) return (A)this;
    for (Receiver item : items) {ReceiverBuilder builder = new ReceiverBuilder(item);_visitables.get("receivers").remove(builder); this.receivers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromReceivers(Collection<Receiver> items) {
    if (this.receivers == null) return (A)this;
    for (Receiver item : items) {ReceiverBuilder builder = new ReceiverBuilder(item);_visitables.get("receivers").remove(builder); this.receivers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromReceivers(Predicate<ReceiverBuilder> predicate) {
    if (receivers == null) return (A) this;
    final Iterator<ReceiverBuilder> each = receivers.iterator();
    final List visitables = _visitables.get("receivers");
    while (each.hasNext()) {
      ReceiverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Receiver> buildReceivers() {
    return this.receivers != null ? build(receivers) : null;
  }
  
  public Receiver buildReceiver(int index) {
    return this.receivers.get(index).build();
  }
  
  public Receiver buildFirstReceiver() {
    return this.receivers.get(0).build();
  }
  
  public Receiver buildLastReceiver() {
    return this.receivers.get(receivers.size() - 1).build();
  }
  
  public Receiver buildMatchingReceiver(Predicate<ReceiverBuilder> predicate) {
      for (ReceiverBuilder item : receivers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingReceiver(Predicate<ReceiverBuilder> predicate) {
      for (ReceiverBuilder item : receivers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withReceivers(List<Receiver> receivers) {
    if (this.receivers != null) {
      this._visitables.get("receivers").clear();
    }
    if (receivers != null) {
        this.receivers = new ArrayList();
        for (Receiver item : receivers) {
          this.addToReceivers(item);
        }
    } else {
      this.receivers = null;
    }
    return (A) this;
  }
  
  public A withReceivers(io.fabric8.openshift.api.model.monitoring.v1beta1.Receiver... receivers) {
    if (this.receivers != null) {
        this.receivers.clear();
        _visitables.remove("receivers");
    }
    if (receivers != null) {
      for (Receiver item : receivers) {
        this.addToReceivers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasReceivers() {
    return this.receivers != null && !this.receivers.isEmpty();
  }
  
  public ReceiversNested<A> addNewReceiver() {
    return new ReceiversNested(-1, null);
  }
  
  public ReceiversNested<A> addNewReceiverLike(Receiver item) {
    return new ReceiversNested(-1, item);
  }
  
  public ReceiversNested<A> setNewReceiverLike(int index,Receiver item) {
    return new ReceiversNested(index, item);
  }
  
  public ReceiversNested<A> editReceiver(int index) {
    if (receivers.size() <= index) throw new RuntimeException("Can't edit receivers. Index exceeds size.");
    return setNewReceiverLike(index, buildReceiver(index));
  }
  
  public ReceiversNested<A> editFirstReceiver() {
    if (receivers.size() == 0) throw new RuntimeException("Can't edit first receivers. The list is empty.");
    return setNewReceiverLike(0, buildReceiver(0));
  }
  
  public ReceiversNested<A> editLastReceiver() {
    int index = receivers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last receivers. The list is empty.");
    return setNewReceiverLike(index, buildReceiver(index));
  }
  
  public ReceiversNested<A> editMatchingReceiver(Predicate<ReceiverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<receivers.size();i++) { 
    if (predicate.test(receivers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching receivers. No match found.");
    return setNewReceiverLike(index, buildReceiver(index));
  }
  
  public Route buildRoute() {
    return this.route != null ? this.route.build() : null;
  }
  
  public A withRoute(Route route) {
    this._visitables.remove("route");
    if (route != null) {
        this.route = new RouteBuilder(route);
        this._visitables.get("route").add(this.route);
    } else {
        this.route = null;
        this._visitables.get("route").remove(this.route);
    }
    return (A) this;
  }
  
  public boolean hasRoute() {
    return this.route != null;
  }
  
  public RouteNested<A> withNewRoute() {
    return new RouteNested(null);
  }
  
  public RouteNested<A> withNewRouteLike(Route item) {
    return new RouteNested(item);
  }
  
  public RouteNested<A> editRoute() {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(null));
  }
  
  public RouteNested<A> editOrNewRoute() {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(new RouteBuilder().build()));
  }
  
  public RouteNested<A> editOrNewRouteLike(Route item) {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(item));
  }
  
  public A addToTimeIntervals(int index,TimeInterval item) {
    if (this.timeIntervals == null) {this.timeIntervals = new ArrayList<TimeIntervalBuilder>();}
    TimeIntervalBuilder builder = new TimeIntervalBuilder(item);
    if (index < 0 || index >= timeIntervals.size()) { _visitables.get("timeIntervals").add(builder); timeIntervals.add(builder); } else { _visitables.get("timeIntervals").add(index, builder); timeIntervals.add(index, builder);}
    return (A)this;
  }
  
  public A setToTimeIntervals(int index,TimeInterval item) {
    if (this.timeIntervals == null) {this.timeIntervals = new ArrayList<TimeIntervalBuilder>();}
    TimeIntervalBuilder builder = new TimeIntervalBuilder(item);
    if (index < 0 || index >= timeIntervals.size()) { _visitables.get("timeIntervals").add(builder); timeIntervals.add(builder); } else { _visitables.get("timeIntervals").set(index, builder); timeIntervals.set(index, builder);}
    return (A)this;
  }
  
  public A addToTimeIntervals(io.fabric8.openshift.api.model.monitoring.v1beta1.TimeInterval... items) {
    if (this.timeIntervals == null) {this.timeIntervals = new ArrayList<TimeIntervalBuilder>();}
    for (TimeInterval item : items) {TimeIntervalBuilder builder = new TimeIntervalBuilder(item);_visitables.get("timeIntervals").add(builder);this.timeIntervals.add(builder);} return (A)this;
  }
  
  public A addAllToTimeIntervals(Collection<TimeInterval> items) {
    if (this.timeIntervals == null) {this.timeIntervals = new ArrayList<TimeIntervalBuilder>();}
    for (TimeInterval item : items) {TimeIntervalBuilder builder = new TimeIntervalBuilder(item);_visitables.get("timeIntervals").add(builder);this.timeIntervals.add(builder);} return (A)this;
  }
  
  public A removeFromTimeIntervals(io.fabric8.openshift.api.model.monitoring.v1beta1.TimeInterval... items) {
    if (this.timeIntervals == null) return (A)this;
    for (TimeInterval item : items) {TimeIntervalBuilder builder = new TimeIntervalBuilder(item);_visitables.get("timeIntervals").remove(builder); this.timeIntervals.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTimeIntervals(Collection<TimeInterval> items) {
    if (this.timeIntervals == null) return (A)this;
    for (TimeInterval item : items) {TimeIntervalBuilder builder = new TimeIntervalBuilder(item);_visitables.get("timeIntervals").remove(builder); this.timeIntervals.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTimeIntervals(Predicate<TimeIntervalBuilder> predicate) {
    if (timeIntervals == null) return (A) this;
    final Iterator<TimeIntervalBuilder> each = timeIntervals.iterator();
    final List visitables = _visitables.get("timeIntervals");
    while (each.hasNext()) {
      TimeIntervalBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TimeInterval> buildTimeIntervals() {
    return this.timeIntervals != null ? build(timeIntervals) : null;
  }
  
  public TimeInterval buildTimeInterval(int index) {
    return this.timeIntervals.get(index).build();
  }
  
  public TimeInterval buildFirstTimeInterval() {
    return this.timeIntervals.get(0).build();
  }
  
  public TimeInterval buildLastTimeInterval() {
    return this.timeIntervals.get(timeIntervals.size() - 1).build();
  }
  
  public TimeInterval buildMatchingTimeInterval(Predicate<TimeIntervalBuilder> predicate) {
      for (TimeIntervalBuilder item : timeIntervals) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTimeInterval(Predicate<TimeIntervalBuilder> predicate) {
      for (TimeIntervalBuilder item : timeIntervals) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTimeIntervals(List<TimeInterval> timeIntervals) {
    if (this.timeIntervals != null) {
      this._visitables.get("timeIntervals").clear();
    }
    if (timeIntervals != null) {
        this.timeIntervals = new ArrayList();
        for (TimeInterval item : timeIntervals) {
          this.addToTimeIntervals(item);
        }
    } else {
      this.timeIntervals = null;
    }
    return (A) this;
  }
  
  public A withTimeIntervals(io.fabric8.openshift.api.model.monitoring.v1beta1.TimeInterval... timeIntervals) {
    if (this.timeIntervals != null) {
        this.timeIntervals.clear();
        _visitables.remove("timeIntervals");
    }
    if (timeIntervals != null) {
      for (TimeInterval item : timeIntervals) {
        this.addToTimeIntervals(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTimeIntervals() {
    return this.timeIntervals != null && !this.timeIntervals.isEmpty();
  }
  
  public TimeIntervalsNested<A> addNewTimeInterval() {
    return new TimeIntervalsNested(-1, null);
  }
  
  public TimeIntervalsNested<A> addNewTimeIntervalLike(TimeInterval item) {
    return new TimeIntervalsNested(-1, item);
  }
  
  public TimeIntervalsNested<A> setNewTimeIntervalLike(int index,TimeInterval item) {
    return new TimeIntervalsNested(index, item);
  }
  
  public TimeIntervalsNested<A> editTimeInterval(int index) {
    if (timeIntervals.size() <= index) throw new RuntimeException("Can't edit timeIntervals. Index exceeds size.");
    return setNewTimeIntervalLike(index, buildTimeInterval(index));
  }
  
  public TimeIntervalsNested<A> editFirstTimeInterval() {
    if (timeIntervals.size() == 0) throw new RuntimeException("Can't edit first timeIntervals. The list is empty.");
    return setNewTimeIntervalLike(0, buildTimeInterval(0));
  }
  
  public TimeIntervalsNested<A> editLastTimeInterval() {
    int index = timeIntervals.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last timeIntervals. The list is empty.");
    return setNewTimeIntervalLike(index, buildTimeInterval(index));
  }
  
  public TimeIntervalsNested<A> editMatchingTimeInterval(Predicate<TimeIntervalBuilder> predicate) {
    int index = -1;
    for (int i=0;i<timeIntervals.size();i++) { 
    if (predicate.test(timeIntervals.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching timeIntervals. No match found.");
    return setNewTimeIntervalLike(index, buildTimeInterval(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlertmanagerConfigSpecFluent that = (AlertmanagerConfigSpecFluent) o;
    if (!java.util.Objects.equals(inhibitRules, that.inhibitRules)) return false;
    if (!java.util.Objects.equals(receivers, that.receivers)) return false;
    if (!java.util.Objects.equals(route, that.route)) return false;
    if (!java.util.Objects.equals(timeIntervals, that.timeIntervals)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(inhibitRules,  receivers,  route,  timeIntervals,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (inhibitRules != null && !inhibitRules.isEmpty()) { sb.append("inhibitRules:"); sb.append(inhibitRules + ","); }
    if (receivers != null && !receivers.isEmpty()) { sb.append("receivers:"); sb.append(receivers + ","); }
    if (route != null) { sb.append("route:"); sb.append(route + ","); }
    if (timeIntervals != null && !timeIntervals.isEmpty()) { sb.append("timeIntervals:"); sb.append(timeIntervals + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class InhibitRulesNested<N> extends InhibitRuleFluent<InhibitRulesNested<N>> implements Nested<N>{
    InhibitRulesNested(int index,InhibitRule item) {
      this.index = index;
      this.builder = new InhibitRuleBuilder(this, item);
    }
    InhibitRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertmanagerConfigSpecFluent.this.setToInhibitRules(index,builder.build());
    }
    
    public N endInhibitRule() {
      return and();
    }
    
  
  }
  public class ReceiversNested<N> extends ReceiverFluent<ReceiversNested<N>> implements Nested<N>{
    ReceiversNested(int index,Receiver item) {
      this.index = index;
      this.builder = new ReceiverBuilder(this, item);
    }
    ReceiverBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertmanagerConfigSpecFluent.this.setToReceivers(index,builder.build());
    }
    
    public N endReceiver() {
      return and();
    }
    
  
  }
  public class RouteNested<N> extends RouteFluent<RouteNested<N>> implements Nested<N>{
    RouteNested(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteBuilder builder;
    
    public N and() {
      return (N) AlertmanagerConfigSpecFluent.this.withRoute(builder.build());
    }
    
    public N endRoute() {
      return and();
    }
    
  
  }
  public class TimeIntervalsNested<N> extends TimeIntervalFluent<TimeIntervalsNested<N>> implements Nested<N>{
    TimeIntervalsNested(int index,TimeInterval item) {
      this.index = index;
      this.builder = new TimeIntervalBuilder(this, item);
    }
    TimeIntervalBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertmanagerConfigSpecFluent.this.setToTimeIntervals(index,builder.build());
    }
    
    public N endTimeInterval() {
      return and();
    }
    
  
  }

}