package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureADBuilder extends AzureADFluent<AzureADBuilder> implements VisitableBuilder<AzureAD,AzureADBuilder>{
  public AzureADBuilder() {
    this(new AzureAD());
  }
  
  public AzureADBuilder(AzureADFluent<?> fluent) {
    this(fluent, new AzureAD());
  }
  
  public AzureADBuilder(AzureADFluent<?> fluent,AzureAD instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureADBuilder(AzureAD instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureADFluent<?> fluent;
  
  public AzureAD build() {
    AzureAD buildable = new AzureAD(fluent.getCloud(),fluent.buildManagedIdentity(),fluent.buildOauth(),fluent.buildSdk());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}