package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProxyConfigFluent<A extends ProxyConfigFluent<A>> extends BaseFluent<A>{
  public ProxyConfigFluent() {
  }
  
  public ProxyConfigFluent(ProxyConfig instance) {
    this.copyInstance(instance);
  }
  private String noProxy;
  private Map<String,List<SecretKeySelector>> proxyConnectHeader;
  private Boolean proxyFromEnvironment;
  private String proxyUrl;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProxyConfig instance) {
    instance = (instance != null ? instance : new ProxyConfig());
    if (instance != null) {
          this.withNoProxy(instance.getNoProxy());
          this.withProxyConnectHeader(instance.getProxyConnectHeader());
          this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
          this.withProxyUrl(instance.getProxyUrl());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getNoProxy() {
    return this.noProxy;
  }
  
  public A withNoProxy(String noProxy) {
    this.noProxy = noProxy;
    return (A) this;
  }
  
  public boolean hasNoProxy() {
    return this.noProxy != null;
  }
  
  public A addToProxyConnectHeader(String key,List<SecretKeySelector> value) {
    if(this.proxyConnectHeader == null && key != null && value != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(key != null && value != null) {this.proxyConnectHeader.put(key, value);} return (A)this;
  }
  
  public A addToProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null && map != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(map != null) { this.proxyConnectHeader.putAll(map);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(String key) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(key != null && this.proxyConnectHeader != null) {this.proxyConnectHeader.remove(key);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.proxyConnectHeader != null){this.proxyConnectHeader.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<SecretKeySelector>> getProxyConnectHeader() {
    return this.proxyConnectHeader;
  }
  
  public <K,V>A withProxyConnectHeader(Map<String,List<SecretKeySelector>> proxyConnectHeader) {
    if (proxyConnectHeader == null) {
      this.proxyConnectHeader = null;
    } else {
      this.proxyConnectHeader = new LinkedHashMap(proxyConnectHeader);
    }
    return (A) this;
  }
  
  public boolean hasProxyConnectHeader() {
    return this.proxyConnectHeader != null;
  }
  
  public Boolean getProxyFromEnvironment() {
    return this.proxyFromEnvironment;
  }
  
  public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
    this.proxyFromEnvironment = proxyFromEnvironment;
    return (A) this;
  }
  
  public boolean hasProxyFromEnvironment() {
    return this.proxyFromEnvironment != null;
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProxyConfigFluent that = (ProxyConfigFluent) o;
    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;
    if (!java.util.Objects.equals(proxyConnectHeader, that.proxyConnectHeader)) return false;
    if (!java.util.Objects.equals(proxyFromEnvironment, that.proxyFromEnvironment)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(noProxy,  proxyConnectHeader,  proxyFromEnvironment,  proxyUrl,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (proxyConnectHeader != null && !proxyConnectHeader.isEmpty()) { sb.append("proxyConnectHeader:"); sb.append(proxyConnectHeader + ","); }
    if (proxyFromEnvironment != null) { sb.append("proxyFromEnvironment:"); sb.append(proxyFromEnvironment + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withProxyFromEnvironment() {
    return withProxyFromEnvironment(true);
  }
  

}