package io.fabric8.openshift.api.model.monitoring.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import java.util.List;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ThanosRulerSpecFluent<A extends ThanosRulerSpecFluent<A>> extends BaseFluent<A>{
  public ThanosRulerSpecFluent() {
  }
  
  public ThanosRulerSpecFluent(ThanosRulerSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ArgumentBuilder> additionalArgs = new ArrayList<ArgumentBuilder>();
  private Affinity affinity;
  private List<String> alertDropLabels = new ArrayList<String>();
  private String alertQueryUrl;
  private String alertRelabelConfigFile;
  private SecretKeySelector alertRelabelConfigs;
  private SecretKeySelector alertmanagersConfig;
  private List<String> alertmanagersUrl = new ArrayList<String>();
  private ArrayList<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
  private PodDNSConfigBuilder dnsConfig;
  private String dnsPolicy;
  private String enforcedNamespaceLabel;
  private String evaluationInterval;
  private ArrayList<ObjectReferenceBuilder> excludedFromEnforcement = new ArrayList<ObjectReferenceBuilder>();
  private String externalPrefix;
  private TLSConfigBuilder grpcServerTlsConfig;
  private ArrayList<HostAliasBuilder> hostAliases = new ArrayList<HostAliasBuilder>();
  private String image;
  private String imagePullPolicy;
  private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private Map<String,String> labels;
  private Boolean listenLocal;
  private String logFormat;
  private String logLevel;
  private Long minReadySeconds;
  private Map<String,String> nodeSelector;
  private SecretKeySelector objectStorageConfig;
  private String objectStorageConfigFile;
  private Boolean paused;
  private EmbeddedObjectMetadataBuilder podMetadata;
  private String portName;
  private String priorityClassName;
  private ArrayList<PrometheusRuleExcludeConfigBuilder> prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();
  private SecretKeySelector queryConfig;
  private List<String> queryEndpoints = new ArrayList<String>();
  private Integer replicas;
  private ResourceRequirementsBuilder resources;
  private String retention;
  private String routePrefix;
  private LabelSelectorBuilder ruleNamespaceSelector;
  private LabelSelectorBuilder ruleSelector;
  private PodSecurityContext securityContext;
  private String serviceAccountName;
  private StorageSpecBuilder storage;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
  private SecretKeySelector tracingConfig;
  private String tracingConfigFile;
  private String version;
  private ArrayList<VolumeMountBuilder> volumeMounts = new ArrayList<VolumeMountBuilder>();
  private ArrayList<VolumeBuilder> volumes = new ArrayList<VolumeBuilder>();
  private ThanosRulerWebSpecBuilder web;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ThanosRulerSpec instance) {
    instance = (instance != null ? instance : new ThanosRulerSpec());
    if (instance != null) {
          this.withAdditionalArgs(instance.getAdditionalArgs());
          this.withAffinity(instance.getAffinity());
          this.withAlertDropLabels(instance.getAlertDropLabels());
          this.withAlertQueryUrl(instance.getAlertQueryUrl());
          this.withAlertRelabelConfigFile(instance.getAlertRelabelConfigFile());
          this.withAlertRelabelConfigs(instance.getAlertRelabelConfigs());
          this.withAlertmanagersConfig(instance.getAlertmanagersConfig());
          this.withAlertmanagersUrl(instance.getAlertmanagersUrl());
          this.withContainers(instance.getContainers());
          this.withDnsConfig(instance.getDnsConfig());
          this.withDnsPolicy(instance.getDnsPolicy());
          this.withEnforcedNamespaceLabel(instance.getEnforcedNamespaceLabel());
          this.withEvaluationInterval(instance.getEvaluationInterval());
          this.withExcludedFromEnforcement(instance.getExcludedFromEnforcement());
          this.withExternalPrefix(instance.getExternalPrefix());
          this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
          this.withHostAliases(instance.getHostAliases());
          this.withImage(instance.getImage());
          this.withImagePullPolicy(instance.getImagePullPolicy());
          this.withImagePullSecrets(instance.getImagePullSecrets());
          this.withInitContainers(instance.getInitContainers());
          this.withLabels(instance.getLabels());
          this.withListenLocal(instance.getListenLocal());
          this.withLogFormat(instance.getLogFormat());
          this.withLogLevel(instance.getLogLevel());
          this.withMinReadySeconds(instance.getMinReadySeconds());
          this.withNodeSelector(instance.getNodeSelector());
          this.withObjectStorageConfig(instance.getObjectStorageConfig());
          this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile());
          this.withPaused(instance.getPaused());
          this.withPodMetadata(instance.getPodMetadata());
          this.withPortName(instance.getPortName());
          this.withPriorityClassName(instance.getPriorityClassName());
          this.withPrometheusRulesExcludedFromEnforce(instance.getPrometheusRulesExcludedFromEnforce());
          this.withQueryConfig(instance.getQueryConfig());
          this.withQueryEndpoints(instance.getQueryEndpoints());
          this.withReplicas(instance.getReplicas());
          this.withResources(instance.getResources());
          this.withRetention(instance.getRetention());
          this.withRoutePrefix(instance.getRoutePrefix());
          this.withRuleNamespaceSelector(instance.getRuleNamespaceSelector());
          this.withRuleSelector(instance.getRuleSelector());
          this.withSecurityContext(instance.getSecurityContext());
          this.withServiceAccountName(instance.getServiceAccountName());
          this.withStorage(instance.getStorage());
          this.withTolerations(instance.getTolerations());
          this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
          this.withTracingConfig(instance.getTracingConfig());
          this.withTracingConfigFile(instance.getTracingConfigFile());
          this.withVersion(instance.getVersion());
          this.withVolumeMounts(instance.getVolumeMounts());
          this.withVolumes(instance.getVolumes());
          this.withWeb(instance.getWeb());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAdditionalArgs(int index,Argument item) {
    if (this.additionalArgs == null) {this.additionalArgs = new ArrayList<ArgumentBuilder>();}
    ArgumentBuilder builder = new ArgumentBuilder(item);
    if (index < 0 || index >= additionalArgs.size()) {
        _visitables.get("additionalArgs").add(builder);
        additionalArgs.add(builder);
    } else {
        _visitables.get("additionalArgs").add(builder);
        additionalArgs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToAdditionalArgs(int index,Argument item) {
    if (this.additionalArgs == null) {this.additionalArgs = new ArrayList<ArgumentBuilder>();}
    ArgumentBuilder builder = new ArgumentBuilder(item);
    if (index < 0 || index >= additionalArgs.size()) {
        _visitables.get("additionalArgs").add(builder);
        additionalArgs.add(builder);
    } else {
        _visitables.get("additionalArgs").add(builder);
        additionalArgs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToAdditionalArgs(io.fabric8.openshift.api.model.monitoring.v1.Argument... items) {
    if (this.additionalArgs == null) {this.additionalArgs = new ArrayList<ArgumentBuilder>();}
    for (Argument item : items) {ArgumentBuilder builder = new ArgumentBuilder(item);_visitables.get("additionalArgs").add(builder);this.additionalArgs.add(builder);} return (A)this;
  }
  
  public A addAllToAdditionalArgs(Collection<Argument> items) {
    if (this.additionalArgs == null) {this.additionalArgs = new ArrayList<ArgumentBuilder>();}
    for (Argument item : items) {ArgumentBuilder builder = new ArgumentBuilder(item);_visitables.get("additionalArgs").add(builder);this.additionalArgs.add(builder);} return (A)this;
  }
  
  public A removeFromAdditionalArgs(io.fabric8.openshift.api.model.monitoring.v1.Argument... items) {
    if (this.additionalArgs == null) return (A)this;
    for (Argument item : items) {ArgumentBuilder builder = new ArgumentBuilder(item);_visitables.get("additionalArgs").remove(builder); this.additionalArgs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAdditionalArgs(Collection<Argument> items) {
    if (this.additionalArgs == null) return (A)this;
    for (Argument item : items) {ArgumentBuilder builder = new ArgumentBuilder(item);_visitables.get("additionalArgs").remove(builder); this.additionalArgs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAdditionalArgs(Predicate<ArgumentBuilder> predicate) {
    if (additionalArgs == null) return (A) this;
    final Iterator<ArgumentBuilder> each = additionalArgs.iterator();
    final List visitables = _visitables.get("additionalArgs");
    while (each.hasNext()) {
      ArgumentBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Argument> buildAdditionalArgs() {
    return this.additionalArgs != null ? build(additionalArgs) : null;
  }
  
  public Argument buildAdditionalArg(int index) {
    return this.additionalArgs.get(index).build();
  }
  
  public Argument buildFirstAdditionalArg() {
    return this.additionalArgs.get(0).build();
  }
  
  public Argument buildLastAdditionalArg() {
    return this.additionalArgs.get(additionalArgs.size() - 1).build();
  }
  
  public Argument buildMatchingAdditionalArg(Predicate<ArgumentBuilder> predicate) {
      for (ArgumentBuilder item : additionalArgs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalArg(Predicate<ArgumentBuilder> predicate) {
      for (ArgumentBuilder item : additionalArgs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalArgs(List<Argument> additionalArgs) {
    if (this.additionalArgs != null) {
      this._visitables.get("additionalArgs").clear();
    }
    if (additionalArgs != null) {
        this.additionalArgs = new ArrayList();
        for (Argument item : additionalArgs) {
          this.addToAdditionalArgs(item);
        }
    } else {
      this.additionalArgs = null;
    }
    return (A) this;
  }
  
  public A withAdditionalArgs(io.fabric8.openshift.api.model.monitoring.v1.Argument... additionalArgs) {
    if (this.additionalArgs != null) {
        this.additionalArgs.clear();
        _visitables.remove("additionalArgs");
    }
    if (additionalArgs != null) {
      for (Argument item : additionalArgs) {
        this.addToAdditionalArgs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalArgs() {
    return this.additionalArgs != null && !this.additionalArgs.isEmpty();
  }
  
  public A addNewAdditionalArg(String name,String value) {
    return (A)addToAdditionalArgs(new Argument(name, value));
  }
  
  public AdditionalArgsNested<A> addNewAdditionalArg() {
    return new AdditionalArgsNested(-1, null);
  }
  
  public AdditionalArgsNested<A> addNewAdditionalArgLike(Argument item) {
    return new AdditionalArgsNested(-1, item);
  }
  
  public AdditionalArgsNested<A> setNewAdditionalArgLike(int index,Argument item) {
    return new AdditionalArgsNested(index, item);
  }
  
  public AdditionalArgsNested<A> editAdditionalArg(int index) {
    if (additionalArgs.size() <= index) throw new RuntimeException("Can't edit additionalArgs. Index exceeds size.");
    return setNewAdditionalArgLike(index, buildAdditionalArg(index));
  }
  
  public AdditionalArgsNested<A> editFirstAdditionalArg() {
    if (additionalArgs.size() == 0) throw new RuntimeException("Can't edit first additionalArgs. The list is empty.");
    return setNewAdditionalArgLike(0, buildAdditionalArg(0));
  }
  
  public AdditionalArgsNested<A> editLastAdditionalArg() {
    int index = additionalArgs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalArgs. The list is empty.");
    return setNewAdditionalArgLike(index, buildAdditionalArg(index));
  }
  
  public AdditionalArgsNested<A> editMatchingAdditionalArg(Predicate<ArgumentBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalArgs.size();i++) { 
    if (predicate.test(additionalArgs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalArgs. No match found.");
    return setNewAdditionalArgLike(index, buildAdditionalArg(index));
  }
  
  public Affinity getAffinity() {
    return this.affinity;
  }
  
  public A withAffinity(Affinity affinity) {
    this.affinity = affinity;
    return (A) this;
  }
  
  public boolean hasAffinity() {
    return this.affinity != null;
  }
  
  public A addToAlertDropLabels(int index,String item) {
    if (this.alertDropLabels == null) {this.alertDropLabels = new ArrayList<String>();}
    this.alertDropLabels.add(index, item);
    return (A)this;
  }
  
  public A setToAlertDropLabels(int index,String item) {
    if (this.alertDropLabels == null) {this.alertDropLabels = new ArrayList<String>();}
    this.alertDropLabels.set(index, item); return (A)this;
  }
  
  public A addToAlertDropLabels(java.lang.String... items) {
    if (this.alertDropLabels == null) {this.alertDropLabels = new ArrayList<String>();}
    for (String item : items) {this.alertDropLabels.add(item);} return (A)this;
  }
  
  public A addAllToAlertDropLabels(Collection<String> items) {
    if (this.alertDropLabels == null) {this.alertDropLabels = new ArrayList<String>();}
    for (String item : items) {this.alertDropLabels.add(item);} return (A)this;
  }
  
  public A removeFromAlertDropLabels(java.lang.String... items) {
    if (this.alertDropLabels == null) return (A)this;
    for (String item : items) { this.alertDropLabels.remove(item);} return (A)this;
  }
  
  public A removeAllFromAlertDropLabels(Collection<String> items) {
    if (this.alertDropLabels == null) return (A)this;
    for (String item : items) { this.alertDropLabels.remove(item);} return (A)this;
  }
  
  public List<String> getAlertDropLabels() {
    return this.alertDropLabels;
  }
  
  public String getAlertDropLabel(int index) {
    return this.alertDropLabels.get(index);
  }
  
  public String getFirstAlertDropLabel() {
    return this.alertDropLabels.get(0);
  }
  
  public String getLastAlertDropLabel() {
    return this.alertDropLabels.get(alertDropLabels.size() - 1);
  }
  
  public String getMatchingAlertDropLabel(Predicate<String> predicate) {
      for (String item : alertDropLabels) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAlertDropLabel(Predicate<String> predicate) {
      for (String item : alertDropLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAlertDropLabels(List<String> alertDropLabels) {
    if (alertDropLabels != null) {
        this.alertDropLabels = new ArrayList();
        for (String item : alertDropLabels) {
          this.addToAlertDropLabels(item);
        }
    } else {
      this.alertDropLabels = null;
    }
    return (A) this;
  }
  
  public A withAlertDropLabels(java.lang.String... alertDropLabels) {
    if (this.alertDropLabels != null) {
        this.alertDropLabels.clear();
        _visitables.remove("alertDropLabels");
    }
    if (alertDropLabels != null) {
      for (String item : alertDropLabels) {
        this.addToAlertDropLabels(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAlertDropLabels() {
    return this.alertDropLabels != null && !this.alertDropLabels.isEmpty();
  }
  
  public String getAlertQueryUrl() {
    return this.alertQueryUrl;
  }
  
  public A withAlertQueryUrl(String alertQueryUrl) {
    this.alertQueryUrl = alertQueryUrl;
    return (A) this;
  }
  
  public boolean hasAlertQueryUrl() {
    return this.alertQueryUrl != null;
  }
  
  public String getAlertRelabelConfigFile() {
    return this.alertRelabelConfigFile;
  }
  
  public A withAlertRelabelConfigFile(String alertRelabelConfigFile) {
    this.alertRelabelConfigFile = alertRelabelConfigFile;
    return (A) this;
  }
  
  public boolean hasAlertRelabelConfigFile() {
    return this.alertRelabelConfigFile != null;
  }
  
  public SecretKeySelector getAlertRelabelConfigs() {
    return this.alertRelabelConfigs;
  }
  
  public A withAlertRelabelConfigs(SecretKeySelector alertRelabelConfigs) {
    this.alertRelabelConfigs = alertRelabelConfigs;
    return (A) this;
  }
  
  public boolean hasAlertRelabelConfigs() {
    return this.alertRelabelConfigs != null;
  }
  
  public A withNewAlertRelabelConfigs(String key,String name,Boolean optional) {
    return (A)withAlertRelabelConfigs(new SecretKeySelector(key, name, optional));
  }
  
  public SecretKeySelector getAlertmanagersConfig() {
    return this.alertmanagersConfig;
  }
  
  public A withAlertmanagersConfig(SecretKeySelector alertmanagersConfig) {
    this.alertmanagersConfig = alertmanagersConfig;
    return (A) this;
  }
  
  public boolean hasAlertmanagersConfig() {
    return this.alertmanagersConfig != null;
  }
  
  public A withNewAlertmanagersConfig(String key,String name,Boolean optional) {
    return (A)withAlertmanagersConfig(new SecretKeySelector(key, name, optional));
  }
  
  public A addToAlertmanagersUrl(int index,String item) {
    if (this.alertmanagersUrl == null) {this.alertmanagersUrl = new ArrayList<String>();}
    this.alertmanagersUrl.add(index, item);
    return (A)this;
  }
  
  public A setToAlertmanagersUrl(int index,String item) {
    if (this.alertmanagersUrl == null) {this.alertmanagersUrl = new ArrayList<String>();}
    this.alertmanagersUrl.set(index, item); return (A)this;
  }
  
  public A addToAlertmanagersUrl(java.lang.String... items) {
    if (this.alertmanagersUrl == null) {this.alertmanagersUrl = new ArrayList<String>();}
    for (String item : items) {this.alertmanagersUrl.add(item);} return (A)this;
  }
  
  public A addAllToAlertmanagersUrl(Collection<String> items) {
    if (this.alertmanagersUrl == null) {this.alertmanagersUrl = new ArrayList<String>();}
    for (String item : items) {this.alertmanagersUrl.add(item);} return (A)this;
  }
  
  public A removeFromAlertmanagersUrl(java.lang.String... items) {
    if (this.alertmanagersUrl == null) return (A)this;
    for (String item : items) { this.alertmanagersUrl.remove(item);} return (A)this;
  }
  
  public A removeAllFromAlertmanagersUrl(Collection<String> items) {
    if (this.alertmanagersUrl == null) return (A)this;
    for (String item : items) { this.alertmanagersUrl.remove(item);} return (A)this;
  }
  
  public List<String> getAlertmanagersUrl() {
    return this.alertmanagersUrl;
  }
  
  public String getAlertmanagersUrl(int index) {
    return this.alertmanagersUrl.get(index);
  }
  
  public String getFirstAlertmanagersUrl() {
    return this.alertmanagersUrl.get(0);
  }
  
  public String getLastAlertmanagersUrl() {
    return this.alertmanagersUrl.get(alertmanagersUrl.size() - 1);
  }
  
  public String getMatchingAlertmanagersUrl(Predicate<String> predicate) {
      for (String item : alertmanagersUrl) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAlertmanagersUrl(Predicate<String> predicate) {
      for (String item : alertmanagersUrl) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAlertmanagersUrl(List<String> alertmanagersUrl) {
    if (alertmanagersUrl != null) {
        this.alertmanagersUrl = new ArrayList();
        for (String item : alertmanagersUrl) {
          this.addToAlertmanagersUrl(item);
        }
    } else {
      this.alertmanagersUrl = null;
    }
    return (A) this;
  }
  
  public A withAlertmanagersUrl(java.lang.String... alertmanagersUrl) {
    if (this.alertmanagersUrl != null) {
        this.alertmanagersUrl.clear();
        _visitables.remove("alertmanagersUrl");
    }
    if (alertmanagersUrl != null) {
      for (String item : alertmanagersUrl) {
        this.addToAlertmanagersUrl(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAlertmanagersUrl() {
    return this.alertmanagersUrl != null && !this.alertmanagersUrl.isEmpty();
  }
  
  public A addToContainers(int index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= containers.size()) {
        _visitables.get("containers").add(builder);
        containers.add(builder);
    } else {
        _visitables.get("containers").add(builder);
        containers.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToContainers(int index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= containers.size()) {
        _visitables.get("containers").add(builder);
        containers.add(builder);
    } else {
        _visitables.get("containers").add(builder);
        containers.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  
  public A addAllToContainers(Collection<Container> items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder); this.containers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromContainers(Collection<Container> items) {
    if (this.containers == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder); this.containers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Container> buildContainers() {
    return this.containers != null ? build(containers) : null;
  }
  
  public Container buildContainer(int index) {
    return this.containers.get(index).build();
  }
  
  public Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  
  public Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : containers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : containers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withContainers(List<Container> containers) {
    if (this.containers != null) {
      this._visitables.get("containers").clear();
    }
    if (containers != null) {
        this.containers = new ArrayList();
        for (Container item : containers) {
          this.addToContainers(item);
        }
    } else {
      this.containers = null;
    }
    return (A) this;
  }
  
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers) {
    if (this.containers != null) {
        this.containers.clear();
        _visitables.remove("containers");
    }
    if (containers != null) {
      for (Container item : containers) {
        this.addToContainers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasContainers() {
    return this.containers != null && !this.containers.isEmpty();
  }
  
  public ContainersNested<A> addNewContainer() {
    return new ContainersNested(-1, null);
  }
  
  public ContainersNested<A> addNewContainerLike(Container item) {
    return new ContainersNested(-1, item);
  }
  
  public ContainersNested<A> setNewContainerLike(int index,Container item) {
    return new ContainersNested(index, item);
  }
  
  public ContainersNested<A> editContainer(int index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  
  public ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  
  public ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  
  public ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  
  public PodDNSConfig buildDnsConfig() {
    return this.dnsConfig != null ? this.dnsConfig.build() : null;
  }
  
  public A withDnsConfig(PodDNSConfig dnsConfig) {
    this._visitables.remove("dnsConfig");
    if (dnsConfig != null) {
        this.dnsConfig = new PodDNSConfigBuilder(dnsConfig);
        this._visitables.get("dnsConfig").add(this.dnsConfig);
    } else {
        this.dnsConfig = null;
        this._visitables.get("dnsConfig").remove(this.dnsConfig);
    }
    return (A) this;
  }
  
  public boolean hasDnsConfig() {
    return this.dnsConfig != null;
  }
  
  public DnsConfigNested<A> withNewDnsConfig() {
    return new DnsConfigNested(null);
  }
  
  public DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item) {
    return new DnsConfigNested(item);
  }
  
  public DnsConfigNested<A> editDnsConfig() {
    return withNewDnsConfigLike(java.util.Optional.ofNullable(buildDnsConfig()).orElse(null));
  }
  
  public DnsConfigNested<A> editOrNewDnsConfig() {
    return withNewDnsConfigLike(java.util.Optional.ofNullable(buildDnsConfig()).orElse(new PodDNSConfigBuilder().build()));
  }
  
  public DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item) {
    return withNewDnsConfigLike(java.util.Optional.ofNullable(buildDnsConfig()).orElse(item));
  }
  
  public String getDnsPolicy() {
    return this.dnsPolicy;
  }
  
  public A withDnsPolicy(String dnsPolicy) {
    this.dnsPolicy = dnsPolicy;
    return (A) this;
  }
  
  public boolean hasDnsPolicy() {
    return this.dnsPolicy != null;
  }
  
  public String getEnforcedNamespaceLabel() {
    return this.enforcedNamespaceLabel;
  }
  
  public A withEnforcedNamespaceLabel(String enforcedNamespaceLabel) {
    this.enforcedNamespaceLabel = enforcedNamespaceLabel;
    return (A) this;
  }
  
  public boolean hasEnforcedNamespaceLabel() {
    return this.enforcedNamespaceLabel != null;
  }
  
  public String getEvaluationInterval() {
    return this.evaluationInterval;
  }
  
  public A withEvaluationInterval(String evaluationInterval) {
    this.evaluationInterval = evaluationInterval;
    return (A) this;
  }
  
  public boolean hasEvaluationInterval() {
    return this.evaluationInterval != null;
  }
  
  public A addToExcludedFromEnforcement(int index,ObjectReference item) {
    if (this.excludedFromEnforcement == null) {this.excludedFromEnforcement = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= excludedFromEnforcement.size()) {
        _visitables.get("excludedFromEnforcement").add(builder);
        excludedFromEnforcement.add(builder);
    } else {
        _visitables.get("excludedFromEnforcement").add(builder);
        excludedFromEnforcement.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToExcludedFromEnforcement(int index,ObjectReference item) {
    if (this.excludedFromEnforcement == null) {this.excludedFromEnforcement = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= excludedFromEnforcement.size()) {
        _visitables.get("excludedFromEnforcement").add(builder);
        excludedFromEnforcement.add(builder);
    } else {
        _visitables.get("excludedFromEnforcement").add(builder);
        excludedFromEnforcement.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToExcludedFromEnforcement(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.excludedFromEnforcement == null) {this.excludedFromEnforcement = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("excludedFromEnforcement").add(builder);this.excludedFromEnforcement.add(builder);} return (A)this;
  }
  
  public A addAllToExcludedFromEnforcement(Collection<ObjectReference> items) {
    if (this.excludedFromEnforcement == null) {this.excludedFromEnforcement = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("excludedFromEnforcement").add(builder);this.excludedFromEnforcement.add(builder);} return (A)this;
  }
  
  public A removeFromExcludedFromEnforcement(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.excludedFromEnforcement == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("excludedFromEnforcement").remove(builder); this.excludedFromEnforcement.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExcludedFromEnforcement(Collection<ObjectReference> items) {
    if (this.excludedFromEnforcement == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("excludedFromEnforcement").remove(builder); this.excludedFromEnforcement.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExcludedFromEnforcement(Predicate<ObjectReferenceBuilder> predicate) {
    if (excludedFromEnforcement == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = excludedFromEnforcement.iterator();
    final List visitables = _visitables.get("excludedFromEnforcement");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ObjectReference> buildExcludedFromEnforcement() {
    return this.excludedFromEnforcement != null ? build(excludedFromEnforcement) : null;
  }
  
  public ObjectReference buildExcludedFromEnforcement(int index) {
    return this.excludedFromEnforcement.get(index).build();
  }
  
  public ObjectReference buildFirstExcludedFromEnforcement() {
    return this.excludedFromEnforcement.get(0).build();
  }
  
  public ObjectReference buildLastExcludedFromEnforcement() {
    return this.excludedFromEnforcement.get(excludedFromEnforcement.size() - 1).build();
  }
  
  public ObjectReference buildMatchingExcludedFromEnforcement(Predicate<ObjectReferenceBuilder> predicate) {
      for (ObjectReferenceBuilder item : excludedFromEnforcement) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExcludedFromEnforcement(Predicate<ObjectReferenceBuilder> predicate) {
      for (ObjectReferenceBuilder item : excludedFromEnforcement) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExcludedFromEnforcement(List<ObjectReference> excludedFromEnforcement) {
    if (this.excludedFromEnforcement != null) {
      this._visitables.get("excludedFromEnforcement").clear();
    }
    if (excludedFromEnforcement != null) {
        this.excludedFromEnforcement = new ArrayList();
        for (ObjectReference item : excludedFromEnforcement) {
          this.addToExcludedFromEnforcement(item);
        }
    } else {
      this.excludedFromEnforcement = null;
    }
    return (A) this;
  }
  
  public A withExcludedFromEnforcement(io.fabric8.kubernetes.api.model.ObjectReference... excludedFromEnforcement) {
    if (this.excludedFromEnforcement != null) {
        this.excludedFromEnforcement.clear();
        _visitables.remove("excludedFromEnforcement");
    }
    if (excludedFromEnforcement != null) {
      for (ObjectReference item : excludedFromEnforcement) {
        this.addToExcludedFromEnforcement(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExcludedFromEnforcement() {
    return this.excludedFromEnforcement != null && !this.excludedFromEnforcement.isEmpty();
  }
  
  public ExcludedFromEnforcementNested<A> addNewExcludedFromEnforcement() {
    return new ExcludedFromEnforcementNested(-1, null);
  }
  
  public ExcludedFromEnforcementNested<A> addNewExcludedFromEnforcementLike(ObjectReference item) {
    return new ExcludedFromEnforcementNested(-1, item);
  }
  
  public ExcludedFromEnforcementNested<A> setNewExcludedFromEnforcementLike(int index,ObjectReference item) {
    return new ExcludedFromEnforcementNested(index, item);
  }
  
  public ExcludedFromEnforcementNested<A> editExcludedFromEnforcement(int index) {
    if (excludedFromEnforcement.size() <= index) throw new RuntimeException("Can't edit excludedFromEnforcement. Index exceeds size.");
    return setNewExcludedFromEnforcementLike(index, buildExcludedFromEnforcement(index));
  }
  
  public ExcludedFromEnforcementNested<A> editFirstExcludedFromEnforcement() {
    if (excludedFromEnforcement.size() == 0) throw new RuntimeException("Can't edit first excludedFromEnforcement. The list is empty.");
    return setNewExcludedFromEnforcementLike(0, buildExcludedFromEnforcement(0));
  }
  
  public ExcludedFromEnforcementNested<A> editLastExcludedFromEnforcement() {
    int index = excludedFromEnforcement.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last excludedFromEnforcement. The list is empty.");
    return setNewExcludedFromEnforcementLike(index, buildExcludedFromEnforcement(index));
  }
  
  public ExcludedFromEnforcementNested<A> editMatchingExcludedFromEnforcement(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<excludedFromEnforcement.size();i++) { 
    if (predicate.test(excludedFromEnforcement.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching excludedFromEnforcement. No match found.");
    return setNewExcludedFromEnforcementLike(index, buildExcludedFromEnforcement(index));
  }
  
  public String getExternalPrefix() {
    return this.externalPrefix;
  }
  
  public A withExternalPrefix(String externalPrefix) {
    this.externalPrefix = externalPrefix;
    return (A) this;
  }
  
  public boolean hasExternalPrefix() {
    return this.externalPrefix != null;
  }
  
  public TLSConfig buildGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig != null ? this.grpcServerTlsConfig.build() : null;
  }
  
  public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig) {
    this._visitables.remove("grpcServerTlsConfig");
    if (grpcServerTlsConfig != null) {
        this.grpcServerTlsConfig = new TLSConfigBuilder(grpcServerTlsConfig);
        this._visitables.get("grpcServerTlsConfig").add(this.grpcServerTlsConfig);
    } else {
        this.grpcServerTlsConfig = null;
        this._visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig != null;
  }
  
  public GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig() {
    return new GrpcServerTlsConfigNested(null);
  }
  
  public GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item) {
    return new GrpcServerTlsConfigNested(item);
  }
  
  public GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(java.util.Optional.ofNullable(buildGrpcServerTlsConfig()).orElse(null));
  }
  
  public GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(java.util.Optional.ofNullable(buildGrpcServerTlsConfig()).orElse(new TLSConfigBuilder().build()));
  }
  
  public GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item) {
    return withNewGrpcServerTlsConfigLike(java.util.Optional.ofNullable(buildGrpcServerTlsConfig()).orElse(item));
  }
  
  public A addToHostAliases(int index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    HostAliasBuilder builder = new HostAliasBuilder(item);
    if (index < 0 || index >= hostAliases.size()) {
        _visitables.get("hostAliases").add(builder);
        hostAliases.add(builder);
    } else {
        _visitables.get("hostAliases").add(builder);
        hostAliases.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToHostAliases(int index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    HostAliasBuilder builder = new HostAliasBuilder(item);
    if (index < 0 || index >= hostAliases.size()) {
        _visitables.get("hostAliases").add(builder);
        hostAliases.add(builder);
    } else {
        _visitables.get("hostAliases").add(builder);
        hostAliases.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToHostAliases(io.fabric8.openshift.api.model.monitoring.v1.HostAlias... items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(builder);this.hostAliases.add(builder);} return (A)this;
  }
  
  public A addAllToHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(builder);this.hostAliases.add(builder);} return (A)this;
  }
  
  public A removeFromHostAliases(io.fabric8.openshift.api.model.monitoring.v1.HostAlias... items) {
    if (this.hostAliases == null) return (A)this;
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").remove(builder); this.hostAliases.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) return (A)this;
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").remove(builder); this.hostAliases.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
    if (hostAliases == null) return (A) this;
    final Iterator<HostAliasBuilder> each = hostAliases.iterator();
    final List visitables = _visitables.get("hostAliases");
    while (each.hasNext()) {
      HostAliasBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HostAlias> buildHostAliases() {
    return this.hostAliases != null ? build(hostAliases) : null;
  }
  
  public HostAlias buildHostAlias(int index) {
    return this.hostAliases.get(index).build();
  }
  
  public HostAlias buildFirstHostAlias() {
    return this.hostAliases.get(0).build();
  }
  
  public HostAlias buildLastHostAlias() {
    return this.hostAliases.get(hostAliases.size() - 1).build();
  }
  
  public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
      for (HostAliasBuilder item : hostAliases) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
      for (HostAliasBuilder item : hostAliases) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHostAliases(List<HostAlias> hostAliases) {
    if (this.hostAliases != null) {
      this._visitables.get("hostAliases").clear();
    }
    if (hostAliases != null) {
        this.hostAliases = new ArrayList();
        for (HostAlias item : hostAliases) {
          this.addToHostAliases(item);
        }
    } else {
      this.hostAliases = null;
    }
    return (A) this;
  }
  
  public A withHostAliases(io.fabric8.openshift.api.model.monitoring.v1.HostAlias... hostAliases) {
    if (this.hostAliases != null) {
        this.hostAliases.clear();
        _visitables.remove("hostAliases");
    }
    if (hostAliases != null) {
      for (HostAlias item : hostAliases) {
        this.addToHostAliases(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHostAliases() {
    return this.hostAliases != null && !this.hostAliases.isEmpty();
  }
  
  public HostAliasesNested<A> addNewHostAlias() {
    return new HostAliasesNested(-1, null);
  }
  
  public HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
    return new HostAliasesNested(-1, item);
  }
  
  public HostAliasesNested<A> setNewHostAliasLike(int index,HostAlias item) {
    return new HostAliasesNested(index, item);
  }
  
  public HostAliasesNested<A> editHostAlias(int index) {
    if (hostAliases.size() <= index) throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  
  public HostAliasesNested<A> editFirstHostAlias() {
    if (hostAliases.size() == 0) throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
    return setNewHostAliasLike(0, buildHostAlias(0));
  }
  
  public HostAliasesNested<A> editLastHostAlias() {
    int index = hostAliases.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  
  public HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hostAliases.size();i++) { 
    if (predicate.test(hostAliases.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hostAliases. No match found.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public String getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  
  public A withImagePullPolicy(String imagePullPolicy) {
    this.imagePullPolicy = imagePullPolicy;
    return (A) this;
  }
  
  public boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  
  public A addToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) {
        _visitables.get("imagePullSecrets").add(builder);
        imagePullSecrets.add(builder);
    } else {
        _visitables.get("imagePullSecrets").add(builder);
        imagePullSecrets.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) {
        _visitables.get("imagePullSecrets").add(builder);
        imagePullSecrets.add(builder);
    } else {
        _visitables.get("imagePullSecrets").add(builder);
        imagePullSecrets.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder); this.imagePullSecrets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder); this.imagePullSecrets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalObjectReference> buildImagePullSecrets() {
    return this.imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  
  public LocalObjectReference buildImagePullSecret(int index) {
    return this.imagePullSecrets.get(index).build();
  }
  
  public LocalObjectReference buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  
  public LocalObjectReference buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : imagePullSecrets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : imagePullSecrets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (this.imagePullSecrets != null) {
      this._visitables.get("imagePullSecrets").clear();
    }
    if (imagePullSecrets != null) {
        this.imagePullSecrets = new ArrayList();
        for (LocalObjectReference item : imagePullSecrets) {
          this.addToImagePullSecrets(item);
        }
    } else {
      this.imagePullSecrets = null;
    }
    return (A) this;
  }
  
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {
        this.imagePullSecrets.clear();
        _visitables.remove("imagePullSecrets");
    }
    if (imagePullSecrets != null) {
      for (LocalObjectReference item : imagePullSecrets) {
        this.addToImagePullSecrets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasImagePullSecrets() {
    return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
  }
  
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  
  public ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new ImagePullSecretsNested(-1, null);
  }
  
  public ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
    return new ImagePullSecretsNested(-1, item);
  }
  
  public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item) {
    return new ImagePullSecretsNested(index, item);
  }
  
  public ImagePullSecretsNested<A> editImagePullSecret(int index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  
  public ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  
  public ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  
  public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  
  public A addToInitContainers(int index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= initContainers.size()) {
        _visitables.get("initContainers").add(builder);
        initContainers.add(builder);
    } else {
        _visitables.get("initContainers").add(builder);
        initContainers.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToInitContainers(int index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= initContainers.size()) {
        _visitables.get("initContainers").add(builder);
        initContainers.add(builder);
    } else {
        _visitables.get("initContainers").add(builder);
        initContainers.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder); this.initContainers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInitContainers(Collection<Container> items) {
    if (this.initContainers == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder); this.initContainers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Container> buildInitContainers() {
    return this.initContainers != null ? build(initContainers) : null;
  }
  
  public Container buildInitContainer(int index) {
    return this.initContainers.get(index).build();
  }
  
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : initContainers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : initContainers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withInitContainers(List<Container> initContainers) {
    if (this.initContainers != null) {
      this._visitables.get("initContainers").clear();
    }
    if (initContainers != null) {
        this.initContainers = new ArrayList();
        for (Container item : initContainers) {
          this.addToInitContainers(item);
        }
    } else {
      this.initContainers = null;
    }
    return (A) this;
  }
  
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers) {
    if (this.initContainers != null) {
        this.initContainers.clear();
        _visitables.remove("initContainers");
    }
    if (initContainers != null) {
      for (Container item : initContainers) {
        this.addToInitContainers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasInitContainers() {
    return this.initContainers != null && !this.initContainers.isEmpty();
  }
  
  public InitContainersNested<A> addNewInitContainer() {
    return new InitContainersNested(-1, null);
  }
  
  public InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new InitContainersNested(-1, item);
  }
  
  public InitContainersNested<A> setNewInitContainerLike(int index,Container item) {
    return new InitContainersNested(index, item);
  }
  
  public InitContainersNested<A> editInitContainer(int index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  
  public InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  
  public InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  
  public InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getLabels() {
    return this.labels;
  }
  
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) {
      this.labels = null;
    } else {
      this.labels = new LinkedHashMap(labels);
    }
    return (A) this;
  }
  
  public boolean hasLabels() {
    return this.labels != null;
  }
  
  public Boolean getListenLocal() {
    return this.listenLocal;
  }
  
  public A withListenLocal(Boolean listenLocal) {
    this.listenLocal = listenLocal;
    return (A) this;
  }
  
  public boolean hasListenLocal() {
    return this.listenLocal != null;
  }
  
  public String getLogFormat() {
    return this.logFormat;
  }
  
  public A withLogFormat(String logFormat) {
    this.logFormat = logFormat;
    return (A) this;
  }
  
  public boolean hasLogFormat() {
    return this.logFormat != null;
  }
  
  public String getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(String logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public Long getMinReadySeconds() {
    return this.minReadySeconds;
  }
  
  public A withMinReadySeconds(Long minReadySeconds) {
    this.minReadySeconds = minReadySeconds;
    return (A) this;
  }
  
  public boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) {
      this.nodeSelector = null;
    } else {
      this.nodeSelector = new LinkedHashMap(nodeSelector);
    }
    return (A) this;
  }
  
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  public SecretKeySelector getObjectStorageConfig() {
    return this.objectStorageConfig;
  }
  
  public A withObjectStorageConfig(SecretKeySelector objectStorageConfig) {
    this.objectStorageConfig = objectStorageConfig;
    return (A) this;
  }
  
  public boolean hasObjectStorageConfig() {
    return this.objectStorageConfig != null;
  }
  
  public A withNewObjectStorageConfig(String key,String name,Boolean optional) {
    return (A)withObjectStorageConfig(new SecretKeySelector(key, name, optional));
  }
  
  public String getObjectStorageConfigFile() {
    return this.objectStorageConfigFile;
  }
  
  public A withObjectStorageConfigFile(String objectStorageConfigFile) {
    this.objectStorageConfigFile = objectStorageConfigFile;
    return (A) this;
  }
  
  public boolean hasObjectStorageConfigFile() {
    return this.objectStorageConfigFile != null;
  }
  
  public Boolean getPaused() {
    return this.paused;
  }
  
  public A withPaused(Boolean paused) {
    this.paused = paused;
    return (A) this;
  }
  
  public boolean hasPaused() {
    return this.paused != null;
  }
  
  public EmbeddedObjectMetadata buildPodMetadata() {
    return this.podMetadata != null ? this.podMetadata.build() : null;
  }
  
  public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
    this._visitables.remove("podMetadata");
    if (podMetadata != null) {
        this.podMetadata = new EmbeddedObjectMetadataBuilder(podMetadata);
        this._visitables.get("podMetadata").add(this.podMetadata);
    } else {
        this.podMetadata = null;
        this._visitables.get("podMetadata").remove(this.podMetadata);
    }
    return (A) this;
  }
  
  public boolean hasPodMetadata() {
    return this.podMetadata != null;
  }
  
  public PodMetadataNested<A> withNewPodMetadata() {
    return new PodMetadataNested(null);
  }
  
  public PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
    return new PodMetadataNested(item);
  }
  
  public PodMetadataNested<A> editPodMetadata() {
    return withNewPodMetadataLike(java.util.Optional.ofNullable(buildPodMetadata()).orElse(null));
  }
  
  public PodMetadataNested<A> editOrNewPodMetadata() {
    return withNewPodMetadataLike(java.util.Optional.ofNullable(buildPodMetadata()).orElse(new EmbeddedObjectMetadataBuilder().build()));
  }
  
  public PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
    return withNewPodMetadataLike(java.util.Optional.ofNullable(buildPodMetadata()).orElse(item));
  }
  
  public String getPortName() {
    return this.portName;
  }
  
  public A withPortName(String portName) {
    this.portName = portName;
    return (A) this;
  }
  
  public boolean hasPortName() {
    return this.portName != null;
  }
  
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName = priorityClassName;
    return (A) this;
  }
  
  public boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  
  public A addToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);
    if (index < 0 || index >= prometheusRulesExcludedFromEnforce.size()) {
        _visitables.get("prometheusRulesExcludedFromEnforce").add(builder);
        prometheusRulesExcludedFromEnforce.add(builder);
    } else {
        _visitables.get("prometheusRulesExcludedFromEnforce").add(builder);
        prometheusRulesExcludedFromEnforce.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);
    if (index < 0 || index >= prometheusRulesExcludedFromEnforce.size()) {
        _visitables.get("prometheusRulesExcludedFromEnforce").add(builder);
        prometheusRulesExcludedFromEnforce.add(builder);
    } else {
        _visitables.get("prometheusRulesExcludedFromEnforce").add(builder);
        prometheusRulesExcludedFromEnforce.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(builder);this.prometheusRulesExcludedFromEnforce.add(builder);} return (A)this;
  }
  
  public A addAllToPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(builder);this.prometheusRulesExcludedFromEnforce.add(builder);} return (A)this;
  }
  
  public A removeFromPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items) {
    if (this.prometheusRulesExcludedFromEnforce == null) return (A)this;
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").remove(builder); this.prometheusRulesExcludedFromEnforce.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items) {
    if (this.prometheusRulesExcludedFromEnforce == null) return (A)this;
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").remove(builder); this.prometheusRulesExcludedFromEnforce.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    if (prometheusRulesExcludedFromEnforce == null) return (A) this;
    final Iterator<PrometheusRuleExcludeConfigBuilder> each = prometheusRulesExcludedFromEnforce.iterator();
    final List visitables = _visitables.get("prometheusRulesExcludedFromEnforce");
    while (each.hasNext()) {
      PrometheusRuleExcludeConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PrometheusRuleExcludeConfig> buildPrometheusRulesExcludedFromEnforce() {
    return this.prometheusRulesExcludedFromEnforce != null ? build(prometheusRulesExcludedFromEnforce) : null;
  }
  
  public PrometheusRuleExcludeConfig buildPrometheusRulesExcludedFromEnforce(int index) {
    return this.prometheusRulesExcludedFromEnforce.get(index).build();
  }
  
  public PrometheusRuleExcludeConfig buildFirstPrometheusRulesExcludedFromEnforce() {
    return this.prometheusRulesExcludedFromEnforce.get(0).build();
  }
  
  public PrometheusRuleExcludeConfig buildLastPrometheusRulesExcludedFromEnforce() {
    return this.prometheusRulesExcludedFromEnforce.get(prometheusRulesExcludedFromEnforce.size() - 1).build();
  }
  
  public PrometheusRuleExcludeConfig buildMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
      for (PrometheusRuleExcludeConfigBuilder item : prometheusRulesExcludedFromEnforce) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
      for (PrometheusRuleExcludeConfigBuilder item : prometheusRulesExcludedFromEnforce) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPrometheusRulesExcludedFromEnforce(List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce) {
    if (this.prometheusRulesExcludedFromEnforce != null) {
      this._visitables.get("prometheusRulesExcludedFromEnforce").clear();
    }
    if (prometheusRulesExcludedFromEnforce != null) {
        this.prometheusRulesExcludedFromEnforce = new ArrayList();
        for (PrometheusRuleExcludeConfig item : prometheusRulesExcludedFromEnforce) {
          this.addToPrometheusRulesExcludedFromEnforce(item);
        }
    } else {
      this.prometheusRulesExcludedFromEnforce = null;
    }
    return (A) this;
  }
  
  public A withPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... prometheusRulesExcludedFromEnforce) {
    if (this.prometheusRulesExcludedFromEnforce != null) {
        this.prometheusRulesExcludedFromEnforce.clear();
        _visitables.remove("prometheusRulesExcludedFromEnforce");
    }
    if (prometheusRulesExcludedFromEnforce != null) {
      for (PrometheusRuleExcludeConfig item : prometheusRulesExcludedFromEnforce) {
        this.addToPrometheusRulesExcludedFromEnforce(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPrometheusRulesExcludedFromEnforce() {
    return this.prometheusRulesExcludedFromEnforce != null && !this.prometheusRulesExcludedFromEnforce.isEmpty();
  }
  
  public A addNewPrometheusRulesExcludedFromEnforce(String ruleName,String ruleNamespace) {
    return (A)addToPrometheusRulesExcludedFromEnforce(new PrometheusRuleExcludeConfig(ruleName, ruleNamespace));
  }
  
  public PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforce() {
    return new PrometheusRulesExcludedFromEnforceNested(-1, null);
  }
  
  public PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforceLike(PrometheusRuleExcludeConfig item) {
    return new PrometheusRulesExcludedFromEnforceNested(-1, item);
  }
  
  public PrometheusRulesExcludedFromEnforceNested<A> setNewPrometheusRulesExcludedFromEnforceLike(int index,PrometheusRuleExcludeConfig item) {
    return new PrometheusRulesExcludedFromEnforceNested(index, item);
  }
  
  public PrometheusRulesExcludedFromEnforceNested<A> editPrometheusRulesExcludedFromEnforce(int index) {
    if (prometheusRulesExcludedFromEnforce.size() <= index) throw new RuntimeException("Can't edit prometheusRulesExcludedFromEnforce. Index exceeds size.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  
  public PrometheusRulesExcludedFromEnforceNested<A> editFirstPrometheusRulesExcludedFromEnforce() {
    if (prometheusRulesExcludedFromEnforce.size() == 0) throw new RuntimeException("Can't edit first prometheusRulesExcludedFromEnforce. The list is empty.");
    return setNewPrometheusRulesExcludedFromEnforceLike(0, buildPrometheusRulesExcludedFromEnforce(0));
  }
  
  public PrometheusRulesExcludedFromEnforceNested<A> editLastPrometheusRulesExcludedFromEnforce() {
    int index = prometheusRulesExcludedFromEnforce.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last prometheusRulesExcludedFromEnforce. The list is empty.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  
  public PrometheusRulesExcludedFromEnforceNested<A> editMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<prometheusRulesExcludedFromEnforce.size();i++) { 
    if (predicate.test(prometheusRulesExcludedFromEnforce.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching prometheusRulesExcludedFromEnforce. No match found.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  
  public SecretKeySelector getQueryConfig() {
    return this.queryConfig;
  }
  
  public A withQueryConfig(SecretKeySelector queryConfig) {
    this.queryConfig = queryConfig;
    return (A) this;
  }
  
  public boolean hasQueryConfig() {
    return this.queryConfig != null;
  }
  
  public A withNewQueryConfig(String key,String name,Boolean optional) {
    return (A)withQueryConfig(new SecretKeySelector(key, name, optional));
  }
  
  public A addToQueryEndpoints(int index,String item) {
    if (this.queryEndpoints == null) {this.queryEndpoints = new ArrayList<String>();}
    this.queryEndpoints.add(index, item);
    return (A)this;
  }
  
  public A setToQueryEndpoints(int index,String item) {
    if (this.queryEndpoints == null) {this.queryEndpoints = new ArrayList<String>();}
    this.queryEndpoints.set(index, item); return (A)this;
  }
  
  public A addToQueryEndpoints(java.lang.String... items) {
    if (this.queryEndpoints == null) {this.queryEndpoints = new ArrayList<String>();}
    for (String item : items) {this.queryEndpoints.add(item);} return (A)this;
  }
  
  public A addAllToQueryEndpoints(Collection<String> items) {
    if (this.queryEndpoints == null) {this.queryEndpoints = new ArrayList<String>();}
    for (String item : items) {this.queryEndpoints.add(item);} return (A)this;
  }
  
  public A removeFromQueryEndpoints(java.lang.String... items) {
    if (this.queryEndpoints == null) return (A)this;
    for (String item : items) { this.queryEndpoints.remove(item);} return (A)this;
  }
  
  public A removeAllFromQueryEndpoints(Collection<String> items) {
    if (this.queryEndpoints == null) return (A)this;
    for (String item : items) { this.queryEndpoints.remove(item);} return (A)this;
  }
  
  public List<String> getQueryEndpoints() {
    return this.queryEndpoints;
  }
  
  public String getQueryEndpoint(int index) {
    return this.queryEndpoints.get(index);
  }
  
  public String getFirstQueryEndpoint() {
    return this.queryEndpoints.get(0);
  }
  
  public String getLastQueryEndpoint() {
    return this.queryEndpoints.get(queryEndpoints.size() - 1);
  }
  
  public String getMatchingQueryEndpoint(Predicate<String> predicate) {
      for (String item : queryEndpoints) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingQueryEndpoint(Predicate<String> predicate) {
      for (String item : queryEndpoints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withQueryEndpoints(List<String> queryEndpoints) {
    if (queryEndpoints != null) {
        this.queryEndpoints = new ArrayList();
        for (String item : queryEndpoints) {
          this.addToQueryEndpoints(item);
        }
    } else {
      this.queryEndpoints = null;
    }
    return (A) this;
  }
  
  public A withQueryEndpoints(java.lang.String... queryEndpoints) {
    if (this.queryEndpoints != null) {
        this.queryEndpoints.clear();
        _visitables.remove("queryEndpoints");
    }
    if (queryEndpoints != null) {
      for (String item : queryEndpoints) {
        this.addToQueryEndpoints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasQueryEndpoints() {
    return this.queryEndpoints != null && !this.queryEndpoints.isEmpty();
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public ResourceRequirements buildResources() {
    return this.resources != null ? this.resources.build() : null;
  }
  
  public A withResources(ResourceRequirements resources) {
    this._visitables.remove("resources");
    if (resources != null) {
        this.resources = new ResourceRequirementsBuilder(resources);
        this._visitables.get("resources").add(this.resources);
    } else {
        this.resources = null;
        this._visitables.get("resources").remove(this.resources);
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  
  public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ResourcesNested(item);
  }
  
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  
  public String getRetention() {
    return this.retention;
  }
  
  public A withRetention(String retention) {
    this.retention = retention;
    return (A) this;
  }
  
  public boolean hasRetention() {
    return this.retention != null;
  }
  
  public String getRoutePrefix() {
    return this.routePrefix;
  }
  
  public A withRoutePrefix(String routePrefix) {
    this.routePrefix = routePrefix;
    return (A) this;
  }
  
  public boolean hasRoutePrefix() {
    return this.routePrefix != null;
  }
  
  public LabelSelector buildRuleNamespaceSelector() {
    return this.ruleNamespaceSelector != null ? this.ruleNamespaceSelector.build() : null;
  }
  
  public A withRuleNamespaceSelector(LabelSelector ruleNamespaceSelector) {
    this._visitables.remove("ruleNamespaceSelector");
    if (ruleNamespaceSelector != null) {
        this.ruleNamespaceSelector = new LabelSelectorBuilder(ruleNamespaceSelector);
        this._visitables.get("ruleNamespaceSelector").add(this.ruleNamespaceSelector);
    } else {
        this.ruleNamespaceSelector = null;
        this._visitables.get("ruleNamespaceSelector").remove(this.ruleNamespaceSelector);
    }
    return (A) this;
  }
  
  public boolean hasRuleNamespaceSelector() {
    return this.ruleNamespaceSelector != null;
  }
  
  public RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelector() {
    return new RuleNamespaceSelectorNested(null);
  }
  
  public RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelectorLike(LabelSelector item) {
    return new RuleNamespaceSelectorNested(item);
  }
  
  public RuleNamespaceSelectorNested<A> editRuleNamespaceSelector() {
    return withNewRuleNamespaceSelectorLike(java.util.Optional.ofNullable(buildRuleNamespaceSelector()).orElse(null));
  }
  
  public RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelector() {
    return withNewRuleNamespaceSelectorLike(java.util.Optional.ofNullable(buildRuleNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelectorLike(LabelSelector item) {
    return withNewRuleNamespaceSelectorLike(java.util.Optional.ofNullable(buildRuleNamespaceSelector()).orElse(item));
  }
  
  public LabelSelector buildRuleSelector() {
    return this.ruleSelector != null ? this.ruleSelector.build() : null;
  }
  
  public A withRuleSelector(LabelSelector ruleSelector) {
    this._visitables.remove("ruleSelector");
    if (ruleSelector != null) {
        this.ruleSelector = new LabelSelectorBuilder(ruleSelector);
        this._visitables.get("ruleSelector").add(this.ruleSelector);
    } else {
        this.ruleSelector = null;
        this._visitables.get("ruleSelector").remove(this.ruleSelector);
    }
    return (A) this;
  }
  
  public boolean hasRuleSelector() {
    return this.ruleSelector != null;
  }
  
  public RuleSelectorNested<A> withNewRuleSelector() {
    return new RuleSelectorNested(null);
  }
  
  public RuleSelectorNested<A> withNewRuleSelectorLike(LabelSelector item) {
    return new RuleSelectorNested(item);
  }
  
  public RuleSelectorNested<A> editRuleSelector() {
    return withNewRuleSelectorLike(java.util.Optional.ofNullable(buildRuleSelector()).orElse(null));
  }
  
  public RuleSelectorNested<A> editOrNewRuleSelector() {
    return withNewRuleSelectorLike(java.util.Optional.ofNullable(buildRuleSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public RuleSelectorNested<A> editOrNewRuleSelectorLike(LabelSelector item) {
    return withNewRuleSelectorLike(java.util.Optional.ofNullable(buildRuleSelector()).orElse(item));
  }
  
  public PodSecurityContext getSecurityContext() {
    return this.securityContext;
  }
  
  public A withSecurityContext(PodSecurityContext securityContext) {
    this.securityContext = securityContext;
    return (A) this;
  }
  
  public boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName = serviceAccountName;
    return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public StorageSpec buildStorage() {
    return this.storage != null ? this.storage.build() : null;
  }
  
  public A withStorage(StorageSpec storage) {
    this._visitables.remove("storage");
    if (storage != null) {
        this.storage = new StorageSpecBuilder(storage);
        this._visitables.get("storage").add(this.storage);
    } else {
        this.storage = null;
        this._visitables.get("storage").remove(this.storage);
    }
    return (A) this;
  }
  
  public boolean hasStorage() {
    return this.storage != null;
  }
  
  public StorageNested<A> withNewStorage() {
    return new StorageNested(null);
  }
  
  public StorageNested<A> withNewStorageLike(StorageSpec item) {
    return new StorageNested(item);
  }
  
  public StorageNested<A> editStorage() {
    return withNewStorageLike(java.util.Optional.ofNullable(buildStorage()).orElse(null));
  }
  
  public StorageNested<A> editOrNewStorage() {
    return withNewStorageLike(java.util.Optional.ofNullable(buildStorage()).orElse(new StorageSpecBuilder().build()));
  }
  
  public StorageNested<A> editOrNewStorageLike(StorageSpec item) {
    return withNewStorageLike(java.util.Optional.ofNullable(buildStorage()).orElse(item));
  }
  
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  
  public A removeAllFromTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
      for (Toleration item : tolerations) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
      for (Toleration item : tolerations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {
        this.tolerations = new ArrayList();
        for (Toleration item : tolerations) {
          this.addToTolerations(item);
        }
    } else {
      this.tolerations = null;
    }
    return (A) this;
  }
  
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {
        this.tolerations.clear();
        _visitables.remove("tolerations");
    }
    if (tolerations != null) {
      for (Toleration item : tolerations) {
        this.addToTolerations(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTolerations() {
    return this.tolerations != null && !this.tolerations.isEmpty();
  }
  
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  
  public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  
  public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) return (A)this;
    for (TopologySpreadConstraint item : items) { this.topologySpreadConstraints.remove(item);} return (A)this;
  }
  
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) return (A)this;
    for (TopologySpreadConstraint item : items) { this.topologySpreadConstraints.remove(item);} return (A)this;
  }
  
  public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  
  public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
    return this.topologySpreadConstraints.get(index);
  }
  
  public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  
  public TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
      for (TopologySpreadConstraint item : topologySpreadConstraints) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
      for (TopologySpreadConstraint item : topologySpreadConstraints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {
        this.topologySpreadConstraints = new ArrayList();
        for (TopologySpreadConstraint item : topologySpreadConstraints) {
          this.addToTopologySpreadConstraints(item);
        }
    } else {
      this.topologySpreadConstraints = null;
    }
    return (A) this;
  }
  
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {
        this.topologySpreadConstraints.clear();
        _visitables.remove("topologySpreadConstraints");
    }
    if (topologySpreadConstraints != null) {
      for (TopologySpreadConstraint item : topologySpreadConstraints) {
        this.addToTopologySpreadConstraints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTopologySpreadConstraints() {
    return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
  }
  
  public SecretKeySelector getTracingConfig() {
    return this.tracingConfig;
  }
  
  public A withTracingConfig(SecretKeySelector tracingConfig) {
    this.tracingConfig = tracingConfig;
    return (A) this;
  }
  
  public boolean hasTracingConfig() {
    return this.tracingConfig != null;
  }
  
  public A withNewTracingConfig(String key,String name,Boolean optional) {
    return (A)withTracingConfig(new SecretKeySelector(key, name, optional));
  }
  
  public String getTracingConfigFile() {
    return this.tracingConfigFile;
  }
  
  public A withTracingConfigFile(String tracingConfigFile) {
    this.tracingConfigFile = tracingConfigFile;
    return (A) this;
  }
  
  public boolean hasTracingConfigFile() {
    return this.tracingConfigFile != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    VolumeMountBuilder builder = new VolumeMountBuilder(item);
    if (index < 0 || index >= volumeMounts.size()) {
        _visitables.get("volumeMounts").add(builder);
        volumeMounts.add(builder);
    } else {
        _visitables.get("volumeMounts").add(builder);
        volumeMounts.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    VolumeMountBuilder builder = new VolumeMountBuilder(item);
    if (index < 0 || index >= volumeMounts.size()) {
        _visitables.get("volumeMounts").add(builder);
        volumeMounts.add(builder);
    } else {
        _visitables.get("volumeMounts").add(builder);
        volumeMounts.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  
  public A addAllToVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) return (A)this;
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder); this.volumeMounts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) return (A)this;
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder); this.volumeMounts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
    if (volumeMounts == null) return (A) this;
    final Iterator<VolumeMountBuilder> each = volumeMounts.iterator();
    final List visitables = _visitables.get("volumeMounts");
    while (each.hasNext()) {
      VolumeMountBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VolumeMount> buildVolumeMounts() {
    return this.volumeMounts != null ? build(volumeMounts) : null;
  }
  
  public VolumeMount buildVolumeMount(int index) {
    return this.volumeMounts.get(index).build();
  }
  
  public VolumeMount buildFirstVolumeMount() {
    return this.volumeMounts.get(0).build();
  }
  
  public VolumeMount buildLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1).build();
  }
  
  public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
      for (VolumeMountBuilder item : volumeMounts) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
      for (VolumeMountBuilder item : volumeMounts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumeMounts(List<VolumeMount> volumeMounts) {
    if (this.volumeMounts != null) {
      this._visitables.get("volumeMounts").clear();
    }
    if (volumeMounts != null) {
        this.volumeMounts = new ArrayList();
        for (VolumeMount item : volumeMounts) {
          this.addToVolumeMounts(item);
        }
    } else {
      this.volumeMounts = null;
    }
    return (A) this;
  }
  
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {
        this.volumeMounts.clear();
        _visitables.remove("volumeMounts");
    }
    if (volumeMounts != null) {
      for (VolumeMount item : volumeMounts) {
        this.addToVolumeMounts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumeMounts() {
    return this.volumeMounts != null && !this.volumeMounts.isEmpty();
  }
  
  public VolumeMountsNested<A> addNewVolumeMount() {
    return new VolumeMountsNested(-1, null);
  }
  
  public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
    return new VolumeMountsNested(-1, item);
  }
  
  public VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item) {
    return new VolumeMountsNested(index, item);
  }
  
  public VolumeMountsNested<A> editVolumeMount(int index) {
    if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public VolumeMountsNested<A> editFirstVolumeMount() {
    if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
    return setNewVolumeMountLike(0, buildVolumeMount(0));
  }
  
  public VolumeMountsNested<A> editLastVolumeMount() {
    int index = volumeMounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeMounts.size();i++) { 
    if (predicate.test(volumeMounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public A addToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) {
        _visitables.get("volumes").add(builder);
        volumes.add(builder);
    } else {
        _visitables.get("volumes").add(builder);
        volumes.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) {
        _visitables.get("volumes").add(builder);
        volumes.add(builder);
    } else {
        _visitables.get("volumes").add(builder);
        volumes.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) return (A)this;
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder); this.volumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVolumes(Collection<Volume> items) {
    if (this.volumes == null) return (A)this;
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder); this.volumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<VolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      VolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Volume> buildVolumes() {
    return this.volumes != null ? build(volumes) : null;
  }
  
  public Volume buildVolume(int index) {
    return this.volumes.get(index).build();
  }
  
  public Volume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  
  public Volume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
      for (VolumeBuilder item : volumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
      for (VolumeBuilder item : volumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumes(List<Volume> volumes) {
    if (this.volumes != null) {
      this._visitables.get("volumes").clear();
    }
    if (volumes != null) {
        this.volumes = new ArrayList();
        for (Volume item : volumes) {
          this.addToVolumes(item);
        }
    } else {
      this.volumes = null;
    }
    return (A) this;
  }
  
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {
        this.volumes.clear();
        _visitables.remove("volumes");
    }
    if (volumes != null) {
      for (Volume item : volumes) {
        this.addToVolumes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumes() {
    return this.volumes != null && !this.volumes.isEmpty();
  }
  
  public VolumesNested<A> addNewVolume() {
    return new VolumesNested(-1, null);
  }
  
  public VolumesNested<A> addNewVolumeLike(Volume item) {
    return new VolumesNested(-1, item);
  }
  
  public VolumesNested<A> setNewVolumeLike(int index,Volume item) {
    return new VolumesNested(index, item);
  }
  
  public VolumesNested<A> editVolume(int index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  
  public VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public ThanosRulerWebSpec buildWeb() {
    return this.web != null ? this.web.build() : null;
  }
  
  public A withWeb(ThanosRulerWebSpec web) {
    this._visitables.remove("web");
    if (web != null) {
        this.web = new ThanosRulerWebSpecBuilder(web);
        this._visitables.get("web").add(this.web);
    } else {
        this.web = null;
        this._visitables.get("web").remove(this.web);
    }
    return (A) this;
  }
  
  public boolean hasWeb() {
    return this.web != null;
  }
  
  public WebNested<A> withNewWeb() {
    return new WebNested(null);
  }
  
  public WebNested<A> withNewWebLike(ThanosRulerWebSpec item) {
    return new WebNested(item);
  }
  
  public WebNested<A> editWeb() {
    return withNewWebLike(java.util.Optional.ofNullable(buildWeb()).orElse(null));
  }
  
  public WebNested<A> editOrNewWeb() {
    return withNewWebLike(java.util.Optional.ofNullable(buildWeb()).orElse(new ThanosRulerWebSpecBuilder().build()));
  }
  
  public WebNested<A> editOrNewWebLike(ThanosRulerWebSpec item) {
    return withNewWebLike(java.util.Optional.ofNullable(buildWeb()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ThanosRulerSpecFluent that = (ThanosRulerSpecFluent) o;
    if (!java.util.Objects.equals(additionalArgs, that.additionalArgs)) return false;
    if (!java.util.Objects.equals(affinity, that.affinity)) return false;
    if (!java.util.Objects.equals(alertDropLabels, that.alertDropLabels)) return false;
    if (!java.util.Objects.equals(alertQueryUrl, that.alertQueryUrl)) return false;
    if (!java.util.Objects.equals(alertRelabelConfigFile, that.alertRelabelConfigFile)) return false;
    if (!java.util.Objects.equals(alertRelabelConfigs, that.alertRelabelConfigs)) return false;
    if (!java.util.Objects.equals(alertmanagersConfig, that.alertmanagersConfig)) return false;
    if (!java.util.Objects.equals(alertmanagersUrl, that.alertmanagersUrl)) return false;
    if (!java.util.Objects.equals(containers, that.containers)) return false;
    if (!java.util.Objects.equals(dnsConfig, that.dnsConfig)) return false;
    if (!java.util.Objects.equals(dnsPolicy, that.dnsPolicy)) return false;
    if (!java.util.Objects.equals(enforcedNamespaceLabel, that.enforcedNamespaceLabel)) return false;
    if (!java.util.Objects.equals(evaluationInterval, that.evaluationInterval)) return false;
    if (!java.util.Objects.equals(excludedFromEnforcement, that.excludedFromEnforcement)) return false;
    if (!java.util.Objects.equals(externalPrefix, that.externalPrefix)) return false;
    if (!java.util.Objects.equals(grpcServerTlsConfig, that.grpcServerTlsConfig)) return false;
    if (!java.util.Objects.equals(hostAliases, that.hostAliases)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(imagePullPolicy, that.imagePullPolicy)) return false;
    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;
    if (!java.util.Objects.equals(initContainers, that.initContainers)) return false;
    if (!java.util.Objects.equals(labels, that.labels)) return false;
    if (!java.util.Objects.equals(listenLocal, that.listenLocal)) return false;
    if (!java.util.Objects.equals(logFormat, that.logFormat)) return false;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(minReadySeconds, that.minReadySeconds)) return false;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;
    if (!java.util.Objects.equals(objectStorageConfig, that.objectStorageConfig)) return false;
    if (!java.util.Objects.equals(objectStorageConfigFile, that.objectStorageConfigFile)) return false;
    if (!java.util.Objects.equals(paused, that.paused)) return false;
    if (!java.util.Objects.equals(podMetadata, that.podMetadata)) return false;
    if (!java.util.Objects.equals(portName, that.portName)) return false;
    if (!java.util.Objects.equals(priorityClassName, that.priorityClassName)) return false;
    if (!java.util.Objects.equals(prometheusRulesExcludedFromEnforce, that.prometheusRulesExcludedFromEnforce)) return false;
    if (!java.util.Objects.equals(queryConfig, that.queryConfig)) return false;
    if (!java.util.Objects.equals(queryEndpoints, that.queryEndpoints)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(retention, that.retention)) return false;
    if (!java.util.Objects.equals(routePrefix, that.routePrefix)) return false;
    if (!java.util.Objects.equals(ruleNamespaceSelector, that.ruleNamespaceSelector)) return false;
    if (!java.util.Objects.equals(ruleSelector, that.ruleSelector)) return false;
    if (!java.util.Objects.equals(securityContext, that.securityContext)) return false;
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
    if (!java.util.Objects.equals(storage, that.storage)) return false;
    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;
    if (!java.util.Objects.equals(topologySpreadConstraints, that.topologySpreadConstraints)) return false;
    if (!java.util.Objects.equals(tracingConfig, that.tracingConfig)) return false;
    if (!java.util.Objects.equals(tracingConfigFile, that.tracingConfigFile)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(volumeMounts, that.volumeMounts)) return false;
    if (!java.util.Objects.equals(volumes, that.volumes)) return false;
    if (!java.util.Objects.equals(web, that.web)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalArgs,  affinity,  alertDropLabels,  alertQueryUrl,  alertRelabelConfigFile,  alertRelabelConfigs,  alertmanagersConfig,  alertmanagersUrl,  containers,  dnsConfig,  dnsPolicy,  enforcedNamespaceLabel,  evaluationInterval,  excludedFromEnforcement,  externalPrefix,  grpcServerTlsConfig,  hostAliases,  image,  imagePullPolicy,  imagePullSecrets,  initContainers,  labels,  listenLocal,  logFormat,  logLevel,  minReadySeconds,  nodeSelector,  objectStorageConfig,  objectStorageConfigFile,  paused,  podMetadata,  portName,  priorityClassName,  prometheusRulesExcludedFromEnforce,  queryConfig,  queryEndpoints,  replicas,  resources,  retention,  routePrefix,  ruleNamespaceSelector,  ruleSelector,  securityContext,  serviceAccountName,  storage,  tolerations,  topologySpreadConstraints,  tracingConfig,  tracingConfigFile,  version,  volumeMounts,  volumes,  web,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalArgs != null && !additionalArgs.isEmpty()) { sb.append("additionalArgs:"); sb.append(additionalArgs + ","); }
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (alertDropLabels != null && !alertDropLabels.isEmpty()) { sb.append("alertDropLabels:"); sb.append(alertDropLabels + ","); }
    if (alertQueryUrl != null) { sb.append("alertQueryUrl:"); sb.append(alertQueryUrl + ","); }
    if (alertRelabelConfigFile != null) { sb.append("alertRelabelConfigFile:"); sb.append(alertRelabelConfigFile + ","); }
    if (alertRelabelConfigs != null) { sb.append("alertRelabelConfigs:"); sb.append(alertRelabelConfigs + ","); }
    if (alertmanagersConfig != null) { sb.append("alertmanagersConfig:"); sb.append(alertmanagersConfig + ","); }
    if (alertmanagersUrl != null && !alertmanagersUrl.isEmpty()) { sb.append("alertmanagersUrl:"); sb.append(alertmanagersUrl + ","); }
    if (containers != null && !containers.isEmpty()) { sb.append("containers:"); sb.append(containers + ","); }
    if (dnsConfig != null) { sb.append("dnsConfig:"); sb.append(dnsConfig + ","); }
    if (dnsPolicy != null) { sb.append("dnsPolicy:"); sb.append(dnsPolicy + ","); }
    if (enforcedNamespaceLabel != null) { sb.append("enforcedNamespaceLabel:"); sb.append(enforcedNamespaceLabel + ","); }
    if (evaluationInterval != null) { sb.append("evaluationInterval:"); sb.append(evaluationInterval + ","); }
    if (excludedFromEnforcement != null && !excludedFromEnforcement.isEmpty()) { sb.append("excludedFromEnforcement:"); sb.append(excludedFromEnforcement + ","); }
    if (externalPrefix != null) { sb.append("externalPrefix:"); sb.append(externalPrefix + ","); }
    if (grpcServerTlsConfig != null) { sb.append("grpcServerTlsConfig:"); sb.append(grpcServerTlsConfig + ","); }
    if (hostAliases != null && !hostAliases.isEmpty()) { sb.append("hostAliases:"); sb.append(hostAliases + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imagePullPolicy != null) { sb.append("imagePullPolicy:"); sb.append(imagePullPolicy + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (listenLocal != null) { sb.append("listenLocal:"); sb.append(listenLocal + ","); }
    if (logFormat != null) { sb.append("logFormat:"); sb.append(logFormat + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (objectStorageConfig != null) { sb.append("objectStorageConfig:"); sb.append(objectStorageConfig + ","); }
    if (objectStorageConfigFile != null) { sb.append("objectStorageConfigFile:"); sb.append(objectStorageConfigFile + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (podMetadata != null) { sb.append("podMetadata:"); sb.append(podMetadata + ","); }
    if (portName != null) { sb.append("portName:"); sb.append(portName + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (prometheusRulesExcludedFromEnforce != null && !prometheusRulesExcludedFromEnforce.isEmpty()) { sb.append("prometheusRulesExcludedFromEnforce:"); sb.append(prometheusRulesExcludedFromEnforce + ","); }
    if (queryConfig != null) { sb.append("queryConfig:"); sb.append(queryConfig + ","); }
    if (queryEndpoints != null && !queryEndpoints.isEmpty()) { sb.append("queryEndpoints:"); sb.append(queryEndpoints + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (retention != null) { sb.append("retention:"); sb.append(retention + ","); }
    if (routePrefix != null) { sb.append("routePrefix:"); sb.append(routePrefix + ","); }
    if (ruleNamespaceSelector != null) { sb.append("ruleNamespaceSelector:"); sb.append(ruleNamespaceSelector + ","); }
    if (ruleSelector != null) { sb.append("ruleSelector:"); sb.append(ruleSelector + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (tracingConfig != null) { sb.append("tracingConfig:"); sb.append(tracingConfig + ","); }
    if (tracingConfigFile != null) { sb.append("tracingConfigFile:"); sb.append(tracingConfigFile + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (volumeMounts != null && !volumeMounts.isEmpty()) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (web != null) { sb.append("web:"); sb.append(web + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withListenLocal() {
    return withListenLocal(true);
  }
  
  public A withPaused() {
    return withPaused(true);
  }
  public class AdditionalArgsNested<N> extends ArgumentFluent<AdditionalArgsNested<N>> implements Nested<N>{
    AdditionalArgsNested(int index,Argument item) {
      this.index = index;
      this.builder = new ArgumentBuilder(this, item);
    }
    ArgumentBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToAdditionalArgs(index,builder.build());
    }
    
    public N endAdditionalArg() {
      return and();
    }
    
  
  }
  public class ContainersNested<N> extends ContainerFluent<ContainersNested<N>> implements Nested<N>{
    ContainersNested(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToContainers(index,builder.build());
    }
    
    public N endContainer() {
      return and();
    }
    
  
  }
  public class DnsConfigNested<N> extends PodDNSConfigFluent<DnsConfigNested<N>> implements Nested<N>{
    DnsConfigNested(PodDNSConfig item) {
      this.builder = new PodDNSConfigBuilder(this, item);
    }
    PodDNSConfigBuilder builder;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.withDnsConfig(builder.build());
    }
    
    public N endDnsConfig() {
      return and();
    }
    
  
  }
  public class ExcludedFromEnforcementNested<N> extends ObjectReferenceFluent<ExcludedFromEnforcementNested<N>> implements Nested<N>{
    ExcludedFromEnforcementNested(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToExcludedFromEnforcement(index,builder.build());
    }
    
    public N endExcludedFromEnforcement() {
      return and();
    }
    
  
  }
  public class GrpcServerTlsConfigNested<N> extends TLSConfigFluent<GrpcServerTlsConfigNested<N>> implements Nested<N>{
    GrpcServerTlsConfigNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.withGrpcServerTlsConfig(builder.build());
    }
    
    public N endGrpcServerTlsConfig() {
      return and();
    }
    
  
  }
  public class HostAliasesNested<N> extends HostAliasFluent<HostAliasesNested<N>> implements Nested<N>{
    HostAliasesNested(int index,HostAlias item) {
      this.index = index;
      this.builder = new HostAliasBuilder(this, item);
    }
    HostAliasBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToHostAliases(index,builder.build());
    }
    
    public N endHostAlias() {
      return and();
    }
    
  
  }
  public class ImagePullSecretsNested<N> extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>> implements Nested<N>{
    ImagePullSecretsNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToImagePullSecrets(index,builder.build());
    }
    
    public N endImagePullSecret() {
      return and();
    }
    
  
  }
  public class InitContainersNested<N> extends ContainerFluent<InitContainersNested<N>> implements Nested<N>{
    InitContainersNested(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToInitContainers(index,builder.build());
    }
    
    public N endInitContainer() {
      return and();
    }
    
  
  }
  public class PodMetadataNested<N> extends EmbeddedObjectMetadataFluent<PodMetadataNested<N>> implements Nested<N>{
    PodMetadataNested(EmbeddedObjectMetadata item) {
      this.builder = new EmbeddedObjectMetadataBuilder(this, item);
    }
    EmbeddedObjectMetadataBuilder builder;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.withPodMetadata(builder.build());
    }
    
    public N endPodMetadata() {
      return and();
    }
    
  
  }
  public class PrometheusRulesExcludedFromEnforceNested<N> extends PrometheusRuleExcludeConfigFluent<PrometheusRulesExcludedFromEnforceNested<N>> implements Nested<N>{
    PrometheusRulesExcludedFromEnforceNested(int index,PrometheusRuleExcludeConfig item) {
      this.index = index;
      this.builder = new PrometheusRuleExcludeConfigBuilder(this, item);
    }
    PrometheusRuleExcludeConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToPrometheusRulesExcludedFromEnforce(index,builder.build());
    }
    
    public N endPrometheusRulesExcludedFromEnforce() {
      return and();
    }
    
  
  }
  public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.withResources(builder.build());
    }
    
    public N endResources() {
      return and();
    }
    
  
  }
  public class RuleNamespaceSelectorNested<N> extends LabelSelectorFluent<RuleNamespaceSelectorNested<N>> implements Nested<N>{
    RuleNamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.withRuleNamespaceSelector(builder.build());
    }
    
    public N endRuleNamespaceSelector() {
      return and();
    }
    
  
  }
  public class RuleSelectorNested<N> extends LabelSelectorFluent<RuleSelectorNested<N>> implements Nested<N>{
    RuleSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.withRuleSelector(builder.build());
    }
    
    public N endRuleSelector() {
      return and();
    }
    
  
  }
  public class StorageNested<N> extends StorageSpecFluent<StorageNested<N>> implements Nested<N>{
    StorageNested(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageSpecBuilder builder;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.withStorage(builder.build());
    }
    
    public N endStorage() {
      return and();
    }
    
  
  }
  public class VolumeMountsNested<N> extends VolumeMountFluent<VolumeMountsNested<N>> implements Nested<N>{
    VolumeMountsNested(int index,VolumeMount item) {
      this.index = index;
      this.builder = new VolumeMountBuilder(this, item);
    }
    VolumeMountBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToVolumeMounts(index,builder.build());
    }
    
    public N endVolumeMount() {
      return and();
    }
    
  
  }
  public class VolumesNested<N> extends VolumeFluent<VolumesNested<N>> implements Nested<N>{
    VolumesNested(int index,Volume item) {
      this.index = index;
      this.builder = new VolumeBuilder(this, item);
    }
    VolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.setToVolumes(index,builder.build());
    }
    
    public N endVolume() {
      return and();
    }
    
  
  }
  public class WebNested<N> extends ThanosRulerWebSpecFluent<WebNested<N>> implements Nested<N>{
    WebNested(ThanosRulerWebSpec item) {
      this.builder = new ThanosRulerWebSpecBuilder(this, item);
    }
    ThanosRulerWebSpecBuilder builder;
    
    public N and() {
      return (N) ThanosRulerSpecFluent.this.withWeb(builder.build());
    }
    
    public N endWeb() {
      return and();
    }
    
  
  }

}