package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SlackConfigFluent<A extends SlackConfigFluent<A>> extends BaseFluent<A>{
  public SlackConfigFluent() {
  }
  
  public SlackConfigFluent(SlackConfig instance) {
    this.copyInstance(instance);
  }
  private ArrayList<SlackActionBuilder> actions = new ArrayList<SlackActionBuilder>();
  private SecretKeySelector apiURL;
  private String callbackId;
  private String channel;
  private String color;
  private String fallback;
  private ArrayList<SlackFieldBuilder> fields = new ArrayList<SlackFieldBuilder>();
  private String footer;
  private HTTPConfigBuilder httpConfig;
  private String iconEmoji;
  private String iconURL;
  private String imageURL;
  private Boolean linkNames;
  private List<String> mrkdwnIn = new ArrayList<String>();
  private String pretext;
  private Boolean sendResolved;
  private Boolean shortFields;
  private String text;
  private String thumbURL;
  private String title;
  private String titleLink;
  private String username;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SlackConfig instance) {
    instance = (instance != null ? instance : new SlackConfig());
    if (instance != null) {
          this.withActions(instance.getActions());
          this.withApiURL(instance.getApiURL());
          this.withCallbackId(instance.getCallbackId());
          this.withChannel(instance.getChannel());
          this.withColor(instance.getColor());
          this.withFallback(instance.getFallback());
          this.withFields(instance.getFields());
          this.withFooter(instance.getFooter());
          this.withHttpConfig(instance.getHttpConfig());
          this.withIconEmoji(instance.getIconEmoji());
          this.withIconURL(instance.getIconURL());
          this.withImageURL(instance.getImageURL());
          this.withLinkNames(instance.getLinkNames());
          this.withMrkdwnIn(instance.getMrkdwnIn());
          this.withPretext(instance.getPretext());
          this.withSendResolved(instance.getSendResolved());
          this.withShortFields(instance.getShortFields());
          this.withText(instance.getText());
          this.withThumbURL(instance.getThumbURL());
          this.withTitle(instance.getTitle());
          this.withTitleLink(instance.getTitleLink());
          this.withUsername(instance.getUsername());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToActions(int index,SlackAction item) {
    if (this.actions == null) {this.actions = new ArrayList<SlackActionBuilder>();}
    SlackActionBuilder builder = new SlackActionBuilder(item);
    if (index < 0 || index >= actions.size()) {
        _visitables.get("actions").add(builder);
        actions.add(builder);
    } else {
        _visitables.get("actions").add(builder);
        actions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToActions(int index,SlackAction item) {
    if (this.actions == null) {this.actions = new ArrayList<SlackActionBuilder>();}
    SlackActionBuilder builder = new SlackActionBuilder(item);
    if (index < 0 || index >= actions.size()) {
        _visitables.get("actions").add(builder);
        actions.add(builder);
    } else {
        _visitables.get("actions").add(builder);
        actions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToActions(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackAction... items) {
    if (this.actions == null) {this.actions = new ArrayList<SlackActionBuilder>();}
    for (SlackAction item : items) {SlackActionBuilder builder = new SlackActionBuilder(item);_visitables.get("actions").add(builder);this.actions.add(builder);} return (A)this;
  }
  
  public A addAllToActions(Collection<SlackAction> items) {
    if (this.actions == null) {this.actions = new ArrayList<SlackActionBuilder>();}
    for (SlackAction item : items) {SlackActionBuilder builder = new SlackActionBuilder(item);_visitables.get("actions").add(builder);this.actions.add(builder);} return (A)this;
  }
  
  public A removeFromActions(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackAction... items) {
    if (this.actions == null) return (A)this;
    for (SlackAction item : items) {SlackActionBuilder builder = new SlackActionBuilder(item);_visitables.get("actions").remove(builder); this.actions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromActions(Collection<SlackAction> items) {
    if (this.actions == null) return (A)this;
    for (SlackAction item : items) {SlackActionBuilder builder = new SlackActionBuilder(item);_visitables.get("actions").remove(builder); this.actions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromActions(Predicate<SlackActionBuilder> predicate) {
    if (actions == null) return (A) this;
    final Iterator<SlackActionBuilder> each = actions.iterator();
    final List visitables = _visitables.get("actions");
    while (each.hasNext()) {
      SlackActionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SlackAction> buildActions() {
    return this.actions != null ? build(actions) : null;
  }
  
  public SlackAction buildAction(int index) {
    return this.actions.get(index).build();
  }
  
  public SlackAction buildFirstAction() {
    return this.actions.get(0).build();
  }
  
  public SlackAction buildLastAction() {
    return this.actions.get(actions.size() - 1).build();
  }
  
  public SlackAction buildMatchingAction(Predicate<SlackActionBuilder> predicate) {
      for (SlackActionBuilder item : actions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAction(Predicate<SlackActionBuilder> predicate) {
      for (SlackActionBuilder item : actions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withActions(List<SlackAction> actions) {
    if (this.actions != null) {
      this._visitables.get("actions").clear();
    }
    if (actions != null) {
        this.actions = new ArrayList();
        for (SlackAction item : actions) {
          this.addToActions(item);
        }
    } else {
      this.actions = null;
    }
    return (A) this;
  }
  
  public A withActions(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackAction... actions) {
    if (this.actions != null) {
        this.actions.clear();
        _visitables.remove("actions");
    }
    if (actions != null) {
      for (SlackAction item : actions) {
        this.addToActions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasActions() {
    return this.actions != null && !this.actions.isEmpty();
  }
  
  public ActionsNested<A> addNewAction() {
    return new ActionsNested(-1, null);
  }
  
  public ActionsNested<A> addNewActionLike(SlackAction item) {
    return new ActionsNested(-1, item);
  }
  
  public ActionsNested<A> setNewActionLike(int index,SlackAction item) {
    return new ActionsNested(index, item);
  }
  
  public ActionsNested<A> editAction(int index) {
    if (actions.size() <= index) throw new RuntimeException("Can't edit actions. Index exceeds size.");
    return setNewActionLike(index, buildAction(index));
  }
  
  public ActionsNested<A> editFirstAction() {
    if (actions.size() == 0) throw new RuntimeException("Can't edit first actions. The list is empty.");
    return setNewActionLike(0, buildAction(0));
  }
  
  public ActionsNested<A> editLastAction() {
    int index = actions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last actions. The list is empty.");
    return setNewActionLike(index, buildAction(index));
  }
  
  public ActionsNested<A> editMatchingAction(Predicate<SlackActionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<actions.size();i++) { 
    if (predicate.test(actions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching actions. No match found.");
    return setNewActionLike(index, buildAction(index));
  }
  
  public SecretKeySelector getApiURL() {
    return this.apiURL;
  }
  
  public A withApiURL(SecretKeySelector apiURL) {
    this.apiURL = apiURL;
    return (A) this;
  }
  
  public boolean hasApiURL() {
    return this.apiURL != null;
  }
  
  public A withNewApiURL(String key,String name,Boolean optional) {
    return (A)withApiURL(new SecretKeySelector(key, name, optional));
  }
  
  public String getCallbackId() {
    return this.callbackId;
  }
  
  public A withCallbackId(String callbackId) {
    this.callbackId = callbackId;
    return (A) this;
  }
  
  public boolean hasCallbackId() {
    return this.callbackId != null;
  }
  
  public String getChannel() {
    return this.channel;
  }
  
  public A withChannel(String channel) {
    this.channel = channel;
    return (A) this;
  }
  
  public boolean hasChannel() {
    return this.channel != null;
  }
  
  public String getColor() {
    return this.color;
  }
  
  public A withColor(String color) {
    this.color = color;
    return (A) this;
  }
  
  public boolean hasColor() {
    return this.color != null;
  }
  
  public String getFallback() {
    return this.fallback;
  }
  
  public A withFallback(String fallback) {
    this.fallback = fallback;
    return (A) this;
  }
  
  public boolean hasFallback() {
    return this.fallback != null;
  }
  
  public A addToFields(int index,SlackField item) {
    if (this.fields == null) {this.fields = new ArrayList<SlackFieldBuilder>();}
    SlackFieldBuilder builder = new SlackFieldBuilder(item);
    if (index < 0 || index >= fields.size()) {
        _visitables.get("fields").add(builder);
        fields.add(builder);
    } else {
        _visitables.get("fields").add(builder);
        fields.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToFields(int index,SlackField item) {
    if (this.fields == null) {this.fields = new ArrayList<SlackFieldBuilder>();}
    SlackFieldBuilder builder = new SlackFieldBuilder(item);
    if (index < 0 || index >= fields.size()) {
        _visitables.get("fields").add(builder);
        fields.add(builder);
    } else {
        _visitables.get("fields").add(builder);
        fields.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToFields(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackField... items) {
    if (this.fields == null) {this.fields = new ArrayList<SlackFieldBuilder>();}
    for (SlackField item : items) {SlackFieldBuilder builder = new SlackFieldBuilder(item);_visitables.get("fields").add(builder);this.fields.add(builder);} return (A)this;
  }
  
  public A addAllToFields(Collection<SlackField> items) {
    if (this.fields == null) {this.fields = new ArrayList<SlackFieldBuilder>();}
    for (SlackField item : items) {SlackFieldBuilder builder = new SlackFieldBuilder(item);_visitables.get("fields").add(builder);this.fields.add(builder);} return (A)this;
  }
  
  public A removeFromFields(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackField... items) {
    if (this.fields == null) return (A)this;
    for (SlackField item : items) {SlackFieldBuilder builder = new SlackFieldBuilder(item);_visitables.get("fields").remove(builder); this.fields.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFields(Collection<SlackField> items) {
    if (this.fields == null) return (A)this;
    for (SlackField item : items) {SlackFieldBuilder builder = new SlackFieldBuilder(item);_visitables.get("fields").remove(builder); this.fields.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFields(Predicate<SlackFieldBuilder> predicate) {
    if (fields == null) return (A) this;
    final Iterator<SlackFieldBuilder> each = fields.iterator();
    final List visitables = _visitables.get("fields");
    while (each.hasNext()) {
      SlackFieldBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SlackField> buildFields() {
    return this.fields != null ? build(fields) : null;
  }
  
  public SlackField buildField(int index) {
    return this.fields.get(index).build();
  }
  
  public SlackField buildFirstField() {
    return this.fields.get(0).build();
  }
  
  public SlackField buildLastField() {
    return this.fields.get(fields.size() - 1).build();
  }
  
  public SlackField buildMatchingField(Predicate<SlackFieldBuilder> predicate) {
      for (SlackFieldBuilder item : fields) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingField(Predicate<SlackFieldBuilder> predicate) {
      for (SlackFieldBuilder item : fields) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFields(List<SlackField> fields) {
    if (this.fields != null) {
      this._visitables.get("fields").clear();
    }
    if (fields != null) {
        this.fields = new ArrayList();
        for (SlackField item : fields) {
          this.addToFields(item);
        }
    } else {
      this.fields = null;
    }
    return (A) this;
  }
  
  public A withFields(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackField... fields) {
    if (this.fields != null) {
        this.fields.clear();
        _visitables.remove("fields");
    }
    if (fields != null) {
      for (SlackField item : fields) {
        this.addToFields(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFields() {
    return this.fields != null && !this.fields.isEmpty();
  }
  
  public A addNewField(Boolean _short,String title,String value) {
    return (A)addToFields(new SlackField(_short, title, value));
  }
  
  public FieldsNested<A> addNewField() {
    return new FieldsNested(-1, null);
  }
  
  public FieldsNested<A> addNewFieldLike(SlackField item) {
    return new FieldsNested(-1, item);
  }
  
  public FieldsNested<A> setNewFieldLike(int index,SlackField item) {
    return new FieldsNested(index, item);
  }
  
  public FieldsNested<A> editField(int index) {
    if (fields.size() <= index) throw new RuntimeException("Can't edit fields. Index exceeds size.");
    return setNewFieldLike(index, buildField(index));
  }
  
  public FieldsNested<A> editFirstField() {
    if (fields.size() == 0) throw new RuntimeException("Can't edit first fields. The list is empty.");
    return setNewFieldLike(0, buildField(0));
  }
  
  public FieldsNested<A> editLastField() {
    int index = fields.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last fields. The list is empty.");
    return setNewFieldLike(index, buildField(index));
  }
  
  public FieldsNested<A> editMatchingField(Predicate<SlackFieldBuilder> predicate) {
    int index = -1;
    for (int i=0;i<fields.size();i++) { 
    if (predicate.test(fields.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching fields. No match found.");
    return setNewFieldLike(index, buildField(index));
  }
  
  public String getFooter() {
    return this.footer;
  }
  
  public A withFooter(String footer) {
    this.footer = footer;
    return (A) this;
  }
  
  public boolean hasFooter() {
    return this.footer != null;
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public String getIconEmoji() {
    return this.iconEmoji;
  }
  
  public A withIconEmoji(String iconEmoji) {
    this.iconEmoji = iconEmoji;
    return (A) this;
  }
  
  public boolean hasIconEmoji() {
    return this.iconEmoji != null;
  }
  
  public String getIconURL() {
    return this.iconURL;
  }
  
  public A withIconURL(String iconURL) {
    this.iconURL = iconURL;
    return (A) this;
  }
  
  public boolean hasIconURL() {
    return this.iconURL != null;
  }
  
  public String getImageURL() {
    return this.imageURL;
  }
  
  public A withImageURL(String imageURL) {
    this.imageURL = imageURL;
    return (A) this;
  }
  
  public boolean hasImageURL() {
    return this.imageURL != null;
  }
  
  public Boolean getLinkNames() {
    return this.linkNames;
  }
  
  public A withLinkNames(Boolean linkNames) {
    this.linkNames = linkNames;
    return (A) this;
  }
  
  public boolean hasLinkNames() {
    return this.linkNames != null;
  }
  
  public A addToMrkdwnIn(int index,String item) {
    if (this.mrkdwnIn == null) {this.mrkdwnIn = new ArrayList<String>();}
    this.mrkdwnIn.add(index, item);
    return (A)this;
  }
  
  public A setToMrkdwnIn(int index,String item) {
    if (this.mrkdwnIn == null) {this.mrkdwnIn = new ArrayList<String>();}
    this.mrkdwnIn.set(index, item); return (A)this;
  }
  
  public A addToMrkdwnIn(java.lang.String... items) {
    if (this.mrkdwnIn == null) {this.mrkdwnIn = new ArrayList<String>();}
    for (String item : items) {this.mrkdwnIn.add(item);} return (A)this;
  }
  
  public A addAllToMrkdwnIn(Collection<String> items) {
    if (this.mrkdwnIn == null) {this.mrkdwnIn = new ArrayList<String>();}
    for (String item : items) {this.mrkdwnIn.add(item);} return (A)this;
  }
  
  public A removeFromMrkdwnIn(java.lang.String... items) {
    if (this.mrkdwnIn == null) return (A)this;
    for (String item : items) { this.mrkdwnIn.remove(item);} return (A)this;
  }
  
  public A removeAllFromMrkdwnIn(Collection<String> items) {
    if (this.mrkdwnIn == null) return (A)this;
    for (String item : items) { this.mrkdwnIn.remove(item);} return (A)this;
  }
  
  public List<String> getMrkdwnIn() {
    return this.mrkdwnIn;
  }
  
  public String getMrkdwnIn(int index) {
    return this.mrkdwnIn.get(index);
  }
  
  public String getFirstMrkdwnIn() {
    return this.mrkdwnIn.get(0);
  }
  
  public String getLastMrkdwnIn() {
    return this.mrkdwnIn.get(mrkdwnIn.size() - 1);
  }
  
  public String getMatchingMrkdwnIn(Predicate<String> predicate) {
      for (String item : mrkdwnIn) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMrkdwnIn(Predicate<String> predicate) {
      for (String item : mrkdwnIn) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMrkdwnIn(List<String> mrkdwnIn) {
    if (mrkdwnIn != null) {
        this.mrkdwnIn = new ArrayList();
        for (String item : mrkdwnIn) {
          this.addToMrkdwnIn(item);
        }
    } else {
      this.mrkdwnIn = null;
    }
    return (A) this;
  }
  
  public A withMrkdwnIn(java.lang.String... mrkdwnIn) {
    if (this.mrkdwnIn != null) {
        this.mrkdwnIn.clear();
        _visitables.remove("mrkdwnIn");
    }
    if (mrkdwnIn != null) {
      for (String item : mrkdwnIn) {
        this.addToMrkdwnIn(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMrkdwnIn() {
    return this.mrkdwnIn != null && !this.mrkdwnIn.isEmpty();
  }
  
  public String getPretext() {
    return this.pretext;
  }
  
  public A withPretext(String pretext) {
    this.pretext = pretext;
    return (A) this;
  }
  
  public boolean hasPretext() {
    return this.pretext != null;
  }
  
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved = sendResolved;
    return (A) this;
  }
  
  public boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  
  public Boolean getShortFields() {
    return this.shortFields;
  }
  
  public A withShortFields(Boolean shortFields) {
    this.shortFields = shortFields;
    return (A) this;
  }
  
  public boolean hasShortFields() {
    return this.shortFields != null;
  }
  
  public String getText() {
    return this.text;
  }
  
  public A withText(String text) {
    this.text = text;
    return (A) this;
  }
  
  public boolean hasText() {
    return this.text != null;
  }
  
  public String getThumbURL() {
    return this.thumbURL;
  }
  
  public A withThumbURL(String thumbURL) {
    this.thumbURL = thumbURL;
    return (A) this;
  }
  
  public boolean hasThumbURL() {
    return this.thumbURL != null;
  }
  
  public String getTitle() {
    return this.title;
  }
  
  public A withTitle(String title) {
    this.title = title;
    return (A) this;
  }
  
  public boolean hasTitle() {
    return this.title != null;
  }
  
  public String getTitleLink() {
    return this.titleLink;
  }
  
  public A withTitleLink(String titleLink) {
    this.titleLink = titleLink;
    return (A) this;
  }
  
  public boolean hasTitleLink() {
    return this.titleLink != null;
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username = username;
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SlackConfigFluent that = (SlackConfigFluent) o;
    if (!java.util.Objects.equals(actions, that.actions)) return false;
    if (!java.util.Objects.equals(apiURL, that.apiURL)) return false;
    if (!java.util.Objects.equals(callbackId, that.callbackId)) return false;
    if (!java.util.Objects.equals(channel, that.channel)) return false;
    if (!java.util.Objects.equals(color, that.color)) return false;
    if (!java.util.Objects.equals(fallback, that.fallback)) return false;
    if (!java.util.Objects.equals(fields, that.fields)) return false;
    if (!java.util.Objects.equals(footer, that.footer)) return false;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(iconEmoji, that.iconEmoji)) return false;
    if (!java.util.Objects.equals(iconURL, that.iconURL)) return false;
    if (!java.util.Objects.equals(imageURL, that.imageURL)) return false;
    if (!java.util.Objects.equals(linkNames, that.linkNames)) return false;
    if (!java.util.Objects.equals(mrkdwnIn, that.mrkdwnIn)) return false;
    if (!java.util.Objects.equals(pretext, that.pretext)) return false;
    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;
    if (!java.util.Objects.equals(shortFields, that.shortFields)) return false;
    if (!java.util.Objects.equals(text, that.text)) return false;
    if (!java.util.Objects.equals(thumbURL, that.thumbURL)) return false;
    if (!java.util.Objects.equals(title, that.title)) return false;
    if (!java.util.Objects.equals(titleLink, that.titleLink)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(actions,  apiURL,  callbackId,  channel,  color,  fallback,  fields,  footer,  httpConfig,  iconEmoji,  iconURL,  imageURL,  linkNames,  mrkdwnIn,  pretext,  sendResolved,  shortFields,  text,  thumbURL,  title,  titleLink,  username,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (actions != null && !actions.isEmpty()) { sb.append("actions:"); sb.append(actions + ","); }
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (callbackId != null) { sb.append("callbackId:"); sb.append(callbackId + ","); }
    if (channel != null) { sb.append("channel:"); sb.append(channel + ","); }
    if (color != null) { sb.append("color:"); sb.append(color + ","); }
    if (fallback != null) { sb.append("fallback:"); sb.append(fallback + ","); }
    if (fields != null && !fields.isEmpty()) { sb.append("fields:"); sb.append(fields + ","); }
    if (footer != null) { sb.append("footer:"); sb.append(footer + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (iconEmoji != null) { sb.append("iconEmoji:"); sb.append(iconEmoji + ","); }
    if (iconURL != null) { sb.append("iconURL:"); sb.append(iconURL + ","); }
    if (imageURL != null) { sb.append("imageURL:"); sb.append(imageURL + ","); }
    if (linkNames != null) { sb.append("linkNames:"); sb.append(linkNames + ","); }
    if (mrkdwnIn != null && !mrkdwnIn.isEmpty()) { sb.append("mrkdwnIn:"); sb.append(mrkdwnIn + ","); }
    if (pretext != null) { sb.append("pretext:"); sb.append(pretext + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (shortFields != null) { sb.append("shortFields:"); sb.append(shortFields + ","); }
    if (text != null) { sb.append("text:"); sb.append(text + ","); }
    if (thumbURL != null) { sb.append("thumbURL:"); sb.append(thumbURL + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (titleLink != null) { sb.append("titleLink:"); sb.append(titleLink + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withLinkNames() {
    return withLinkNames(true);
  }
  
  public A withSendResolved() {
    return withSendResolved(true);
  }
  
  public A withShortFields() {
    return withShortFields(true);
  }
  public class ActionsNested<N> extends SlackActionFluent<ActionsNested<N>> implements Nested<N>{
    ActionsNested(int index,SlackAction item) {
      this.index = index;
      this.builder = new SlackActionBuilder(this, item);
    }
    SlackActionBuilder builder;
    int index;
    
    public N and() {
      return (N) SlackConfigFluent.this.setToActions(index,builder.build());
    }
    
    public N endAction() {
      return and();
    }
    
  
  }
  public class FieldsNested<N> extends SlackFieldFluent<FieldsNested<N>> implements Nested<N>{
    FieldsNested(int index,SlackField item) {
      this.index = index;
      this.builder = new SlackFieldBuilder(this, item);
    }
    SlackFieldBuilder builder;
    int index;
    
    public N and() {
      return (N) SlackConfigFluent.this.setToFields(index,builder.build());
    }
    
    public N endField() {
      return and();
    }
    
  
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) SlackConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }

}