package io.fabric8.openshift.api.model.monitoring.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WeChatConfigFluent<A extends WeChatConfigFluent<A>> extends BaseFluent<A>{
  public WeChatConfigFluent() {
  }
  
  public WeChatConfigFluent(WeChatConfig instance) {
    this.copyInstance(instance);
  }
  private String agentID;
  private SecretKeySelectorBuilder apiSecret;
  private String apiURL;
  private String corpID;
  private HTTPConfigBuilder httpConfig;
  private String message;
  private String messageType;
  private Boolean sendResolved;
  private String toParty;
  private String toTag;
  private String toUser;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WeChatConfig instance) {
    instance = (instance != null ? instance : new WeChatConfig());
    if (instance != null) {
          this.withAgentID(instance.getAgentID());
          this.withApiSecret(instance.getApiSecret());
          this.withApiURL(instance.getApiURL());
          this.withCorpID(instance.getCorpID());
          this.withHttpConfig(instance.getHttpConfig());
          this.withMessage(instance.getMessage());
          this.withMessageType(instance.getMessageType());
          this.withSendResolved(instance.getSendResolved());
          this.withToParty(instance.getToParty());
          this.withToTag(instance.getToTag());
          this.withToUser(instance.getToUser());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAgentID() {
    return this.agentID;
  }
  
  public A withAgentID(String agentID) {
    this.agentID = agentID;
    return (A) this;
  }
  
  public boolean hasAgentID() {
    return this.agentID != null;
  }
  
  public SecretKeySelector buildApiSecret() {
    return this.apiSecret != null ? this.apiSecret.build() : null;
  }
  
  public A withApiSecret(SecretKeySelector apiSecret) {
    this._visitables.remove("apiSecret");
    if (apiSecret != null) {
        this.apiSecret = new SecretKeySelectorBuilder(apiSecret);
        this._visitables.get("apiSecret").add(this.apiSecret);
    } else {
        this.apiSecret = null;
        this._visitables.get("apiSecret").remove(this.apiSecret);
    }
    return (A) this;
  }
  
  public boolean hasApiSecret() {
    return this.apiSecret != null;
  }
  
  public A withNewApiSecret(String key,String name) {
    return (A)withApiSecret(new SecretKeySelector(key, name));
  }
  
  public ApiSecretNested<A> withNewApiSecret() {
    return new ApiSecretNested(null);
  }
  
  public ApiSecretNested<A> withNewApiSecretLike(SecretKeySelector item) {
    return new ApiSecretNested(item);
  }
  
  public ApiSecretNested<A> editApiSecret() {
    return withNewApiSecretLike(java.util.Optional.ofNullable(buildApiSecret()).orElse(null));
  }
  
  public ApiSecretNested<A> editOrNewApiSecret() {
    return withNewApiSecretLike(java.util.Optional.ofNullable(buildApiSecret()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ApiSecretNested<A> editOrNewApiSecretLike(SecretKeySelector item) {
    return withNewApiSecretLike(java.util.Optional.ofNullable(buildApiSecret()).orElse(item));
  }
  
  public String getApiURL() {
    return this.apiURL;
  }
  
  public A withApiURL(String apiURL) {
    this.apiURL = apiURL;
    return (A) this;
  }
  
  public boolean hasApiURL() {
    return this.apiURL != null;
  }
  
  public String getCorpID() {
    return this.corpID;
  }
  
  public A withCorpID(String corpID) {
    this.corpID = corpID;
    return (A) this;
  }
  
  public boolean hasCorpID() {
    return this.corpID != null;
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public String getMessage() {
    return this.message;
  }
  
  public A withMessage(String message) {
    this.message = message;
    return (A) this;
  }
  
  public boolean hasMessage() {
    return this.message != null;
  }
  
  public String getMessageType() {
    return this.messageType;
  }
  
  public A withMessageType(String messageType) {
    this.messageType = messageType;
    return (A) this;
  }
  
  public boolean hasMessageType() {
    return this.messageType != null;
  }
  
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved = sendResolved;
    return (A) this;
  }
  
  public boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  
  public String getToParty() {
    return this.toParty;
  }
  
  public A withToParty(String toParty) {
    this.toParty = toParty;
    return (A) this;
  }
  
  public boolean hasToParty() {
    return this.toParty != null;
  }
  
  public String getToTag() {
    return this.toTag;
  }
  
  public A withToTag(String toTag) {
    this.toTag = toTag;
    return (A) this;
  }
  
  public boolean hasToTag() {
    return this.toTag != null;
  }
  
  public String getToUser() {
    return this.toUser;
  }
  
  public A withToUser(String toUser) {
    this.toUser = toUser;
    return (A) this;
  }
  
  public boolean hasToUser() {
    return this.toUser != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WeChatConfigFluent that = (WeChatConfigFluent) o;
    if (!java.util.Objects.equals(agentID, that.agentID)) return false;
    if (!java.util.Objects.equals(apiSecret, that.apiSecret)) return false;
    if (!java.util.Objects.equals(apiURL, that.apiURL)) return false;
    if (!java.util.Objects.equals(corpID, that.corpID)) return false;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(message, that.message)) return false;
    if (!java.util.Objects.equals(messageType, that.messageType)) return false;
    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;
    if (!java.util.Objects.equals(toParty, that.toParty)) return false;
    if (!java.util.Objects.equals(toTag, that.toTag)) return false;
    if (!java.util.Objects.equals(toUser, that.toUser)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(agentID,  apiSecret,  apiURL,  corpID,  httpConfig,  message,  messageType,  sendResolved,  toParty,  toTag,  toUser,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (agentID != null) { sb.append("agentID:"); sb.append(agentID + ","); }
    if (apiSecret != null) { sb.append("apiSecret:"); sb.append(apiSecret + ","); }
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (corpID != null) { sb.append("corpID:"); sb.append(corpID + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (messageType != null) { sb.append("messageType:"); sb.append(messageType + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (toParty != null) { sb.append("toParty:"); sb.append(toParty + ","); }
    if (toTag != null) { sb.append("toTag:"); sb.append(toTag + ","); }
    if (toUser != null) { sb.append("toUser:"); sb.append(toUser + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSendResolved() {
    return withSendResolved(true);
  }
  public class ApiSecretNested<N> extends SecretKeySelectorFluent<ApiSecretNested<N>> implements Nested<N>{
    ApiSecretNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) WeChatConfigFluent.this.withApiSecret(builder.build());
    }
    
    public N endApiSecret() {
      return and();
    }
    
  
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) WeChatConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }

}