/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValue;
import io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValueBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValueFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.OpsGenieConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.OpsGenieConfigResponder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.OpsGenieConfigResponderBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.OpsGenieConfigResponderFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelectorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OpsGenieConfigFluent<A extends OpsGenieConfigFluent<A>>
extends BaseFluent<A> {
    private String actions;
    private SecretKeySelectorBuilder apiKey;
    private String apiURL;
    private String description;
    private ArrayList<KeyValueBuilder> details = new ArrayList();
    private String entity;
    private HTTPConfigBuilder httpConfig;
    private String message;
    private String note;
    private String priority;
    private ArrayList<OpsGenieConfigResponderBuilder> responders = new ArrayList();
    private Boolean sendResolved;
    private String source;
    private String tags;
    private Map<String, Object> additionalProperties;

    public OpsGenieConfigFluent() {
    }

    public OpsGenieConfigFluent(OpsGenieConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OpsGenieConfig instance) {
        OpsGenieConfig opsGenieConfig = instance = instance != null ? instance : new OpsGenieConfig();
        if (instance != null) {
            this.withActions(instance.getActions());
            this.withApiKey(instance.getApiKey());
            this.withApiURL(instance.getApiURL());
            this.withDescription(instance.getDescription());
            this.withDetails(instance.getDetails());
            this.withEntity(instance.getEntity());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessage(instance.getMessage());
            this.withNote(instance.getNote());
            this.withPriority(instance.getPriority());
            this.withResponders(instance.getResponders());
            this.withSendResolved(instance.getSendResolved());
            this.withSource(instance.getSource());
            this.withTags(instance.getTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getActions() {
        return this.actions;
    }

    public A withActions(String actions) {
        this.actions = actions;
        return (A)((Object)this);
    }

    public boolean hasActions() {
        return this.actions != null;
    }

    public SecretKeySelector buildApiKey() {
        return this.apiKey != null ? this.apiKey.build() : null;
    }

    public A withApiKey(SecretKeySelector apiKey) {
        this._visitables.remove((Object)"apiKey");
        if (apiKey != null) {
            this.apiKey = new SecretKeySelectorBuilder(apiKey);
            this._visitables.get((Object)"apiKey").add(this.apiKey);
        } else {
            this.apiKey = null;
            this._visitables.get((Object)"apiKey").remove((Object)this.apiKey);
        }
        return (A)((Object)this);
    }

    public boolean hasApiKey() {
        return this.apiKey != null;
    }

    public A withNewApiKey(String key, String name) {
        return this.withApiKey(new SecretKeySelector(key, name));
    }

    public ApiKeyNested<A> withNewApiKey() {
        return new ApiKeyNested(null);
    }

    public ApiKeyNested<A> withNewApiKeyLike(SecretKeySelector item) {
        return new ApiKeyNested(item);
    }

    public ApiKeyNested<A> editApiKey() {
        return this.withNewApiKeyLike(Optional.ofNullable(this.buildApiKey()).orElse(null));
    }

    public ApiKeyNested<A> editOrNewApiKey() {
        return this.withNewApiKeyLike(Optional.ofNullable(this.buildApiKey()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public ApiKeyNested<A> editOrNewApiKeyLike(SecretKeySelector item) {
        return this.withNewApiKeyLike(Optional.ofNullable(this.buildApiKey()).orElse(item));
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public A withApiURL(String apiURL) {
        this.apiURL = apiURL;
        return (A)((Object)this);
    }

    public boolean hasApiURL() {
        return this.apiURL != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public A addToDetails(int index, KeyValue item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDetails(int index, KeyValue item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").add(builder);
            this.details.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDetails(KeyValue ... items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDetails(Collection<KeyValue> items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDetails(KeyValue ... items) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").remove((Object)builder);
            this.details.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDetails(Collection<KeyValue> items) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").remove((Object)builder);
            this.details.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDetails(Predicate<KeyValueBuilder> predicate) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        Iterator<KeyValueBuilder> each = this.details.iterator();
        List visitables = this._visitables.get((Object)"details");
        while (each.hasNext()) {
            KeyValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<KeyValue> buildDetails() {
        return this.details != null ? OpsGenieConfigFluent.build(this.details) : null;
    }

    public KeyValue buildDetail(int index) {
        return this.details.get(index).build();
    }

    public KeyValue buildFirstDetail() {
        return this.details.get(0).build();
    }

    public KeyValue buildLastDetail() {
        return this.details.get(this.details.size() - 1).build();
    }

    public KeyValue buildMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDetails(List<KeyValue> details) {
        if (this.details != null) {
            this._visitables.get((Object)"details").clear();
        }
        if (details != null) {
            this.details = new ArrayList();
            for (KeyValue item : details) {
                this.addToDetails(item);
            }
        } else {
            this.details = null;
        }
        return (A)((Object)this);
    }

    public A withDetails(KeyValue ... details) {
        if (this.details != null) {
            this.details.clear();
            this._visitables.remove((Object)"details");
        }
        if (details != null) {
            for (KeyValue item : details) {
                this.addToDetails(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    public A addNewDetail(String key, String value) {
        return this.addToDetails(new KeyValue(key, value));
    }

    public DetailsNested<A> addNewDetail() {
        return new DetailsNested(-1, null);
    }

    public DetailsNested<A> addNewDetailLike(KeyValue item) {
        return new DetailsNested(-1, item);
    }

    public DetailsNested<A> setNewDetailLike(int index, KeyValue item) {
        return new DetailsNested(index, item);
    }

    public DetailsNested<A> editDetail(int index) {
        if (this.details.size() <= index) {
            throw new RuntimeException("Can't edit details. Index exceeds size.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public DetailsNested<A> editFirstDetail() {
        if (this.details.size() == 0) {
            throw new RuntimeException("Can't edit first details. The list is empty.");
        }
        return this.setNewDetailLike(0, this.buildDetail(0));
    }

    public DetailsNested<A> editLastDetail() {
        int index = this.details.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last details. The list is empty.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public DetailsNested<A> editMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.details.size(); ++i) {
            if (!predicate.test(this.details.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching details. No match found.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public String getEntity() {
        return this.entity;
    }

    public A withEntity(String entity) {
        this.entity = entity;
        return (A)((Object)this);
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove((Object)"httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get((Object)"httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get((Object)"httpConfig").remove((Object)this.httpConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getNote() {
        return this.note;
    }

    public A withNote(String note) {
        this.note = note;
        return (A)((Object)this);
    }

    public boolean hasNote() {
        return this.note != null;
    }

    public String getPriority() {
        return this.priority;
    }

    public A withPriority(String priority) {
        this.priority = priority;
        return (A)((Object)this);
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public A addToResponders(int index, OpsGenieConfigResponder item) {
        if (this.responders == null) {
            this.responders = new ArrayList();
        }
        OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
        if (index < 0 || index >= this.responders.size()) {
            this._visitables.get((Object)"responders").add(builder);
            this.responders.add(builder);
        } else {
            this._visitables.get((Object)"responders").add(builder);
            this.responders.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResponders(int index, OpsGenieConfigResponder item) {
        if (this.responders == null) {
            this.responders = new ArrayList();
        }
        OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
        if (index < 0 || index >= this.responders.size()) {
            this._visitables.get((Object)"responders").add(builder);
            this.responders.add(builder);
        } else {
            this._visitables.get((Object)"responders").add(builder);
            this.responders.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResponders(OpsGenieConfigResponder ... items) {
        if (this.responders == null) {
            this.responders = new ArrayList();
        }
        for (OpsGenieConfigResponder item : items) {
            OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
            this._visitables.get((Object)"responders").add(builder);
            this.responders.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResponders(Collection<OpsGenieConfigResponder> items) {
        if (this.responders == null) {
            this.responders = new ArrayList();
        }
        for (OpsGenieConfigResponder item : items) {
            OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
            this._visitables.get((Object)"responders").add(builder);
            this.responders.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResponders(OpsGenieConfigResponder ... items) {
        if (this.responders == null) {
            return (A)((Object)this);
        }
        for (OpsGenieConfigResponder item : items) {
            OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
            this._visitables.get((Object)"responders").remove((Object)builder);
            this.responders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResponders(Collection<OpsGenieConfigResponder> items) {
        if (this.responders == null) {
            return (A)((Object)this);
        }
        for (OpsGenieConfigResponder item : items) {
            OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
            this._visitables.get((Object)"responders").remove((Object)builder);
            this.responders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResponders(Predicate<OpsGenieConfigResponderBuilder> predicate) {
        if (this.responders == null) {
            return (A)((Object)this);
        }
        Iterator<OpsGenieConfigResponderBuilder> each = this.responders.iterator();
        List visitables = this._visitables.get((Object)"responders");
        while (each.hasNext()) {
            OpsGenieConfigResponderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<OpsGenieConfigResponder> buildResponders() {
        return this.responders != null ? OpsGenieConfigFluent.build(this.responders) : null;
    }

    public OpsGenieConfigResponder buildResponder(int index) {
        return this.responders.get(index).build();
    }

    public OpsGenieConfigResponder buildFirstResponder() {
        return this.responders.get(0).build();
    }

    public OpsGenieConfigResponder buildLastResponder() {
        return this.responders.get(this.responders.size() - 1).build();
    }

    public OpsGenieConfigResponder buildMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
        for (OpsGenieConfigResponderBuilder item : this.responders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
        for (OpsGenieConfigResponderBuilder item : this.responders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResponders(List<OpsGenieConfigResponder> responders) {
        if (this.responders != null) {
            this._visitables.get((Object)"responders").clear();
        }
        if (responders != null) {
            this.responders = new ArrayList();
            for (OpsGenieConfigResponder item : responders) {
                this.addToResponders(item);
            }
        } else {
            this.responders = null;
        }
        return (A)((Object)this);
    }

    public A withResponders(OpsGenieConfigResponder ... responders) {
        if (this.responders != null) {
            this.responders.clear();
            this._visitables.remove((Object)"responders");
        }
        if (responders != null) {
            for (OpsGenieConfigResponder item : responders) {
                this.addToResponders(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResponders() {
        return this.responders != null && !this.responders.isEmpty();
    }

    public A addNewResponder(String id, String name, String type, String username) {
        return this.addToResponders(new OpsGenieConfigResponder(id, name, type, username));
    }

    public RespondersNested<A> addNewResponder() {
        return new RespondersNested(-1, null);
    }

    public RespondersNested<A> addNewResponderLike(OpsGenieConfigResponder item) {
        return new RespondersNested(-1, item);
    }

    public RespondersNested<A> setNewResponderLike(int index, OpsGenieConfigResponder item) {
        return new RespondersNested(index, item);
    }

    public RespondersNested<A> editResponder(int index) {
        if (this.responders.size() <= index) {
            throw new RuntimeException("Can't edit responders. Index exceeds size.");
        }
        return this.setNewResponderLike(index, this.buildResponder(index));
    }

    public RespondersNested<A> editFirstResponder() {
        if (this.responders.size() == 0) {
            throw new RuntimeException("Can't edit first responders. The list is empty.");
        }
        return this.setNewResponderLike(0, this.buildResponder(0));
    }

    public RespondersNested<A> editLastResponder() {
        int index = this.responders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last responders. The list is empty.");
        }
        return this.setNewResponderLike(index, this.buildResponder(index));
    }

    public RespondersNested<A> editMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.responders.size(); ++i) {
            if (!predicate.test(this.responders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching responders. No match found.");
        }
        return this.setNewResponderLike(index, this.buildResponder(index));
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)((Object)this);
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getTags() {
        return this.tags;
    }

    public A withTags(String tags) {
        this.tags = tags;
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpsGenieConfigFluent that = (OpsGenieConfigFluent)((Object)o);
        if (!Objects.equals(this.actions, that.actions)) {
            return false;
        }
        if (!Objects.equals((Object)this.apiKey, (Object)that.apiKey)) {
            return false;
        }
        if (!Objects.equals(this.apiURL, that.apiURL)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.details, that.details)) {
            return false;
        }
        if (!Objects.equals(this.entity, that.entity)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpConfig, (Object)that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.note, that.note)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.responders, that.responders)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actions, this.apiKey, this.apiURL, this.description, this.details, this.entity, this.httpConfig, this.message, this.note, this.priority, this.responders, this.sendResolved, this.source, this.tags, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actions != null) {
            sb.append("actions:");
            sb.append(this.actions + ",");
        }
        if (this.apiKey != null) {
            sb.append("apiKey:");
            sb.append(String.valueOf((Object)this.apiKey) + ",");
        }
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(this.apiURL + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.details != null && !this.details.isEmpty()) {
            sb.append("details:");
            sb.append(String.valueOf(this.details) + ",");
        }
        if (this.entity != null) {
            sb.append("entity:");
            sb.append(this.entity + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(String.valueOf((Object)this.httpConfig) + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.note != null) {
            sb.append("note:");
            sb.append(this.note + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.responders != null && !this.responders.isEmpty()) {
            sb.append("responders:");
            sb.append(String.valueOf(this.responders) + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.tags != null) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public class RespondersNested<N>
    extends OpsGenieConfigResponderFluent<RespondersNested<N>>
    implements Nested<N> {
        OpsGenieConfigResponderBuilder builder;
        int index;

        RespondersNested(int index, OpsGenieConfigResponder item) {
            this.index = index;
            this.builder = new OpsGenieConfigResponderBuilder(this, item);
        }

        public N and() {
            return (N)OpsGenieConfigFluent.this.setToResponders(this.index, this.builder.build());
        }

        public N endResponder() {
            return this.and();
        }
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        public N and() {
            return (N)OpsGenieConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }

    public class DetailsNested<N>
    extends KeyValueFluent<DetailsNested<N>>
    implements Nested<N> {
        KeyValueBuilder builder;
        int index;

        DetailsNested(int index, KeyValue item) {
            this.index = index;
            this.builder = new KeyValueBuilder(this, item);
        }

        public N and() {
            return (N)OpsGenieConfigFluent.this.setToDetails(this.index, this.builder.build());
        }

        public N endDetail() {
            return this.and();
        }
    }

    public class ApiKeyNested<N>
    extends SecretKeySelectorFluent<ApiKeyNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        ApiKeyNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)OpsGenieConfigFluent.this.withApiKey(this.builder.build());
        }

        public N endApiKey() {
            return this.and();
        }
    }
}

