package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OTLPConfigFluent<A extends OTLPConfigFluent<A>> extends BaseFluent<A>{
  public OTLPConfigFluent() {
  }
  
  public OTLPConfigFluent(OTLPConfig instance) {
    this.copyInstance(instance);
  }
  private List<String> promoteResourceAttributes = new ArrayList<String>();
  private String translationStrategy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OTLPConfig instance) {
    instance = (instance != null ? instance : new OTLPConfig());
    if (instance != null) {
          this.withPromoteResourceAttributes(instance.getPromoteResourceAttributes());
          this.withTranslationStrategy(instance.getTranslationStrategy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToPromoteResourceAttributes(int index,String item) {
    if (this.promoteResourceAttributes == null) {this.promoteResourceAttributes = new ArrayList<String>();}
    this.promoteResourceAttributes.add(index, item);
    return (A)this;
  }
  
  public A setToPromoteResourceAttributes(int index,String item) {
    if (this.promoteResourceAttributes == null) {this.promoteResourceAttributes = new ArrayList<String>();}
    this.promoteResourceAttributes.set(index, item); return (A)this;
  }
  
  public A addToPromoteResourceAttributes(java.lang.String... items) {
    if (this.promoteResourceAttributes == null) {this.promoteResourceAttributes = new ArrayList<String>();}
    for (String item : items) {this.promoteResourceAttributes.add(item);} return (A)this;
  }
  
  public A addAllToPromoteResourceAttributes(Collection<String> items) {
    if (this.promoteResourceAttributes == null) {this.promoteResourceAttributes = new ArrayList<String>();}
    for (String item : items) {this.promoteResourceAttributes.add(item);} return (A)this;
  }
  
  public A removeFromPromoteResourceAttributes(java.lang.String... items) {
    if (this.promoteResourceAttributes == null) return (A)this;
    for (String item : items) { this.promoteResourceAttributes.remove(item);} return (A)this;
  }
  
  public A removeAllFromPromoteResourceAttributes(Collection<String> items) {
    if (this.promoteResourceAttributes == null) return (A)this;
    for (String item : items) { this.promoteResourceAttributes.remove(item);} return (A)this;
  }
  
  public List<String> getPromoteResourceAttributes() {
    return this.promoteResourceAttributes;
  }
  
  public String getPromoteResourceAttribute(int index) {
    return this.promoteResourceAttributes.get(index);
  }
  
  public String getFirstPromoteResourceAttribute() {
    return this.promoteResourceAttributes.get(0);
  }
  
  public String getLastPromoteResourceAttribute() {
    return this.promoteResourceAttributes.get(promoteResourceAttributes.size() - 1);
  }
  
  public String getMatchingPromoteResourceAttribute(Predicate<String> predicate) {
      for (String item : promoteResourceAttributes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingPromoteResourceAttribute(Predicate<String> predicate) {
      for (String item : promoteResourceAttributes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPromoteResourceAttributes(List<String> promoteResourceAttributes) {
    if (promoteResourceAttributes != null) {
        this.promoteResourceAttributes = new ArrayList();
        for (String item : promoteResourceAttributes) {
          this.addToPromoteResourceAttributes(item);
        }
    } else {
      this.promoteResourceAttributes = null;
    }
    return (A) this;
  }
  
  public A withPromoteResourceAttributes(java.lang.String... promoteResourceAttributes) {
    if (this.promoteResourceAttributes != null) {
        this.promoteResourceAttributes.clear();
        _visitables.remove("promoteResourceAttributes");
    }
    if (promoteResourceAttributes != null) {
      for (String item : promoteResourceAttributes) {
        this.addToPromoteResourceAttributes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPromoteResourceAttributes() {
    return this.promoteResourceAttributes != null && !this.promoteResourceAttributes.isEmpty();
  }
  
  public String getTranslationStrategy() {
    return this.translationStrategy;
  }
  
  public A withTranslationStrategy(String translationStrategy) {
    this.translationStrategy = translationStrategy;
    return (A) this;
  }
  
  public boolean hasTranslationStrategy() {
    return this.translationStrategy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OTLPConfigFluent that = (OTLPConfigFluent) o;
    if (!java.util.Objects.equals(promoteResourceAttributes, that.promoteResourceAttributes)) return false;
    if (!java.util.Objects.equals(translationStrategy, that.translationStrategy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(promoteResourceAttributes,  translationStrategy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (promoteResourceAttributes != null && !promoteResourceAttributes.isEmpty()) { sb.append("promoteResourceAttributes:"); sb.append(promoteResourceAttributes + ","); }
    if (translationStrategy != null) { sb.append("translationStrategy:"); sb.append(translationStrategy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}