package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class QuerySpecFluent<A extends QuerySpecFluent<A>> extends BaseFluent<A>{
  public QuerySpecFluent() {
  }
  
  public QuerySpecFluent(QuerySpec instance) {
    this.copyInstance(instance);
  }
  private String lookbackDelta;
  private Integer maxConcurrency;
  private Integer maxSamples;
  private String timeout;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(QuerySpec instance) {
    instance = (instance != null ? instance : new QuerySpec());
    if (instance != null) {
          this.withLookbackDelta(instance.getLookbackDelta());
          this.withMaxConcurrency(instance.getMaxConcurrency());
          this.withMaxSamples(instance.getMaxSamples());
          this.withTimeout(instance.getTimeout());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getLookbackDelta() {
    return this.lookbackDelta;
  }
  
  public A withLookbackDelta(String lookbackDelta) {
    this.lookbackDelta = lookbackDelta;
    return (A) this;
  }
  
  public boolean hasLookbackDelta() {
    return this.lookbackDelta != null;
  }
  
  public Integer getMaxConcurrency() {
    return this.maxConcurrency;
  }
  
  public A withMaxConcurrency(Integer maxConcurrency) {
    this.maxConcurrency = maxConcurrency;
    return (A) this;
  }
  
  public boolean hasMaxConcurrency() {
    return this.maxConcurrency != null;
  }
  
  public Integer getMaxSamples() {
    return this.maxSamples;
  }
  
  public A withMaxSamples(Integer maxSamples) {
    this.maxSamples = maxSamples;
    return (A) this;
  }
  
  public boolean hasMaxSamples() {
    return this.maxSamples != null;
  }
  
  public String getTimeout() {
    return this.timeout;
  }
  
  public A withTimeout(String timeout) {
    this.timeout = timeout;
    return (A) this;
  }
  
  public boolean hasTimeout() {
    return this.timeout != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QuerySpecFluent that = (QuerySpecFluent) o;
    if (!java.util.Objects.equals(lookbackDelta, that.lookbackDelta)) return false;
    if (!java.util.Objects.equals(maxConcurrency, that.maxConcurrency)) return false;
    if (!java.util.Objects.equals(maxSamples, that.maxSamples)) return false;
    if (!java.util.Objects.equals(timeout, that.timeout)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(lookbackDelta,  maxConcurrency,  maxSamples,  timeout,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (lookbackDelta != null) { sb.append("lookbackDelta:"); sb.append(lookbackDelta + ","); }
    if (maxConcurrency != null) { sb.append("maxConcurrency:"); sb.append(maxConcurrency + ","); }
    if (maxSamples != null) { sb.append("maxSamples:"); sb.append(maxSamples + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}