package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AlertmanagerConfigSpecFluent<A extends AlertmanagerConfigSpecFluent<A>> extends BaseFluent<A>{
  public AlertmanagerConfigSpecFluent() {
  }
  
  public AlertmanagerConfigSpecFluent(AlertmanagerConfigSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<InhibitRuleBuilder> inhibitRules = new ArrayList<InhibitRuleBuilder>();
  private ArrayList<MuteTimeIntervalBuilder> muteTimeIntervals = new ArrayList<MuteTimeIntervalBuilder>();
  private ArrayList<ReceiverBuilder> receivers = new ArrayList<ReceiverBuilder>();
  private RouteBuilder route;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AlertmanagerConfigSpec instance) {
    instance = (instance != null ? instance : new AlertmanagerConfigSpec());
    if (instance != null) {
          this.withInhibitRules(instance.getInhibitRules());
          this.withMuteTimeIntervals(instance.getMuteTimeIntervals());
          this.withReceivers(instance.getReceivers());
          this.withRoute(instance.getRoute());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToInhibitRules(int index,InhibitRule item) {
    if (this.inhibitRules == null) {this.inhibitRules = new ArrayList<InhibitRuleBuilder>();}
    InhibitRuleBuilder builder = new InhibitRuleBuilder(item);
    if (index < 0 || index >= inhibitRules.size()) {
        _visitables.get("inhibitRules").add(builder);
        inhibitRules.add(builder);
    } else {
        _visitables.get("inhibitRules").add(builder);
        inhibitRules.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToInhibitRules(int index,InhibitRule item) {
    if (this.inhibitRules == null) {this.inhibitRules = new ArrayList<InhibitRuleBuilder>();}
    InhibitRuleBuilder builder = new InhibitRuleBuilder(item);
    if (index < 0 || index >= inhibitRules.size()) {
        _visitables.get("inhibitRules").add(builder);
        inhibitRules.add(builder);
    } else {
        _visitables.get("inhibitRules").add(builder);
        inhibitRules.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToInhibitRules(io.fabric8.openshift.api.model.monitoring.v1alpha1.InhibitRule... items) {
    if (this.inhibitRules == null) {this.inhibitRules = new ArrayList<InhibitRuleBuilder>();}
    for (InhibitRule item : items) {InhibitRuleBuilder builder = new InhibitRuleBuilder(item);_visitables.get("inhibitRules").add(builder);this.inhibitRules.add(builder);} return (A)this;
  }
  
  public A addAllToInhibitRules(Collection<InhibitRule> items) {
    if (this.inhibitRules == null) {this.inhibitRules = new ArrayList<InhibitRuleBuilder>();}
    for (InhibitRule item : items) {InhibitRuleBuilder builder = new InhibitRuleBuilder(item);_visitables.get("inhibitRules").add(builder);this.inhibitRules.add(builder);} return (A)this;
  }
  
  public A removeFromInhibitRules(io.fabric8.openshift.api.model.monitoring.v1alpha1.InhibitRule... items) {
    if (this.inhibitRules == null) return (A)this;
    for (InhibitRule item : items) {InhibitRuleBuilder builder = new InhibitRuleBuilder(item);_visitables.get("inhibitRules").remove(builder); this.inhibitRules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInhibitRules(Collection<InhibitRule> items) {
    if (this.inhibitRules == null) return (A)this;
    for (InhibitRule item : items) {InhibitRuleBuilder builder = new InhibitRuleBuilder(item);_visitables.get("inhibitRules").remove(builder); this.inhibitRules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInhibitRules(Predicate<InhibitRuleBuilder> predicate) {
    if (inhibitRules == null) return (A) this;
    final Iterator<InhibitRuleBuilder> each = inhibitRules.iterator();
    final List visitables = _visitables.get("inhibitRules");
    while (each.hasNext()) {
      InhibitRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<InhibitRule> buildInhibitRules() {
    return this.inhibitRules != null ? build(inhibitRules) : null;
  }
  
  public InhibitRule buildInhibitRule(int index) {
    return this.inhibitRules.get(index).build();
  }
  
  public InhibitRule buildFirstInhibitRule() {
    return this.inhibitRules.get(0).build();
  }
  
  public InhibitRule buildLastInhibitRule() {
    return this.inhibitRules.get(inhibitRules.size() - 1).build();
  }
  
  public InhibitRule buildMatchingInhibitRule(Predicate<InhibitRuleBuilder> predicate) {
      for (InhibitRuleBuilder item : inhibitRules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingInhibitRule(Predicate<InhibitRuleBuilder> predicate) {
      for (InhibitRuleBuilder item : inhibitRules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withInhibitRules(List<InhibitRule> inhibitRules) {
    if (this.inhibitRules != null) {
      this._visitables.get("inhibitRules").clear();
    }
    if (inhibitRules != null) {
        this.inhibitRules = new ArrayList();
        for (InhibitRule item : inhibitRules) {
          this.addToInhibitRules(item);
        }
    } else {
      this.inhibitRules = null;
    }
    return (A) this;
  }
  
  public A withInhibitRules(io.fabric8.openshift.api.model.monitoring.v1alpha1.InhibitRule... inhibitRules) {
    if (this.inhibitRules != null) {
        this.inhibitRules.clear();
        _visitables.remove("inhibitRules");
    }
    if (inhibitRules != null) {
      for (InhibitRule item : inhibitRules) {
        this.addToInhibitRules(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasInhibitRules() {
    return this.inhibitRules != null && !this.inhibitRules.isEmpty();
  }
  
  public InhibitRulesNested<A> addNewInhibitRule() {
    return new InhibitRulesNested(-1, null);
  }
  
  public InhibitRulesNested<A> addNewInhibitRuleLike(InhibitRule item) {
    return new InhibitRulesNested(-1, item);
  }
  
  public InhibitRulesNested<A> setNewInhibitRuleLike(int index,InhibitRule item) {
    return new InhibitRulesNested(index, item);
  }
  
  public InhibitRulesNested<A> editInhibitRule(int index) {
    if (inhibitRules.size() <= index) throw new RuntimeException("Can't edit inhibitRules. Index exceeds size.");
    return setNewInhibitRuleLike(index, buildInhibitRule(index));
  }
  
  public InhibitRulesNested<A> editFirstInhibitRule() {
    if (inhibitRules.size() == 0) throw new RuntimeException("Can't edit first inhibitRules. The list is empty.");
    return setNewInhibitRuleLike(0, buildInhibitRule(0));
  }
  
  public InhibitRulesNested<A> editLastInhibitRule() {
    int index = inhibitRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last inhibitRules. The list is empty.");
    return setNewInhibitRuleLike(index, buildInhibitRule(index));
  }
  
  public InhibitRulesNested<A> editMatchingInhibitRule(Predicate<InhibitRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<inhibitRules.size();i++) { 
    if (predicate.test(inhibitRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching inhibitRules. No match found.");
    return setNewInhibitRuleLike(index, buildInhibitRule(index));
  }
  
  public A addToMuteTimeIntervals(int index,MuteTimeInterval item) {
    if (this.muteTimeIntervals == null) {this.muteTimeIntervals = new ArrayList<MuteTimeIntervalBuilder>();}
    MuteTimeIntervalBuilder builder = new MuteTimeIntervalBuilder(item);
    if (index < 0 || index >= muteTimeIntervals.size()) {
        _visitables.get("muteTimeIntervals").add(builder);
        muteTimeIntervals.add(builder);
    } else {
        _visitables.get("muteTimeIntervals").add(builder);
        muteTimeIntervals.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToMuteTimeIntervals(int index,MuteTimeInterval item) {
    if (this.muteTimeIntervals == null) {this.muteTimeIntervals = new ArrayList<MuteTimeIntervalBuilder>();}
    MuteTimeIntervalBuilder builder = new MuteTimeIntervalBuilder(item);
    if (index < 0 || index >= muteTimeIntervals.size()) {
        _visitables.get("muteTimeIntervals").add(builder);
        muteTimeIntervals.add(builder);
    } else {
        _visitables.get("muteTimeIntervals").add(builder);
        muteTimeIntervals.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToMuteTimeIntervals(io.fabric8.openshift.api.model.monitoring.v1alpha1.MuteTimeInterval... items) {
    if (this.muteTimeIntervals == null) {this.muteTimeIntervals = new ArrayList<MuteTimeIntervalBuilder>();}
    for (MuteTimeInterval item : items) {MuteTimeIntervalBuilder builder = new MuteTimeIntervalBuilder(item);_visitables.get("muteTimeIntervals").add(builder);this.muteTimeIntervals.add(builder);} return (A)this;
  }
  
  public A addAllToMuteTimeIntervals(Collection<MuteTimeInterval> items) {
    if (this.muteTimeIntervals == null) {this.muteTimeIntervals = new ArrayList<MuteTimeIntervalBuilder>();}
    for (MuteTimeInterval item : items) {MuteTimeIntervalBuilder builder = new MuteTimeIntervalBuilder(item);_visitables.get("muteTimeIntervals").add(builder);this.muteTimeIntervals.add(builder);} return (A)this;
  }
  
  public A removeFromMuteTimeIntervals(io.fabric8.openshift.api.model.monitoring.v1alpha1.MuteTimeInterval... items) {
    if (this.muteTimeIntervals == null) return (A)this;
    for (MuteTimeInterval item : items) {MuteTimeIntervalBuilder builder = new MuteTimeIntervalBuilder(item);_visitables.get("muteTimeIntervals").remove(builder); this.muteTimeIntervals.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMuteTimeIntervals(Collection<MuteTimeInterval> items) {
    if (this.muteTimeIntervals == null) return (A)this;
    for (MuteTimeInterval item : items) {MuteTimeIntervalBuilder builder = new MuteTimeIntervalBuilder(item);_visitables.get("muteTimeIntervals").remove(builder); this.muteTimeIntervals.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMuteTimeIntervals(Predicate<MuteTimeIntervalBuilder> predicate) {
    if (muteTimeIntervals == null) return (A) this;
    final Iterator<MuteTimeIntervalBuilder> each = muteTimeIntervals.iterator();
    final List visitables = _visitables.get("muteTimeIntervals");
    while (each.hasNext()) {
      MuteTimeIntervalBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MuteTimeInterval> buildMuteTimeIntervals() {
    return this.muteTimeIntervals != null ? build(muteTimeIntervals) : null;
  }
  
  public MuteTimeInterval buildMuteTimeInterval(int index) {
    return this.muteTimeIntervals.get(index).build();
  }
  
  public MuteTimeInterval buildFirstMuteTimeInterval() {
    return this.muteTimeIntervals.get(0).build();
  }
  
  public MuteTimeInterval buildLastMuteTimeInterval() {
    return this.muteTimeIntervals.get(muteTimeIntervals.size() - 1).build();
  }
  
  public MuteTimeInterval buildMatchingMuteTimeInterval(Predicate<MuteTimeIntervalBuilder> predicate) {
      for (MuteTimeIntervalBuilder item : muteTimeIntervals) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMuteTimeInterval(Predicate<MuteTimeIntervalBuilder> predicate) {
      for (MuteTimeIntervalBuilder item : muteTimeIntervals) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMuteTimeIntervals(List<MuteTimeInterval> muteTimeIntervals) {
    if (this.muteTimeIntervals != null) {
      this._visitables.get("muteTimeIntervals").clear();
    }
    if (muteTimeIntervals != null) {
        this.muteTimeIntervals = new ArrayList();
        for (MuteTimeInterval item : muteTimeIntervals) {
          this.addToMuteTimeIntervals(item);
        }
    } else {
      this.muteTimeIntervals = null;
    }
    return (A) this;
  }
  
  public A withMuteTimeIntervals(io.fabric8.openshift.api.model.monitoring.v1alpha1.MuteTimeInterval... muteTimeIntervals) {
    if (this.muteTimeIntervals != null) {
        this.muteTimeIntervals.clear();
        _visitables.remove("muteTimeIntervals");
    }
    if (muteTimeIntervals != null) {
      for (MuteTimeInterval item : muteTimeIntervals) {
        this.addToMuteTimeIntervals(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMuteTimeIntervals() {
    return this.muteTimeIntervals != null && !this.muteTimeIntervals.isEmpty();
  }
  
  public MuteTimeIntervalsNested<A> addNewMuteTimeInterval() {
    return new MuteTimeIntervalsNested(-1, null);
  }
  
  public MuteTimeIntervalsNested<A> addNewMuteTimeIntervalLike(MuteTimeInterval item) {
    return new MuteTimeIntervalsNested(-1, item);
  }
  
  public MuteTimeIntervalsNested<A> setNewMuteTimeIntervalLike(int index,MuteTimeInterval item) {
    return new MuteTimeIntervalsNested(index, item);
  }
  
  public MuteTimeIntervalsNested<A> editMuteTimeInterval(int index) {
    if (muteTimeIntervals.size() <= index) throw new RuntimeException("Can't edit muteTimeIntervals. Index exceeds size.");
    return setNewMuteTimeIntervalLike(index, buildMuteTimeInterval(index));
  }
  
  public MuteTimeIntervalsNested<A> editFirstMuteTimeInterval() {
    if (muteTimeIntervals.size() == 0) throw new RuntimeException("Can't edit first muteTimeIntervals. The list is empty.");
    return setNewMuteTimeIntervalLike(0, buildMuteTimeInterval(0));
  }
  
  public MuteTimeIntervalsNested<A> editLastMuteTimeInterval() {
    int index = muteTimeIntervals.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last muteTimeIntervals. The list is empty.");
    return setNewMuteTimeIntervalLike(index, buildMuteTimeInterval(index));
  }
  
  public MuteTimeIntervalsNested<A> editMatchingMuteTimeInterval(Predicate<MuteTimeIntervalBuilder> predicate) {
    int index = -1;
    for (int i=0;i<muteTimeIntervals.size();i++) { 
    if (predicate.test(muteTimeIntervals.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching muteTimeIntervals. No match found.");
    return setNewMuteTimeIntervalLike(index, buildMuteTimeInterval(index));
  }
  
  public A addToReceivers(int index,Receiver item) {
    if (this.receivers == null) {this.receivers = new ArrayList<ReceiverBuilder>();}
    ReceiverBuilder builder = new ReceiverBuilder(item);
    if (index < 0 || index >= receivers.size()) {
        _visitables.get("receivers").add(builder);
        receivers.add(builder);
    } else {
        _visitables.get("receivers").add(builder);
        receivers.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToReceivers(int index,Receiver item) {
    if (this.receivers == null) {this.receivers = new ArrayList<ReceiverBuilder>();}
    ReceiverBuilder builder = new ReceiverBuilder(item);
    if (index < 0 || index >= receivers.size()) {
        _visitables.get("receivers").add(builder);
        receivers.add(builder);
    } else {
        _visitables.get("receivers").add(builder);
        receivers.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToReceivers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Receiver... items) {
    if (this.receivers == null) {this.receivers = new ArrayList<ReceiverBuilder>();}
    for (Receiver item : items) {ReceiverBuilder builder = new ReceiverBuilder(item);_visitables.get("receivers").add(builder);this.receivers.add(builder);} return (A)this;
  }
  
  public A addAllToReceivers(Collection<Receiver> items) {
    if (this.receivers == null) {this.receivers = new ArrayList<ReceiverBuilder>();}
    for (Receiver item : items) {ReceiverBuilder builder = new ReceiverBuilder(item);_visitables.get("receivers").add(builder);this.receivers.add(builder);} return (A)this;
  }
  
  public A removeFromReceivers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Receiver... items) {
    if (this.receivers == null) return (A)this;
    for (Receiver item : items) {ReceiverBuilder builder = new ReceiverBuilder(item);_visitables.get("receivers").remove(builder); this.receivers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromReceivers(Collection<Receiver> items) {
    if (this.receivers == null) return (A)this;
    for (Receiver item : items) {ReceiverBuilder builder = new ReceiverBuilder(item);_visitables.get("receivers").remove(builder); this.receivers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromReceivers(Predicate<ReceiverBuilder> predicate) {
    if (receivers == null) return (A) this;
    final Iterator<ReceiverBuilder> each = receivers.iterator();
    final List visitables = _visitables.get("receivers");
    while (each.hasNext()) {
      ReceiverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Receiver> buildReceivers() {
    return this.receivers != null ? build(receivers) : null;
  }
  
  public Receiver buildReceiver(int index) {
    return this.receivers.get(index).build();
  }
  
  public Receiver buildFirstReceiver() {
    return this.receivers.get(0).build();
  }
  
  public Receiver buildLastReceiver() {
    return this.receivers.get(receivers.size() - 1).build();
  }
  
  public Receiver buildMatchingReceiver(Predicate<ReceiverBuilder> predicate) {
      for (ReceiverBuilder item : receivers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingReceiver(Predicate<ReceiverBuilder> predicate) {
      for (ReceiverBuilder item : receivers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withReceivers(List<Receiver> receivers) {
    if (this.receivers != null) {
      this._visitables.get("receivers").clear();
    }
    if (receivers != null) {
        this.receivers = new ArrayList();
        for (Receiver item : receivers) {
          this.addToReceivers(item);
        }
    } else {
      this.receivers = null;
    }
    return (A) this;
  }
  
  public A withReceivers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Receiver... receivers) {
    if (this.receivers != null) {
        this.receivers.clear();
        _visitables.remove("receivers");
    }
    if (receivers != null) {
      for (Receiver item : receivers) {
        this.addToReceivers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasReceivers() {
    return this.receivers != null && !this.receivers.isEmpty();
  }
  
  public ReceiversNested<A> addNewReceiver() {
    return new ReceiversNested(-1, null);
  }
  
  public ReceiversNested<A> addNewReceiverLike(Receiver item) {
    return new ReceiversNested(-1, item);
  }
  
  public ReceiversNested<A> setNewReceiverLike(int index,Receiver item) {
    return new ReceiversNested(index, item);
  }
  
  public ReceiversNested<A> editReceiver(int index) {
    if (receivers.size() <= index) throw new RuntimeException("Can't edit receivers. Index exceeds size.");
    return setNewReceiverLike(index, buildReceiver(index));
  }
  
  public ReceiversNested<A> editFirstReceiver() {
    if (receivers.size() == 0) throw new RuntimeException("Can't edit first receivers. The list is empty.");
    return setNewReceiverLike(0, buildReceiver(0));
  }
  
  public ReceiversNested<A> editLastReceiver() {
    int index = receivers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last receivers. The list is empty.");
    return setNewReceiverLike(index, buildReceiver(index));
  }
  
  public ReceiversNested<A> editMatchingReceiver(Predicate<ReceiverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<receivers.size();i++) { 
    if (predicate.test(receivers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching receivers. No match found.");
    return setNewReceiverLike(index, buildReceiver(index));
  }
  
  public Route buildRoute() {
    return this.route != null ? this.route.build() : null;
  }
  
  public A withRoute(Route route) {
    this._visitables.remove("route");
    if (route != null) {
        this.route = new RouteBuilder(route);
        this._visitables.get("route").add(this.route);
    } else {
        this.route = null;
        this._visitables.get("route").remove(this.route);
    }
    return (A) this;
  }
  
  public boolean hasRoute() {
    return this.route != null;
  }
  
  public RouteNested<A> withNewRoute() {
    return new RouteNested(null);
  }
  
  public RouteNested<A> withNewRouteLike(Route item) {
    return new RouteNested(item);
  }
  
  public RouteNested<A> editRoute() {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(null));
  }
  
  public RouteNested<A> editOrNewRoute() {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(new RouteBuilder().build()));
  }
  
  public RouteNested<A> editOrNewRouteLike(Route item) {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlertmanagerConfigSpecFluent that = (AlertmanagerConfigSpecFluent) o;
    if (!java.util.Objects.equals(inhibitRules, that.inhibitRules)) return false;
    if (!java.util.Objects.equals(muteTimeIntervals, that.muteTimeIntervals)) return false;
    if (!java.util.Objects.equals(receivers, that.receivers)) return false;
    if (!java.util.Objects.equals(route, that.route)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(inhibitRules,  muteTimeIntervals,  receivers,  route,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (inhibitRules != null && !inhibitRules.isEmpty()) { sb.append("inhibitRules:"); sb.append(inhibitRules + ","); }
    if (muteTimeIntervals != null && !muteTimeIntervals.isEmpty()) { sb.append("muteTimeIntervals:"); sb.append(muteTimeIntervals + ","); }
    if (receivers != null && !receivers.isEmpty()) { sb.append("receivers:"); sb.append(receivers + ","); }
    if (route != null) { sb.append("route:"); sb.append(route + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class InhibitRulesNested<N> extends InhibitRuleFluent<InhibitRulesNested<N>> implements Nested<N>{
    InhibitRulesNested(int index,InhibitRule item) {
      this.index = index;
      this.builder = new InhibitRuleBuilder(this, item);
    }
    InhibitRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertmanagerConfigSpecFluent.this.setToInhibitRules(index,builder.build());
    }
    
    public N endInhibitRule() {
      return and();
    }
    
  
  }
  public class MuteTimeIntervalsNested<N> extends MuteTimeIntervalFluent<MuteTimeIntervalsNested<N>> implements Nested<N>{
    MuteTimeIntervalsNested(int index,MuteTimeInterval item) {
      this.index = index;
      this.builder = new MuteTimeIntervalBuilder(this, item);
    }
    MuteTimeIntervalBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertmanagerConfigSpecFluent.this.setToMuteTimeIntervals(index,builder.build());
    }
    
    public N endMuteTimeInterval() {
      return and();
    }
    
  
  }
  public class ReceiversNested<N> extends ReceiverFluent<ReceiversNested<N>> implements Nested<N>{
    ReceiversNested(int index,Receiver item) {
      this.index = index;
      this.builder = new ReceiverBuilder(this, item);
    }
    ReceiverBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertmanagerConfigSpecFluent.this.setToReceivers(index,builder.build());
    }
    
    public N endReceiver() {
      return and();
    }
    
  
  }
  public class RouteNested<N> extends RouteFluent<RouteNested<N>> implements Nested<N>{
    RouteNested(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteBuilder builder;
    
    public N and() {
      return (N) AlertmanagerConfigSpecFluent.this.withRoute(builder.build());
    }
    
    public N endRoute() {
      return and();
    }
    
  
  }

}