package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TimeIntervalFluent<A extends TimeIntervalFluent<A>> extends BaseFluent<A>{
  public TimeIntervalFluent() {
  }
  
  public TimeIntervalFluent(TimeInterval instance) {
    this.copyInstance(instance);
  }
  private ArrayList<DayOfMonthRangeBuilder> daysOfMonth = new ArrayList<DayOfMonthRangeBuilder>();
  private List<String> months = new ArrayList<String>();
  private ArrayList<TimeRangeBuilder> times = new ArrayList<TimeRangeBuilder>();
  private List<String> weekdays = new ArrayList<String>();
  private List<String> years = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TimeInterval instance) {
    instance = (instance != null ? instance : new TimeInterval());
    if (instance != null) {
          this.withDaysOfMonth(instance.getDaysOfMonth());
          this.withMonths(instance.getMonths());
          this.withTimes(instance.getTimes());
          this.withWeekdays(instance.getWeekdays());
          this.withYears(instance.getYears());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToDaysOfMonth(int index,DayOfMonthRange item) {
    if (this.daysOfMonth == null) {this.daysOfMonth = new ArrayList<DayOfMonthRangeBuilder>();}
    DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);
    if (index < 0 || index >= daysOfMonth.size()) {
        _visitables.get("daysOfMonth").add(builder);
        daysOfMonth.add(builder);
    } else {
        _visitables.get("daysOfMonth").add(builder);
        daysOfMonth.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToDaysOfMonth(int index,DayOfMonthRange item) {
    if (this.daysOfMonth == null) {this.daysOfMonth = new ArrayList<DayOfMonthRangeBuilder>();}
    DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);
    if (index < 0 || index >= daysOfMonth.size()) {
        _visitables.get("daysOfMonth").add(builder);
        daysOfMonth.add(builder);
    } else {
        _visitables.get("daysOfMonth").add(builder);
        daysOfMonth.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToDaysOfMonth(io.fabric8.openshift.api.model.monitoring.v1alpha1.DayOfMonthRange... items) {
    if (this.daysOfMonth == null) {this.daysOfMonth = new ArrayList<DayOfMonthRangeBuilder>();}
    for (DayOfMonthRange item : items) {DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);_visitables.get("daysOfMonth").add(builder);this.daysOfMonth.add(builder);} return (A)this;
  }
  
  public A addAllToDaysOfMonth(Collection<DayOfMonthRange> items) {
    if (this.daysOfMonth == null) {this.daysOfMonth = new ArrayList<DayOfMonthRangeBuilder>();}
    for (DayOfMonthRange item : items) {DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);_visitables.get("daysOfMonth").add(builder);this.daysOfMonth.add(builder);} return (A)this;
  }
  
  public A removeFromDaysOfMonth(io.fabric8.openshift.api.model.monitoring.v1alpha1.DayOfMonthRange... items) {
    if (this.daysOfMonth == null) return (A)this;
    for (DayOfMonthRange item : items) {DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);_visitables.get("daysOfMonth").remove(builder); this.daysOfMonth.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDaysOfMonth(Collection<DayOfMonthRange> items) {
    if (this.daysOfMonth == null) return (A)this;
    for (DayOfMonthRange item : items) {DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);_visitables.get("daysOfMonth").remove(builder); this.daysOfMonth.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDaysOfMonth(Predicate<DayOfMonthRangeBuilder> predicate) {
    if (daysOfMonth == null) return (A) this;
    final Iterator<DayOfMonthRangeBuilder> each = daysOfMonth.iterator();
    final List visitables = _visitables.get("daysOfMonth");
    while (each.hasNext()) {
      DayOfMonthRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DayOfMonthRange> buildDaysOfMonth() {
    return this.daysOfMonth != null ? build(daysOfMonth) : null;
  }
  
  public DayOfMonthRange buildDaysOfMonth(int index) {
    return this.daysOfMonth.get(index).build();
  }
  
  public DayOfMonthRange buildFirstDaysOfMonth() {
    return this.daysOfMonth.get(0).build();
  }
  
  public DayOfMonthRange buildLastDaysOfMonth() {
    return this.daysOfMonth.get(daysOfMonth.size() - 1).build();
  }
  
  public DayOfMonthRange buildMatchingDaysOfMonth(Predicate<DayOfMonthRangeBuilder> predicate) {
      for (DayOfMonthRangeBuilder item : daysOfMonth) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDaysOfMonth(Predicate<DayOfMonthRangeBuilder> predicate) {
      for (DayOfMonthRangeBuilder item : daysOfMonth) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDaysOfMonth(List<DayOfMonthRange> daysOfMonth) {
    if (this.daysOfMonth != null) {
      this._visitables.get("daysOfMonth").clear();
    }
    if (daysOfMonth != null) {
        this.daysOfMonth = new ArrayList();
        for (DayOfMonthRange item : daysOfMonth) {
          this.addToDaysOfMonth(item);
        }
    } else {
      this.daysOfMonth = null;
    }
    return (A) this;
  }
  
  public A withDaysOfMonth(io.fabric8.openshift.api.model.monitoring.v1alpha1.DayOfMonthRange... daysOfMonth) {
    if (this.daysOfMonth != null) {
        this.daysOfMonth.clear();
        _visitables.remove("daysOfMonth");
    }
    if (daysOfMonth != null) {
      for (DayOfMonthRange item : daysOfMonth) {
        this.addToDaysOfMonth(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDaysOfMonth() {
    return this.daysOfMonth != null && !this.daysOfMonth.isEmpty();
  }
  
  public A addNewDaysOfMonth(Integer end,Integer start) {
    return (A)addToDaysOfMonth(new DayOfMonthRange(end, start));
  }
  
  public DaysOfMonthNested<A> addNewDaysOfMonth() {
    return new DaysOfMonthNested(-1, null);
  }
  
  public DaysOfMonthNested<A> addNewDaysOfMonthLike(DayOfMonthRange item) {
    return new DaysOfMonthNested(-1, item);
  }
  
  public DaysOfMonthNested<A> setNewDaysOfMonthLike(int index,DayOfMonthRange item) {
    return new DaysOfMonthNested(index, item);
  }
  
  public DaysOfMonthNested<A> editDaysOfMonth(int index) {
    if (daysOfMonth.size() <= index) throw new RuntimeException("Can't edit daysOfMonth. Index exceeds size.");
    return setNewDaysOfMonthLike(index, buildDaysOfMonth(index));
  }
  
  public DaysOfMonthNested<A> editFirstDaysOfMonth() {
    if (daysOfMonth.size() == 0) throw new RuntimeException("Can't edit first daysOfMonth. The list is empty.");
    return setNewDaysOfMonthLike(0, buildDaysOfMonth(0));
  }
  
  public DaysOfMonthNested<A> editLastDaysOfMonth() {
    int index = daysOfMonth.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last daysOfMonth. The list is empty.");
    return setNewDaysOfMonthLike(index, buildDaysOfMonth(index));
  }
  
  public DaysOfMonthNested<A> editMatchingDaysOfMonth(Predicate<DayOfMonthRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<daysOfMonth.size();i++) { 
    if (predicate.test(daysOfMonth.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching daysOfMonth. No match found.");
    return setNewDaysOfMonthLike(index, buildDaysOfMonth(index));
  }
  
  public A addToMonths(int index,String item) {
    if (this.months == null) {this.months = new ArrayList<String>();}
    this.months.add(index, item);
    return (A)this;
  }
  
  public A setToMonths(int index,String item) {
    if (this.months == null) {this.months = new ArrayList<String>();}
    this.months.set(index, item); return (A)this;
  }
  
  public A addToMonths(java.lang.String... items) {
    if (this.months == null) {this.months = new ArrayList<String>();}
    for (String item : items) {this.months.add(item);} return (A)this;
  }
  
  public A addAllToMonths(Collection<String> items) {
    if (this.months == null) {this.months = new ArrayList<String>();}
    for (String item : items) {this.months.add(item);} return (A)this;
  }
  
  public A removeFromMonths(java.lang.String... items) {
    if (this.months == null) return (A)this;
    for (String item : items) { this.months.remove(item);} return (A)this;
  }
  
  public A removeAllFromMonths(Collection<String> items) {
    if (this.months == null) return (A)this;
    for (String item : items) { this.months.remove(item);} return (A)this;
  }
  
  public List<String> getMonths() {
    return this.months;
  }
  
  public String getMonth(int index) {
    return this.months.get(index);
  }
  
  public String getFirstMonth() {
    return this.months.get(0);
  }
  
  public String getLastMonth() {
    return this.months.get(months.size() - 1);
  }
  
  public String getMatchingMonth(Predicate<String> predicate) {
      for (String item : months) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMonth(Predicate<String> predicate) {
      for (String item : months) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMonths(List<String> months) {
    if (months != null) {
        this.months = new ArrayList();
        for (String item : months) {
          this.addToMonths(item);
        }
    } else {
      this.months = null;
    }
    return (A) this;
  }
  
  public A withMonths(java.lang.String... months) {
    if (this.months != null) {
        this.months.clear();
        _visitables.remove("months");
    }
    if (months != null) {
      for (String item : months) {
        this.addToMonths(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMonths() {
    return this.months != null && !this.months.isEmpty();
  }
  
  public A addToTimes(int index,TimeRange item) {
    if (this.times == null) {this.times = new ArrayList<TimeRangeBuilder>();}
    TimeRangeBuilder builder = new TimeRangeBuilder(item);
    if (index < 0 || index >= times.size()) {
        _visitables.get("times").add(builder);
        times.add(builder);
    } else {
        _visitables.get("times").add(builder);
        times.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToTimes(int index,TimeRange item) {
    if (this.times == null) {this.times = new ArrayList<TimeRangeBuilder>();}
    TimeRangeBuilder builder = new TimeRangeBuilder(item);
    if (index < 0 || index >= times.size()) {
        _visitables.get("times").add(builder);
        times.add(builder);
    } else {
        _visitables.get("times").add(builder);
        times.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToTimes(io.fabric8.openshift.api.model.monitoring.v1alpha1.TimeRange... items) {
    if (this.times == null) {this.times = new ArrayList<TimeRangeBuilder>();}
    for (TimeRange item : items) {TimeRangeBuilder builder = new TimeRangeBuilder(item);_visitables.get("times").add(builder);this.times.add(builder);} return (A)this;
  }
  
  public A addAllToTimes(Collection<TimeRange> items) {
    if (this.times == null) {this.times = new ArrayList<TimeRangeBuilder>();}
    for (TimeRange item : items) {TimeRangeBuilder builder = new TimeRangeBuilder(item);_visitables.get("times").add(builder);this.times.add(builder);} return (A)this;
  }
  
  public A removeFromTimes(io.fabric8.openshift.api.model.monitoring.v1alpha1.TimeRange... items) {
    if (this.times == null) return (A)this;
    for (TimeRange item : items) {TimeRangeBuilder builder = new TimeRangeBuilder(item);_visitables.get("times").remove(builder); this.times.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTimes(Collection<TimeRange> items) {
    if (this.times == null) return (A)this;
    for (TimeRange item : items) {TimeRangeBuilder builder = new TimeRangeBuilder(item);_visitables.get("times").remove(builder); this.times.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTimes(Predicate<TimeRangeBuilder> predicate) {
    if (times == null) return (A) this;
    final Iterator<TimeRangeBuilder> each = times.iterator();
    final List visitables = _visitables.get("times");
    while (each.hasNext()) {
      TimeRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TimeRange> buildTimes() {
    return this.times != null ? build(times) : null;
  }
  
  public TimeRange buildTime(int index) {
    return this.times.get(index).build();
  }
  
  public TimeRange buildFirstTime() {
    return this.times.get(0).build();
  }
  
  public TimeRange buildLastTime() {
    return this.times.get(times.size() - 1).build();
  }
  
  public TimeRange buildMatchingTime(Predicate<TimeRangeBuilder> predicate) {
      for (TimeRangeBuilder item : times) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTime(Predicate<TimeRangeBuilder> predicate) {
      for (TimeRangeBuilder item : times) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTimes(List<TimeRange> times) {
    if (this.times != null) {
      this._visitables.get("times").clear();
    }
    if (times != null) {
        this.times = new ArrayList();
        for (TimeRange item : times) {
          this.addToTimes(item);
        }
    } else {
      this.times = null;
    }
    return (A) this;
  }
  
  public A withTimes(io.fabric8.openshift.api.model.monitoring.v1alpha1.TimeRange... times) {
    if (this.times != null) {
        this.times.clear();
        _visitables.remove("times");
    }
    if (times != null) {
      for (TimeRange item : times) {
        this.addToTimes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTimes() {
    return this.times != null && !this.times.isEmpty();
  }
  
  public A addNewTime(String endTime,String startTime) {
    return (A)addToTimes(new TimeRange(endTime, startTime));
  }
  
  public TimesNested<A> addNewTime() {
    return new TimesNested(-1, null);
  }
  
  public TimesNested<A> addNewTimeLike(TimeRange item) {
    return new TimesNested(-1, item);
  }
  
  public TimesNested<A> setNewTimeLike(int index,TimeRange item) {
    return new TimesNested(index, item);
  }
  
  public TimesNested<A> editTime(int index) {
    if (times.size() <= index) throw new RuntimeException("Can't edit times. Index exceeds size.");
    return setNewTimeLike(index, buildTime(index));
  }
  
  public TimesNested<A> editFirstTime() {
    if (times.size() == 0) throw new RuntimeException("Can't edit first times. The list is empty.");
    return setNewTimeLike(0, buildTime(0));
  }
  
  public TimesNested<A> editLastTime() {
    int index = times.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last times. The list is empty.");
    return setNewTimeLike(index, buildTime(index));
  }
  
  public TimesNested<A> editMatchingTime(Predicate<TimeRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<times.size();i++) { 
    if (predicate.test(times.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching times. No match found.");
    return setNewTimeLike(index, buildTime(index));
  }
  
  public A addToWeekdays(int index,String item) {
    if (this.weekdays == null) {this.weekdays = new ArrayList<String>();}
    this.weekdays.add(index, item);
    return (A)this;
  }
  
  public A setToWeekdays(int index,String item) {
    if (this.weekdays == null) {this.weekdays = new ArrayList<String>();}
    this.weekdays.set(index, item); return (A)this;
  }
  
  public A addToWeekdays(java.lang.String... items) {
    if (this.weekdays == null) {this.weekdays = new ArrayList<String>();}
    for (String item : items) {this.weekdays.add(item);} return (A)this;
  }
  
  public A addAllToWeekdays(Collection<String> items) {
    if (this.weekdays == null) {this.weekdays = new ArrayList<String>();}
    for (String item : items) {this.weekdays.add(item);} return (A)this;
  }
  
  public A removeFromWeekdays(java.lang.String... items) {
    if (this.weekdays == null) return (A)this;
    for (String item : items) { this.weekdays.remove(item);} return (A)this;
  }
  
  public A removeAllFromWeekdays(Collection<String> items) {
    if (this.weekdays == null) return (A)this;
    for (String item : items) { this.weekdays.remove(item);} return (A)this;
  }
  
  public List<String> getWeekdays() {
    return this.weekdays;
  }
  
  public String getWeekday(int index) {
    return this.weekdays.get(index);
  }
  
  public String getFirstWeekday() {
    return this.weekdays.get(0);
  }
  
  public String getLastWeekday() {
    return this.weekdays.get(weekdays.size() - 1);
  }
  
  public String getMatchingWeekday(Predicate<String> predicate) {
      for (String item : weekdays) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingWeekday(Predicate<String> predicate) {
      for (String item : weekdays) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWeekdays(List<String> weekdays) {
    if (weekdays != null) {
        this.weekdays = new ArrayList();
        for (String item : weekdays) {
          this.addToWeekdays(item);
        }
    } else {
      this.weekdays = null;
    }
    return (A) this;
  }
  
  public A withWeekdays(java.lang.String... weekdays) {
    if (this.weekdays != null) {
        this.weekdays.clear();
        _visitables.remove("weekdays");
    }
    if (weekdays != null) {
      for (String item : weekdays) {
        this.addToWeekdays(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWeekdays() {
    return this.weekdays != null && !this.weekdays.isEmpty();
  }
  
  public A addToYears(int index,String item) {
    if (this.years == null) {this.years = new ArrayList<String>();}
    this.years.add(index, item);
    return (A)this;
  }
  
  public A setToYears(int index,String item) {
    if (this.years == null) {this.years = new ArrayList<String>();}
    this.years.set(index, item); return (A)this;
  }
  
  public A addToYears(java.lang.String... items) {
    if (this.years == null) {this.years = new ArrayList<String>();}
    for (String item : items) {this.years.add(item);} return (A)this;
  }
  
  public A addAllToYears(Collection<String> items) {
    if (this.years == null) {this.years = new ArrayList<String>();}
    for (String item : items) {this.years.add(item);} return (A)this;
  }
  
  public A removeFromYears(java.lang.String... items) {
    if (this.years == null) return (A)this;
    for (String item : items) { this.years.remove(item);} return (A)this;
  }
  
  public A removeAllFromYears(Collection<String> items) {
    if (this.years == null) return (A)this;
    for (String item : items) { this.years.remove(item);} return (A)this;
  }
  
  public List<String> getYears() {
    return this.years;
  }
  
  public String getYear(int index) {
    return this.years.get(index);
  }
  
  public String getFirstYear() {
    return this.years.get(0);
  }
  
  public String getLastYear() {
    return this.years.get(years.size() - 1);
  }
  
  public String getMatchingYear(Predicate<String> predicate) {
      for (String item : years) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingYear(Predicate<String> predicate) {
      for (String item : years) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withYears(List<String> years) {
    if (years != null) {
        this.years = new ArrayList();
        for (String item : years) {
          this.addToYears(item);
        }
    } else {
      this.years = null;
    }
    return (A) this;
  }
  
  public A withYears(java.lang.String... years) {
    if (this.years != null) {
        this.years.clear();
        _visitables.remove("years");
    }
    if (years != null) {
      for (String item : years) {
        this.addToYears(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasYears() {
    return this.years != null && !this.years.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TimeIntervalFluent that = (TimeIntervalFluent) o;
    if (!java.util.Objects.equals(daysOfMonth, that.daysOfMonth)) return false;
    if (!java.util.Objects.equals(months, that.months)) return false;
    if (!java.util.Objects.equals(times, that.times)) return false;
    if (!java.util.Objects.equals(weekdays, that.weekdays)) return false;
    if (!java.util.Objects.equals(years, that.years)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(daysOfMonth,  months,  times,  weekdays,  years,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (daysOfMonth != null && !daysOfMonth.isEmpty()) { sb.append("daysOfMonth:"); sb.append(daysOfMonth + ","); }
    if (months != null && !months.isEmpty()) { sb.append("months:"); sb.append(months + ","); }
    if (times != null && !times.isEmpty()) { sb.append("times:"); sb.append(times + ","); }
    if (weekdays != null && !weekdays.isEmpty()) { sb.append("weekdays:"); sb.append(weekdays + ","); }
    if (years != null && !years.isEmpty()) { sb.append("years:"); sb.append(years + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DaysOfMonthNested<N> extends DayOfMonthRangeFluent<DaysOfMonthNested<N>> implements Nested<N>{
    DaysOfMonthNested(int index,DayOfMonthRange item) {
      this.index = index;
      this.builder = new DayOfMonthRangeBuilder(this, item);
    }
    DayOfMonthRangeBuilder builder;
    int index;
    
    public N and() {
      return (N) TimeIntervalFluent.this.setToDaysOfMonth(index,builder.build());
    }
    
    public N endDaysOfMonth() {
      return and();
    }
    
  
  }
  public class TimesNested<N> extends TimeRangeFluent<TimesNested<N>> implements Nested<N>{
    TimesNested(int index,TimeRange item) {
      this.index = index;
      this.builder = new TimeRangeBuilder(this, item);
    }
    TimeRangeBuilder builder;
    int index;
    
    public N and() {
      return (N) TimeIntervalFluent.this.setToTimes(index,builder.build());
    }
    
    public N endTime() {
      return and();
    }
    
  
  }

}