package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WeChatConfigBuilder extends WeChatConfigFluent<WeChatConfigBuilder> implements VisitableBuilder<WeChatConfig,WeChatConfigBuilder>{
  public WeChatConfigBuilder() {
    this(new WeChatConfig());
  }
  
  public WeChatConfigBuilder(WeChatConfigFluent<?> fluent) {
    this(fluent, new WeChatConfig());
  }
  
  public WeChatConfigBuilder(WeChatConfigFluent<?> fluent,WeChatConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WeChatConfigBuilder(WeChatConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WeChatConfigFluent<?> fluent;
  
  public WeChatConfig build() {
    WeChatConfig buildable = new WeChatConfig(fluent.getAgentID(),fluent.buildApiSecret(),fluent.getApiURL(),fluent.getCorpID(),fluent.buildHttpConfig(),fluent.getMessage(),fluent.getMessageType(),fluent.getSendResolved(),fluent.getToParty(),fluent.getToTag(),fluent.getToUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}