package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.openshift.api.model.SecretNameReferenceBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.openshift.api.model.SecretNameReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleConfigRouteFluentImpl<A extends ConsoleConfigRouteFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConsoleConfigRouteFluent<A> {

    private String hostname;
    private SecretNameReferenceBuilder secret;

    public ConsoleConfigRouteFluentImpl() { 
    }


    public ConsoleConfigRouteFluentImpl(ConsoleConfigRoute instance) { 
        this.withHostname(instance.getHostname()); 
        this.withSecret(instance.getSecret()); 
    }


    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname() {
        return this.hostname != null;
    }

    public A withNewHostname(String arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuilder arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuffer arg1) {
        return (A)withHostname(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecret instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getSecret() {
        return this.secret!=null?this.secret.build():null;
    }

    public SecretNameReference buildSecret() {
        return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(SecretNameReference secret) {
        _visitables.get("secret").remove(this.secret);
        if (secret!=null){ this.secret= new SecretNameReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
    }

    public Boolean hasSecret() {
        return this.secret != null;
    }

    public A withNewSecret(String name) {
        return (A)withSecret(new SecretNameReference(name));
    }

    public ConsoleConfigRouteFluent.SecretNested<A> withNewSecret() {
        return new SecretNestedImpl();
    }

    public ConsoleConfigRouteFluent.SecretNested<A> withNewSecretLike(SecretNameReference item) {
        return new SecretNestedImpl(item);
    }

    public ConsoleConfigRouteFluent.SecretNested<A> editSecret() {
        return withNewSecretLike(getSecret());
    }

    public ConsoleConfigRouteFluent.SecretNested<A> editOrNewSecret() {
        return withNewSecretLike(getSecret() != null ? getSecret(): new SecretNameReferenceBuilder().build());
    }

    public ConsoleConfigRouteFluent.SecretNested<A> editOrNewSecretLike(SecretNameReference item) {
        return withNewSecretLike(getSecret() != null ? getSecret(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsoleConfigRouteFluentImpl that = (ConsoleConfigRouteFluentImpl) o;
        if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
        if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(hostname,  secret,  super.hashCode());
    }

    public class SecretNestedImpl<N> extends SecretNameReferenceFluentImpl<ConsoleConfigRouteFluent.SecretNested<N>> implements ConsoleConfigRouteFluent.SecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

        SecretNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        SecretNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        public N and() {
             return (N) ConsoleConfigRouteFluentImpl.this.withSecret(builder.build());
        }

        public N endSecret() {
             return and();
        }
    }


}
