package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerHTTPHeadersBuilder extends IngressControllerHTTPHeadersFluentImpl<IngressControllerHTTPHeadersBuilder> implements VisitableBuilder<IngressControllerHTTPHeaders,IngressControllerHTTPHeadersBuilder> {

    IngressControllerHTTPHeadersFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerHTTPHeadersBuilder() { 
        this(true);
    }


    public IngressControllerHTTPHeadersBuilder(Boolean validationEnabled) { 
        this(new IngressControllerHTTPHeaders(), validationEnabled);
    }


    public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeadersFluent<?> fluent) { 
        this(fluent, true);
    }


    public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeadersFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new IngressControllerHTTPHeaders(), validationEnabled);
    }


    public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeadersFluent<?> fluent,IngressControllerHTTPHeaders instance) { 
        this(fluent, instance, true);
    }


    public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeadersFluent<?> fluent,IngressControllerHTTPHeaders instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy()); 
        fluent.withUniqueId(instance.getUniqueId()); 
        this.validationEnabled = validationEnabled; 
    }


    public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeaders instance) { 
        this(instance,true);
    }


    public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeaders instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy()); 
        this.withUniqueId(instance.getUniqueId()); 
        this.validationEnabled = validationEnabled; 
    }


    public IngressControllerHTTPHeaders build() {
        IngressControllerHTTPHeaders buildable = new IngressControllerHTTPHeaders(fluent.getForwardedHeaderPolicy(),fluent.getUniqueId());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressControllerHTTPHeadersBuilder that = (IngressControllerHTTPHeadersBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
