package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeControllerManagerBuilder extends KubeControllerManagerFluentImpl<KubeControllerManagerBuilder> implements VisitableBuilder<KubeControllerManager,KubeControllerManagerBuilder> {

    KubeControllerManagerFluent<?> fluent;
    Boolean validationEnabled;

    public KubeControllerManagerBuilder() { 
        this(true);
    }


    public KubeControllerManagerBuilder(Boolean validationEnabled) { 
        this(new KubeControllerManager(), validationEnabled);
    }


    public KubeControllerManagerBuilder(KubeControllerManagerFluent<?> fluent) { 
        this(fluent, true);
    }


    public KubeControllerManagerBuilder(KubeControllerManagerFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KubeControllerManager(), validationEnabled);
    }


    public KubeControllerManagerBuilder(KubeControllerManagerFluent<?> fluent,KubeControllerManager instance) { 
        this(fluent, instance, true);
    }


    public KubeControllerManagerBuilder(KubeControllerManagerFluent<?> fluent,KubeControllerManager instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeControllerManagerBuilder(KubeControllerManager instance) { 
        this(instance,true);
    }


    public KubeControllerManagerBuilder(KubeControllerManager instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeControllerManager build() {
        KubeControllerManager buildable = new KubeControllerManager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeControllerManagerBuilder that = (KubeControllerManagerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
