package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KubeSchedulerListFluent<A extends KubeSchedulerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,KubeScheduler item);
    public A setToItems(int index,KubeScheduler item);
    public A addToItems(KubeScheduler... items);
    public A addAllToItems(Collection<KubeScheduler> items);
    public A removeFromItems(KubeScheduler... items);
    public A removeAllFromItems(Collection<KubeScheduler> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<KubeSchedulerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KubeScheduler> getItems();
    public List<KubeScheduler> buildItems();
    public KubeScheduler buildItem(int index);
    public KubeScheduler buildFirstItem();
    public KubeScheduler buildLastItem();
    public KubeScheduler buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubeSchedulerBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubeSchedulerBuilder> predicate);
    public A withItems(List<KubeScheduler> items);
    public A withItems(KubeScheduler... items);
    public Boolean hasItems();
    public KubeSchedulerListFluent.ItemsNested<A> addNewItem();
    public KubeSchedulerListFluent.ItemsNested<A> addNewItemLike(KubeScheduler item);
    public KubeSchedulerListFluent.ItemsNested<A> setNewItemLike(int index,KubeScheduler item);
    public KubeSchedulerListFluent.ItemsNested<A> editItem(int index);
    public KubeSchedulerListFluent.ItemsNested<A> editFirstItem();
    public KubeSchedulerListFluent.ItemsNested<A> editLastItem();
    public KubeSchedulerListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubeSchedulerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<KubeSchedulerListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
