package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogAPIServerListBuilder extends ServiceCatalogAPIServerListFluentImpl<ServiceCatalogAPIServerListBuilder> implements VisitableBuilder<ServiceCatalogAPIServerList,ServiceCatalogAPIServerListBuilder> {

    ServiceCatalogAPIServerListFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogAPIServerListBuilder() { 
        this(true);
    }


    public ServiceCatalogAPIServerListBuilder(Boolean validationEnabled) { 
        this(new ServiceCatalogAPIServerList(), validationEnabled);
    }


    public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerListFluent<?> fluent) { 
        this(fluent, true);
    }


    public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ServiceCatalogAPIServerList(), validationEnabled);
    }


    public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerListFluent<?> fluent,ServiceCatalogAPIServerList instance) { 
        this(fluent, instance, true);
    }


    public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerListFluent<?> fluent,ServiceCatalogAPIServerList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerList instance) { 
        this(instance,true);
    }


    public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCatalogAPIServerList build() {
        ServiceCatalogAPIServerList buildable = new ServiceCatalogAPIServerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCatalogAPIServerListBuilder that = (ServiceCatalogAPIServerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
