package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DefaultNetworkDefinitionBuilder extends DefaultNetworkDefinitionFluentImpl<DefaultNetworkDefinitionBuilder> implements VisitableBuilder<DefaultNetworkDefinition,DefaultNetworkDefinitionBuilder> {

    DefaultNetworkDefinitionFluent<?> fluent;
    Boolean validationEnabled;

    public DefaultNetworkDefinitionBuilder() { 
        this(true);
    }


    public DefaultNetworkDefinitionBuilder(Boolean validationEnabled) { 
        this(new DefaultNetworkDefinition(), validationEnabled);
    }


    public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent) { 
        this(fluent, true);
    }


    public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new DefaultNetworkDefinition(), validationEnabled);
    }


    public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent,DefaultNetworkDefinition instance) { 
        this(fluent, instance, true);
    }


    public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent,DefaultNetworkDefinition instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withKuryrConfig(instance.getKuryrConfig()); 
        fluent.withOpenshiftSDNConfig(instance.getOpenshiftSDNConfig()); 
        fluent.withOvnKubernetesConfig(instance.getOvnKubernetesConfig()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinition instance) { 
        this(instance,true);
    }


    public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinition instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withKuryrConfig(instance.getKuryrConfig()); 
        this.withOpenshiftSDNConfig(instance.getOpenshiftSDNConfig()); 
        this.withOvnKubernetesConfig(instance.getOvnKubernetesConfig()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public DefaultNetworkDefinition build() {
        DefaultNetworkDefinition buildable = new DefaultNetworkDefinition(fluent.getKuryrConfig(),fluent.getOpenshiftSDNConfig(),fluent.getOvnKubernetesConfig(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DefaultNetworkDefinitionBuilder that = (DefaultNetworkDefinitionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
