
package io.fabric8.openshift.api.model.operator.v1;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "hostNetwork",
    "loadBalancer",
    "nodePort",
    "private",
    "type"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class EndpointPublishingStrategy implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("hostNetwork")
    private HostNetworkStrategy hostNetwork;
    /**
     * 
     * 
     */
    @JsonProperty("loadBalancer")
    private LoadBalancerStrategy loadBalancer;
    /**
     * 
     * 
     */
    @JsonProperty("nodePort")
    private NodePortStrategy nodePort;
    /**
     * 
     * 
     */
    @JsonProperty("private")
    private PrivateStrategy _private;
    /**
     * 
     * 
     */
    @JsonProperty("type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public EndpointPublishingStrategy() {
    }

    /**
     * 
     * @param _private
     * @param hostNetwork
     * @param loadBalancer
     * @param type
     * @param nodePort
     */
    public EndpointPublishingStrategy(HostNetworkStrategy hostNetwork, LoadBalancerStrategy loadBalancer, NodePortStrategy nodePort, PrivateStrategy _private, String type) {
        this.hostNetwork = hostNetwork;
        this.loadBalancer = loadBalancer;
        this.nodePort = nodePort;
        this._private = _private;
        this.type = type;
    }

    /**
     * 
     * 
     * @return
     *     The hostNetwork
     */
    @JsonProperty("hostNetwork")
    public HostNetworkStrategy getHostNetwork() {
        return hostNetwork;
    }

    /**
     * 
     * 
     * @param hostNetwork
     *     The hostNetwork
     */
    @JsonProperty("hostNetwork")
    public void setHostNetwork(HostNetworkStrategy hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    /**
     * 
     * 
     * @return
     *     The loadBalancer
     */
    @JsonProperty("loadBalancer")
    public LoadBalancerStrategy getLoadBalancer() {
        return loadBalancer;
    }

    /**
     * 
     * 
     * @param loadBalancer
     *     The loadBalancer
     */
    @JsonProperty("loadBalancer")
    public void setLoadBalancer(LoadBalancerStrategy loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    /**
     * 
     * 
     * @return
     *     The nodePort
     */
    @JsonProperty("nodePort")
    public NodePortStrategy getNodePort() {
        return nodePort;
    }

    /**
     * 
     * 
     * @param nodePort
     *     The nodePort
     */
    @JsonProperty("nodePort")
    public void setNodePort(NodePortStrategy nodePort) {
        this.nodePort = nodePort;
    }

    /**
     * 
     * 
     * @return
     *     The _private
     */
    @JsonProperty("private")
    public PrivateStrategy getPrivate() {
        return _private;
    }

    /**
     * 
     * 
     * @param _private
     *     The private
     */
    @JsonProperty("private")
    public void setPrivate(PrivateStrategy _private) {
        this._private = _private;
    }

    /**
     * 
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * 
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
