package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class IngressControllerCaptureHTTPCookieFluentImpl<A extends IngressControllerCaptureHTTPCookieFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressControllerCaptureHTTPCookieFluent<A> {

    private String matchType;
    private Integer maxLength;
    private String name;
    private String namePrefix;

    public IngressControllerCaptureHTTPCookieFluentImpl() { 
    }


    public IngressControllerCaptureHTTPCookieFluentImpl(IngressControllerCaptureHTTPCookie instance) { 
        this.withMatchType(instance.getMatchType()); 
        this.withMaxLength(instance.getMaxLength()); 
        this.withName(instance.getName()); 
        this.withNamePrefix(instance.getNamePrefix()); 
    }


    public String getMatchType() {
        return this.matchType;
    }

    public A withMatchType(String matchType) {
        this.matchType=matchType; return (A) this;
    }

    public Boolean hasMatchType() {
        return this.matchType != null;
    }

    public A withNewMatchType(String arg1) {
        return (A)withMatchType(new String(arg1));
    }

    public A withNewMatchType(StringBuilder arg1) {
        return (A)withMatchType(new String(arg1));
    }

    public A withNewMatchType(StringBuffer arg1) {
        return (A)withMatchType(new String(arg1));
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public A withMaxLength(Integer maxLength) {
        this.maxLength=maxLength; return (A) this;
    }

    public Boolean hasMaxLength() {
        return this.maxLength != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public A withNamePrefix(String namePrefix) {
        this.namePrefix=namePrefix; return (A) this;
    }

    public Boolean hasNamePrefix() {
        return this.namePrefix != null;
    }

    public A withNewNamePrefix(String arg1) {
        return (A)withNamePrefix(new String(arg1));
    }

    public A withNewNamePrefix(StringBuilder arg1) {
        return (A)withNamePrefix(new String(arg1));
    }

    public A withNewNamePrefix(StringBuffer arg1) {
        return (A)withNamePrefix(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressControllerCaptureHTTPCookieFluentImpl that = (IngressControllerCaptureHTTPCookieFluentImpl) o;
        if (matchType != null ? !matchType.equals(that.matchType) :that.matchType != null) return false;
        if (maxLength != null ? !maxLength.equals(that.maxLength) :that.maxLength != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namePrefix != null ? !namePrefix.equals(that.namePrefix) :that.namePrefix != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(matchType,  maxLength,  name,  namePrefix,  super.hashCode());
    }

}
