package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeAPIServerListBuilder extends KubeAPIServerListFluentImpl<KubeAPIServerListBuilder> implements VisitableBuilder<KubeAPIServerList,KubeAPIServerListBuilder> {

    KubeAPIServerListFluent<?> fluent;
    Boolean validationEnabled;

    public KubeAPIServerListBuilder() { 
        this(true);
    }


    public KubeAPIServerListBuilder(Boolean validationEnabled) { 
        this(new KubeAPIServerList(), validationEnabled);
    }


    public KubeAPIServerListBuilder(KubeAPIServerListFluent<?> fluent) { 
        this(fluent, true);
    }


    public KubeAPIServerListBuilder(KubeAPIServerListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KubeAPIServerList(), validationEnabled);
    }


    public KubeAPIServerListBuilder(KubeAPIServerListFluent<?> fluent,KubeAPIServerList instance) { 
        this(fluent, instance, true);
    }


    public KubeAPIServerListBuilder(KubeAPIServerListFluent<?> fluent,KubeAPIServerList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeAPIServerListBuilder(KubeAPIServerList instance) { 
        this(instance,true);
    }


    public KubeAPIServerListBuilder(KubeAPIServerList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeAPIServerList build() {
        KubeAPIServerList buildable = new KubeAPIServerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeAPIServerListBuilder that = (KubeAPIServerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
