
package io.fabric8.openshift.api.model.operator.v1;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "controllerProbesPort",
    "daemonProbesPort",
    "enablePortPoolsPrepopulation",
    "openStackServiceNetwork",
    "poolBatchPorts",
    "poolMaxPorts",
    "poolMinPorts"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KuryrConfig implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("controllerProbesPort")
    private Integer controllerProbesPort;
    /**
     * 
     * 
     */
    @JsonProperty("daemonProbesPort")
    private Integer daemonProbesPort;
    /**
     * 
     * 
     */
    @JsonProperty("enablePortPoolsPrepopulation")
    private Boolean enablePortPoolsPrepopulation;
    /**
     * 
     * 
     */
    @JsonProperty("openStackServiceNetwork")
    private String openStackServiceNetwork;
    /**
     * 
     * 
     */
    @JsonProperty("poolBatchPorts")
    private Integer poolBatchPorts;
    /**
     * 
     * 
     */
    @JsonProperty("poolMaxPorts")
    private Integer poolMaxPorts;
    /**
     * 
     * 
     */
    @JsonProperty("poolMinPorts")
    private Integer poolMinPorts;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KuryrConfig() {
    }

    /**
     * 
     * @param controllerProbesPort
     * @param daemonProbesPort
     * @param enablePortPoolsPrepopulation
     * @param openStackServiceNetwork
     * @param poolBatchPorts
     * @param poolMaxPorts
     * @param poolMinPorts
     */
    public KuryrConfig(Integer controllerProbesPort, Integer daemonProbesPort, Boolean enablePortPoolsPrepopulation, String openStackServiceNetwork, Integer poolBatchPorts, Integer poolMaxPorts, Integer poolMinPorts) {
        this.controllerProbesPort = controllerProbesPort;
        this.daemonProbesPort = daemonProbesPort;
        this.enablePortPoolsPrepopulation = enablePortPoolsPrepopulation;
        this.openStackServiceNetwork = openStackServiceNetwork;
        this.poolBatchPorts = poolBatchPorts;
        this.poolMaxPorts = poolMaxPorts;
        this.poolMinPorts = poolMinPorts;
    }

    /**
     * 
     * 
     * @return
     *     The controllerProbesPort
     */
    @JsonProperty("controllerProbesPort")
    public Integer getControllerProbesPort() {
        return controllerProbesPort;
    }

    /**
     * 
     * 
     * @param controllerProbesPort
     *     The controllerProbesPort
     */
    @JsonProperty("controllerProbesPort")
    public void setControllerProbesPort(Integer controllerProbesPort) {
        this.controllerProbesPort = controllerProbesPort;
    }

    /**
     * 
     * 
     * @return
     *     The daemonProbesPort
     */
    @JsonProperty("daemonProbesPort")
    public Integer getDaemonProbesPort() {
        return daemonProbesPort;
    }

    /**
     * 
     * 
     * @param daemonProbesPort
     *     The daemonProbesPort
     */
    @JsonProperty("daemonProbesPort")
    public void setDaemonProbesPort(Integer daemonProbesPort) {
        this.daemonProbesPort = daemonProbesPort;
    }

    /**
     * 
     * 
     * @return
     *     The enablePortPoolsPrepopulation
     */
    @JsonProperty("enablePortPoolsPrepopulation")
    public Boolean getEnablePortPoolsPrepopulation() {
        return enablePortPoolsPrepopulation;
    }

    /**
     * 
     * 
     * @param enablePortPoolsPrepopulation
     *     The enablePortPoolsPrepopulation
     */
    @JsonProperty("enablePortPoolsPrepopulation")
    public void setEnablePortPoolsPrepopulation(Boolean enablePortPoolsPrepopulation) {
        this.enablePortPoolsPrepopulation = enablePortPoolsPrepopulation;
    }

    /**
     * 
     * 
     * @return
     *     The openStackServiceNetwork
     */
    @JsonProperty("openStackServiceNetwork")
    public String getOpenStackServiceNetwork() {
        return openStackServiceNetwork;
    }

    /**
     * 
     * 
     * @param openStackServiceNetwork
     *     The openStackServiceNetwork
     */
    @JsonProperty("openStackServiceNetwork")
    public void setOpenStackServiceNetwork(String openStackServiceNetwork) {
        this.openStackServiceNetwork = openStackServiceNetwork;
    }

    /**
     * 
     * 
     * @return
     *     The poolBatchPorts
     */
    @JsonProperty("poolBatchPorts")
    public Integer getPoolBatchPorts() {
        return poolBatchPorts;
    }

    /**
     * 
     * 
     * @param poolBatchPorts
     *     The poolBatchPorts
     */
    @JsonProperty("poolBatchPorts")
    public void setPoolBatchPorts(Integer poolBatchPorts) {
        this.poolBatchPorts = poolBatchPorts;
    }

    /**
     * 
     * 
     * @return
     *     The poolMaxPorts
     */
    @JsonProperty("poolMaxPorts")
    public Integer getPoolMaxPorts() {
        return poolMaxPorts;
    }

    /**
     * 
     * 
     * @param poolMaxPorts
     *     The poolMaxPorts
     */
    @JsonProperty("poolMaxPorts")
    public void setPoolMaxPorts(Integer poolMaxPorts) {
        this.poolMaxPorts = poolMaxPorts;
    }

    /**
     * 
     * 
     * @return
     *     The poolMinPorts
     */
    @JsonProperty("poolMinPorts")
    public Integer getPoolMinPorts() {
        return poolMinPorts;
    }

    /**
     * 
     * 
     * @param poolMinPorts
     *     The poolMinPorts
     */
    @JsonProperty("poolMinPorts")
    public void setPoolMinPorts(Integer poolMinPorts) {
        this.poolMinPorts = poolMinPorts;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
