package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftControllerManagerListBuilder extends OpenShiftControllerManagerListFluentImpl<OpenShiftControllerManagerListBuilder> implements VisitableBuilder<OpenShiftControllerManagerList,OpenShiftControllerManagerListBuilder> {

    OpenShiftControllerManagerListFluent<?> fluent;
    Boolean validationEnabled;

    public OpenShiftControllerManagerListBuilder() { 
        this(true);
    }


    public OpenShiftControllerManagerListBuilder(Boolean validationEnabled) { 
        this(new OpenShiftControllerManagerList(), validationEnabled);
    }


    public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerListFluent<?> fluent) { 
        this(fluent, true);
    }


    public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new OpenShiftControllerManagerList(), validationEnabled);
    }


    public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerListFluent<?> fluent,OpenShiftControllerManagerList instance) { 
        this(fluent, instance, true);
    }


    public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerListFluent<?> fluent,OpenShiftControllerManagerList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerList instance) { 
        this(instance,true);
    }


    public OpenShiftControllerManagerListBuilder(OpenShiftControllerManagerList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public OpenShiftControllerManagerList build() {
        OpenShiftControllerManagerList buildable = new OpenShiftControllerManagerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenShiftControllerManagerListBuilder that = (OpenShiftControllerManagerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
