package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface OpenShiftControllerManagerStatusFluent<A extends OpenShiftControllerManagerStatusFluent<A>> extends Fluent<A> {


    public A addToConditions(int index,OperatorCondition item);
    public A setToConditions(int index,OperatorCondition item);
    public A addToConditions(OperatorCondition... items);
    public A addAllToConditions(Collection<OperatorCondition> items);
    public A removeFromConditions(OperatorCondition... items);
    public A removeAllFromConditions(Collection<OperatorCondition> items);
    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions();
    public List<OperatorCondition> buildConditions();
    public OperatorCondition buildCondition(int index);
    public OperatorCondition buildFirstCondition();
    public OperatorCondition buildLastCondition();
    public OperatorCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public A withConditions(List<OperatorCondition> conditions);
    public A withConditions(OperatorCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public OpenShiftControllerManagerStatusFluent.ConditionsNested<A> addNewCondition();
    public OpenShiftControllerManagerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
    public OpenShiftControllerManagerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
    public OpenShiftControllerManagerStatusFluent.ConditionsNested<A> editCondition(int index);
    public OpenShiftControllerManagerStatusFluent.ConditionsNested<A> editFirstCondition();
    public OpenShiftControllerManagerStatusFluent.ConditionsNested<A> editLastCondition();
    public OpenShiftControllerManagerStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public A addToGenerations(int index,GenerationStatus item);
    public A setToGenerations(int index,GenerationStatus item);
    public A addToGenerations(GenerationStatus... items);
    public A addAllToGenerations(Collection<GenerationStatus> items);
    public A removeFromGenerations(GenerationStatus... items);
    public A removeAllFromGenerations(Collection<GenerationStatus> items);
    public A removeMatchingFromGenerations(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGenerations instead.
 * @return The buildable object.
 */
@Deprecated public List<GenerationStatus> getGenerations();
    public List<GenerationStatus> buildGenerations();
    public GenerationStatus buildGeneration(int index);
    public GenerationStatus buildFirstGeneration();
    public GenerationStatus buildLastGeneration();
    public GenerationStatus buildMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate);
    public Boolean hasMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate);
    public A withGenerations(List<GenerationStatus> generations);
    public A withGenerations(GenerationStatus... generations);
    public Boolean hasGenerations();
    public OpenShiftControllerManagerStatusFluent.GenerationsNested<A> addNewGeneration();
    public OpenShiftControllerManagerStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item);
    public OpenShiftControllerManagerStatusFluent.GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item);
    public OpenShiftControllerManagerStatusFluent.GenerationsNested<A> editGeneration(int index);
    public OpenShiftControllerManagerStatusFluent.GenerationsNested<A> editFirstGeneration();
    public OpenShiftControllerManagerStatusFluent.GenerationsNested<A> editLastGeneration();
    public OpenShiftControllerManagerStatusFluent.GenerationsNested<A> editMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorConditionFluent<OpenShiftControllerManagerStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


    public interface GenerationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenerationStatusFluent<OpenShiftControllerManagerStatusFluent.GenerationsNested<N>> {

        public N and();
        public N endGeneration();    }


}
