package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class OpenShiftSDNConfigFluentImpl<A extends OpenShiftSDNConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OpenShiftSDNConfigFluent<A> {

    private Boolean enableUnidling;
    private String mode;
    private Integer mtu;
    private Boolean useExternalOpenvswitch;
    private Integer vxlanPort;

    public OpenShiftSDNConfigFluentImpl() { 
    }


    public OpenShiftSDNConfigFluentImpl(OpenShiftSDNConfig instance) { 
        this.withEnableUnidling(instance.getEnableUnidling()); 
        this.withMode(instance.getMode()); 
        this.withMtu(instance.getMtu()); 
        this.withUseExternalOpenvswitch(instance.getUseExternalOpenvswitch()); 
        this.withVxlanPort(instance.getVxlanPort()); 
    }


    public Boolean isEnableUnidling() {
        return this.enableUnidling;
    }

    public A withEnableUnidling(Boolean enableUnidling) {
        this.enableUnidling=enableUnidling; return (A) this;
    }

    public Boolean hasEnableUnidling() {
        return this.enableUnidling != null;
    }

    public A withNewEnableUnidling(String arg1) {
        return (A)withEnableUnidling(new Boolean(arg1));
    }

    public A withNewEnableUnidling(boolean arg1) {
        return (A)withEnableUnidling(new Boolean(arg1));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public A withMtu(Integer mtu) {
        this.mtu=mtu; return (A) this;
    }

    public Boolean hasMtu() {
        return this.mtu != null;
    }

    public Boolean isUseExternalOpenvswitch() {
        return this.useExternalOpenvswitch;
    }

    public A withUseExternalOpenvswitch(Boolean useExternalOpenvswitch) {
        this.useExternalOpenvswitch=useExternalOpenvswitch; return (A) this;
    }

    public Boolean hasUseExternalOpenvswitch() {
        return this.useExternalOpenvswitch != null;
    }

    public A withNewUseExternalOpenvswitch(String arg1) {
        return (A)withUseExternalOpenvswitch(new Boolean(arg1));
    }

    public A withNewUseExternalOpenvswitch(boolean arg1) {
        return (A)withUseExternalOpenvswitch(new Boolean(arg1));
    }

    public Integer getVxlanPort() {
        return this.vxlanPort;
    }

    public A withVxlanPort(Integer vxlanPort) {
        this.vxlanPort=vxlanPort; return (A) this;
    }

    public Boolean hasVxlanPort() {
        return this.vxlanPort != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OpenShiftSDNConfigFluentImpl that = (OpenShiftSDNConfigFluentImpl) o;
        if (enableUnidling != null ? !enableUnidling.equals(that.enableUnidling) :that.enableUnidling != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (mtu != null ? !mtu.equals(that.mtu) :that.mtu != null) return false;
        if (useExternalOpenvswitch != null ? !useExternalOpenvswitch.equals(that.useExternalOpenvswitch) :that.useExternalOpenvswitch != null) return false;
        if (vxlanPort != null ? !vxlanPort.equals(that.vxlanPort) :that.vxlanPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(enableUnidling,  mode,  mtu,  useExternalOpenvswitch,  vxlanPort,  super.hashCode());
    }

}
