package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSRecordStatusBuilder extends DNSRecordStatusFluentImpl<DNSRecordStatusBuilder> implements VisitableBuilder<DNSRecordStatus,DNSRecordStatusBuilder> {

    DNSRecordStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DNSRecordStatusBuilder() {
        this(true);
    }

    public DNSRecordStatusBuilder(Boolean validationEnabled) {
        this(new DNSRecordStatus(), validationEnabled);
    }

    public DNSRecordStatusBuilder(DNSRecordStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSRecordStatusBuilder(DNSRecordStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSRecordStatus(), validationEnabled);
    }

    public DNSRecordStatusBuilder(DNSRecordStatusFluent<?> fluent,DNSRecordStatus instance) {
        this(fluent, instance, true);
    }

    public DNSRecordStatusBuilder(DNSRecordStatusFluent<?> fluent,DNSRecordStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withZones(instance.getZones()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSRecordStatusBuilder(DNSRecordStatus instance) {
        this(instance,true);
    }

    public DNSRecordStatusBuilder(DNSRecordStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withZones(instance.getZones()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSRecordStatus build() {
        DNSRecordStatus buildable = new DNSRecordStatus(fluent.getObservedGeneration(),fluent.getZones());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSRecordStatusBuilder that = (DNSRecordStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
