package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeSchedulerSpecBuilder extends KubeSchedulerSpecFluentImpl<KubeSchedulerSpecBuilder> implements VisitableBuilder<KubeSchedulerSpec,KubeSchedulerSpecBuilder> {

    KubeSchedulerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KubeSchedulerSpecBuilder() {
        this(true);
    }

    public KubeSchedulerSpecBuilder(Boolean validationEnabled) {
        this(new KubeSchedulerSpec(), validationEnabled);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KubeSchedulerSpec(), validationEnabled);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent,KubeSchedulerSpec instance) {
        this(fluent, instance, true);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent,KubeSchedulerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
        fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpec instance) {
        this(instance,true);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
        this.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeSchedulerSpec build() {
        KubeSchedulerSpec buildable = new KubeSchedulerSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeSchedulerSpecBuilder that = (KubeSchedulerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
