package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServerBuilder extends ServerFluentImpl<ServerBuilder> implements VisitableBuilder<Server,ServerBuilder> {

    ServerFluent<?> fluent;
    Boolean validationEnabled;

    public ServerBuilder() {
        this(true);
    }

    public ServerBuilder(Boolean validationEnabled) {
        this(new Server(), validationEnabled);
    }

    public ServerBuilder(ServerFluent<?> fluent) {
        this(fluent, true);
    }

    public ServerBuilder(ServerFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Server(), validationEnabled);
    }

    public ServerBuilder(ServerFluent<?> fluent,Server instance) {
        this(fluent, instance, true);
    }

    public ServerBuilder(ServerFluent<?> fluent,Server instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withForwardPlugin(instance.getForwardPlugin()); 
        fluent.withName(instance.getName()); 
        fluent.withZones(instance.getZones()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServerBuilder(Server instance) {
        this(instance,true);
    }

    public ServerBuilder(Server instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withForwardPlugin(instance.getForwardPlugin()); 
        this.withName(instance.getName()); 
        this.withZones(instance.getZones()); 
        this.validationEnabled = validationEnabled; 
    }

    public Server build() {
        Server buildable = new Server(fluent.getForwardPlugin(),fluent.getName(),fluent.getZones());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServerBuilder that = (ServerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
