package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServerFluentImpl<A extends ServerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServerFluent<A> {

    private ForwardPluginBuilder forwardPlugin;
    private String name;
    private List<String> zones = new ArrayList<String>();

    public ServerFluentImpl() {
    }

    public ServerFluentImpl(Server instance) {
        this.withForwardPlugin(instance.getForwardPlugin()); 
        this.withName(instance.getName()); 
        this.withZones(instance.getZones()); 
    }

    
/**
 * This method has been deprecated, please use method buildForwardPlugin instead.
 * @return The buildable object.
 */
@Deprecated public ForwardPlugin getForwardPlugin() {
        return this.forwardPlugin!=null?this.forwardPlugin.build():null;
    }

    public ForwardPlugin buildForwardPlugin() {
        return this.forwardPlugin!=null?this.forwardPlugin.build():null;
    }

    public A withForwardPlugin(ForwardPlugin forwardPlugin) {
        _visitables.get("forwardPlugin").remove(this.forwardPlugin);
        if (forwardPlugin!=null){ this.forwardPlugin= new ForwardPluginBuilder(forwardPlugin); _visitables.get("forwardPlugin").add(this.forwardPlugin);} return (A) this;
    }

    public Boolean hasForwardPlugin() {
        return this.forwardPlugin != null;
    }

    public ServerFluent.ForwardPluginNested<A> withNewForwardPlugin() {
        return new ForwardPluginNestedImpl();
    }

    public ServerFluent.ForwardPluginNested<A> withNewForwardPluginLike(ForwardPlugin item) {
        return new ForwardPluginNestedImpl(item);
    }

    public ServerFluent.ForwardPluginNested<A> editForwardPlugin() {
        return withNewForwardPluginLike(getForwardPlugin());
    }

    public ServerFluent.ForwardPluginNested<A> editOrNewForwardPlugin() {
        return withNewForwardPluginLike(getForwardPlugin() != null ? getForwardPlugin(): new ForwardPluginBuilder().build());
    }

    public ServerFluent.ForwardPluginNested<A> editOrNewForwardPluginLike(ForwardPlugin item) {
        return withNewForwardPluginLike(getForwardPlugin() != null ? getForwardPlugin(): item);
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A addToZones(int index,String item) {
        if (this.zones == null) {this.zones = new ArrayList<String>();}
        this.zones.add(index, item);
        return (A)this;
    }

    public A setToZones(int index,String item) {
        if (this.zones == null) {this.zones = new ArrayList<String>();}
        this.zones.set(index, item); return (A)this;
    }

    public A addToZones(String... items) {
        if (this.zones == null) {this.zones = new ArrayList<String>();}
        for (String item : items) {this.zones.add(item);} return (A)this;
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {this.zones = new ArrayList<String>();}
        for (String item : items) {this.zones.add(item);} return (A)this;
    }

    public A removeFromZones(String... items) {
        for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
    }

    public A removeAllFromZones(Collection<String> items) {
        for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withZones(List<String> zones) {
        if (this.zones != null) { _visitables.get("zones").removeAll(this.zones);}
        if (zones != null) {this.zones = new ArrayList<String>(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
    }

    public A withZones(String... zones) {
        if (this.zones != null) {this.zones.clear();}
        if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
    }

    public Boolean hasZones() {
        return zones != null && !zones.isEmpty();
    }

    public A addNewZone(String arg1) {
        return (A)addToZones(new String(arg1));
    }

    public A addNewZone(StringBuilder arg1) {
        return (A)addToZones(new String(arg1));
    }

    public A addNewZone(StringBuffer arg1) {
        return (A)addToZones(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServerFluentImpl that = (ServerFluentImpl) o;
        if (forwardPlugin != null ? !forwardPlugin.equals(that.forwardPlugin) :that.forwardPlugin != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (zones != null ? !zones.equals(that.zones) :that.zones != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(forwardPlugin,  name,  zones,  super.hashCode());
    }

    public class ForwardPluginNestedImpl<N> extends ForwardPluginFluentImpl<ServerFluent.ForwardPluginNested<N>> implements ServerFluent.ForwardPluginNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ForwardPluginBuilder builder;

            ForwardPluginNestedImpl(ForwardPlugin item) {
                this.builder = new ForwardPluginBuilder(this, item);
                        
            }

            ForwardPluginNestedImpl() {
                this.builder = new ForwardPluginBuilder(this);
                        
            }

            public N and() {
                return (N) ServerFluentImpl.this.withForwardPlugin(builder.build());
            }

            public N endForwardPlugin() {
                return and();
            }
    }


}
