package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointPublishingStrategyBuilder extends EndpointPublishingStrategyFluentImpl<EndpointPublishingStrategyBuilder> implements VisitableBuilder<EndpointPublishingStrategy,EndpointPublishingStrategyBuilder> {

    EndpointPublishingStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointPublishingStrategyBuilder() {
        this(true);
    }

    public EndpointPublishingStrategyBuilder(Boolean validationEnabled) {
        this(new EndpointPublishingStrategy(), validationEnabled);
    }

    public EndpointPublishingStrategyBuilder(EndpointPublishingStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointPublishingStrategyBuilder(EndpointPublishingStrategyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EndpointPublishingStrategy(), validationEnabled);
    }

    public EndpointPublishingStrategyBuilder(EndpointPublishingStrategyFluent<?> fluent,EndpointPublishingStrategy instance) {
        this(fluent, instance, true);
    }

    public EndpointPublishingStrategyBuilder(EndpointPublishingStrategyFluent<?> fluent,EndpointPublishingStrategy instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHostNetwork(instance.getHostNetwork()); 
        fluent.withLoadBalancer(instance.getLoadBalancer()); 
        fluent.withNodePort(instance.getNodePort()); 
        fluent.withPrivate(instance.getPrivate()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointPublishingStrategyBuilder(EndpointPublishingStrategy instance) {
        this(instance,true);
    }

    public EndpointPublishingStrategyBuilder(EndpointPublishingStrategy instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHostNetwork(instance.getHostNetwork()); 
        this.withLoadBalancer(instance.getLoadBalancer()); 
        this.withNodePort(instance.getNodePort()); 
        this.withPrivate(instance.getPrivate()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointPublishingStrategy build() {
        EndpointPublishingStrategy buildable = new EndpointPublishingStrategy(fluent.getHostNetwork(),fluent.getLoadBalancer(),fluent.getNodePort(),fluent.getPrivate(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointPublishingStrategyBuilder that = (EndpointPublishingStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
