package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ForwardPluginFluentImpl<A extends ForwardPluginFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ForwardPluginFluent<A> {

    private List<String> upstreams = new ArrayList<String>();

    public ForwardPluginFluentImpl() {
    }

    public ForwardPluginFluentImpl(ForwardPlugin instance) {
        this.withUpstreams(instance.getUpstreams()); 
    }

    public A addToUpstreams(int index,String item) {
        if (this.upstreams == null) {this.upstreams = new ArrayList<String>();}
        this.upstreams.add(index, item);
        return (A)this;
    }

    public A setToUpstreams(int index,String item) {
        if (this.upstreams == null) {this.upstreams = new ArrayList<String>();}
        this.upstreams.set(index, item); return (A)this;
    }

    public A addToUpstreams(String... items) {
        if (this.upstreams == null) {this.upstreams = new ArrayList<String>();}
        for (String item : items) {this.upstreams.add(item);} return (A)this;
    }

    public A addAllToUpstreams(Collection<String> items) {
        if (this.upstreams == null) {this.upstreams = new ArrayList<String>();}
        for (String item : items) {this.upstreams.add(item);} return (A)this;
    }

    public A removeFromUpstreams(String... items) {
        for (String item : items) {if (this.upstreams!= null){ this.upstreams.remove(item);}} return (A)this;
    }

    public A removeAllFromUpstreams(Collection<String> items) {
        for (String item : items) {if (this.upstreams!= null){ this.upstreams.remove(item);}} return (A)this;
    }

    public List<String> getUpstreams() {
        return this.upstreams;
    }

    public String getUpstream(int index) {
        return this.upstreams.get(index);
    }

    public String getFirstUpstream() {
        return this.upstreams.get(0);
    }

    public String getLastUpstream() {
        return this.upstreams.get(upstreams.size() - 1);
    }

    public String getMatchingUpstream(Predicate<String> predicate) {
        for (String item: upstreams) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingUpstream(Predicate<String> predicate) {
        for (String item: upstreams) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withUpstreams(List<String> upstreams) {
        if (this.upstreams != null) { _visitables.get("upstreams").removeAll(this.upstreams);}
        if (upstreams != null) {this.upstreams = new ArrayList<String>(); for (String item : upstreams){this.addToUpstreams(item);}} else { this.upstreams = null;} return (A) this;
    }

    public A withUpstreams(String... upstreams) {
        if (this.upstreams != null) {this.upstreams.clear();}
        if (upstreams != null) {for (String item :upstreams){ this.addToUpstreams(item);}} return (A) this;
    }

    public Boolean hasUpstreams() {
        return upstreams != null && !upstreams.isEmpty();
    }

    public A addNewUpstream(String arg1) {
        return (A)addToUpstreams(new String(arg1));
    }

    public A addNewUpstream(StringBuilder arg1) {
        return (A)addToUpstreams(new String(arg1));
    }

    public A addNewUpstream(StringBuffer arg1) {
        return (A)addToUpstreams(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ForwardPluginFluentImpl that = (ForwardPluginFluentImpl) o;
        if (upstreams != null ? !upstreams.equals(that.upstreams) :that.upstreams != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(upstreams,  super.hashCode());
    }

}
