package io.fabric8.openshift.api.model.operator.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class GenerationStatusFluentImpl<A extends GenerationStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GenerationStatusFluent<A> {

    private String group;
    private String hash;
    private Long lastGeneration;
    private String name;
    private String namespace;
    private String resource;

    public GenerationStatusFluentImpl() {
    }

    public GenerationStatusFluentImpl(GenerationStatus instance) {
        this.withGroup(instance.getGroup()); 
        this.withHash(instance.getHash()); 
        this.withLastGeneration(instance.getLastGeneration()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withResource(instance.getResource()); 
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    public String getHash() {
        return this.hash;
    }

    public A withHash(String hash) {
        this.hash=hash; return (A) this;
    }

    public Boolean hasHash() {
        return this.hash != null;
    }

    public A withNewHash(String arg1) {
        return (A)withHash(new String(arg1));
    }

    public A withNewHash(StringBuilder arg1) {
        return (A)withHash(new String(arg1));
    }

    public A withNewHash(StringBuffer arg1) {
        return (A)withHash(new String(arg1));
    }

    public Long getLastGeneration() {
        return this.lastGeneration;
    }

    public A withLastGeneration(Long lastGeneration) {
        this.lastGeneration=lastGeneration; return (A) this;
    }

    public Boolean hasLastGeneration() {
        return this.lastGeneration != null;
    }

    public A withNewLastGeneration(String arg1) {
        return (A)withLastGeneration(new Long(arg1));
    }

    public A withNewLastGeneration(long arg1) {
        return (A)withLastGeneration(new Long(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public A withNewNamespace(String arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource=resource; return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(String arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuilder arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuffer arg1) {
        return (A)withResource(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenerationStatusFluentImpl that = (GenerationStatusFluentImpl) o;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (hash != null ? !hash.equals(that.hash) :that.hash != null) return false;
        if (lastGeneration != null ? !lastGeneration.equals(that.lastGeneration) :that.lastGeneration != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(group,  hash,  lastGeneration,  name,  namespace,  resource,  super.hashCode());
    }

}
