package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LoadBalancerStrategyBuilder extends LoadBalancerStrategyFluentImpl<LoadBalancerStrategyBuilder> implements VisitableBuilder<LoadBalancerStrategy,LoadBalancerStrategyBuilder> {

    LoadBalancerStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerStrategyBuilder() {
        this(true);
    }

    public LoadBalancerStrategyBuilder(Boolean validationEnabled) {
        this(new LoadBalancerStrategy(), validationEnabled);
    }

    public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new LoadBalancerStrategy(), validationEnabled);
    }

    public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent,LoadBalancerStrategy instance) {
        this(fluent, instance, true);
    }

    public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent,LoadBalancerStrategy instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withProviderParameters(instance.getProviderParameters()); 
        fluent.withScope(instance.getScope()); 
        this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerStrategyBuilder(LoadBalancerStrategy instance) {
        this(instance,true);
    }

    public LoadBalancerStrategyBuilder(LoadBalancerStrategy instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withProviderParameters(instance.getProviderParameters()); 
        this.withScope(instance.getScope()); 
        this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerStrategy build() {
        LoadBalancerStrategy buildable = new LoadBalancerStrategy(fluent.getProviderParameters(),fluent.getScope());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LoadBalancerStrategyBuilder that = (LoadBalancerStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
