package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class OAuthAPIServerStatusFluentImpl<A extends OAuthAPIServerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OAuthAPIServerStatusFluent<A> {

    private Integer latestAvailableRevision;

    public OAuthAPIServerStatusFluentImpl() {
    }

    public OAuthAPIServerStatusFluentImpl(OAuthAPIServerStatus instance) {
        this.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
    }

    public Integer getLatestAvailableRevision() {
        return this.latestAvailableRevision;
    }

    public A withLatestAvailableRevision(Integer latestAvailableRevision) {
        this.latestAvailableRevision=latestAvailableRevision; return (A) this;
    }

    public Boolean hasLatestAvailableRevision() {
        return this.latestAvailableRevision != null;
    }

    public A withNewLatestAvailableRevision(String arg1) {
        return (A)withLatestAvailableRevision(new Integer(arg1));
    }

    public A withNewLatestAvailableRevision(int arg1) {
        return (A)withLatestAvailableRevision(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OAuthAPIServerStatusFluentImpl that = (OAuthAPIServerStatusFluentImpl) o;
        if (latestAvailableRevision != null ? !latestAvailableRevision.equals(that.latestAvailableRevision) :that.latestAvailableRevision != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(latestAvailableRevision,  super.hashCode());
    }

}
