package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class OVNKubernetesConfigFluentImpl<A extends OVNKubernetesConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OVNKubernetesConfigFluent<A> {

    private Integer genevePort;
    private HybridOverlayConfigBuilder hybridOverlayConfig;
    private Integer mtu;

    public OVNKubernetesConfigFluentImpl() {
    }

    public OVNKubernetesConfigFluentImpl(OVNKubernetesConfig instance) {
        this.withGenevePort(instance.getGenevePort()); 
        this.withHybridOverlayConfig(instance.getHybridOverlayConfig()); 
        this.withMtu(instance.getMtu()); 
    }

    public Integer getGenevePort() {
        return this.genevePort;
    }

    public A withGenevePort(Integer genevePort) {
        this.genevePort=genevePort; return (A) this;
    }

    public Boolean hasGenevePort() {
        return this.genevePort != null;
    }

    public A withNewGenevePort(String arg1) {
        return (A)withGenevePort(new Integer(arg1));
    }

    public A withNewGenevePort(int arg1) {
        return (A)withGenevePort(new Integer(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildHybridOverlayConfig instead.
 * @return The buildable object.
 */
@Deprecated public HybridOverlayConfig getHybridOverlayConfig() {
        return this.hybridOverlayConfig!=null?this.hybridOverlayConfig.build():null;
    }

    public HybridOverlayConfig buildHybridOverlayConfig() {
        return this.hybridOverlayConfig!=null?this.hybridOverlayConfig.build():null;
    }

    public A withHybridOverlayConfig(HybridOverlayConfig hybridOverlayConfig) {
        _visitables.get("hybridOverlayConfig").remove(this.hybridOverlayConfig);
        if (hybridOverlayConfig!=null){ this.hybridOverlayConfig= new HybridOverlayConfigBuilder(hybridOverlayConfig); _visitables.get("hybridOverlayConfig").add(this.hybridOverlayConfig);} return (A) this;
    }

    public Boolean hasHybridOverlayConfig() {
        return this.hybridOverlayConfig != null;
    }

    public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> withNewHybridOverlayConfig() {
        return new HybridOverlayConfigNestedImpl();
    }

    public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> withNewHybridOverlayConfigLike(HybridOverlayConfig item) {
        return new HybridOverlayConfigNestedImpl(item);
    }

    public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> editHybridOverlayConfig() {
        return withNewHybridOverlayConfigLike(getHybridOverlayConfig());
    }

    public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> editOrNewHybridOverlayConfig() {
        return withNewHybridOverlayConfigLike(getHybridOverlayConfig() != null ? getHybridOverlayConfig(): new HybridOverlayConfigBuilder().build());
    }

    public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> editOrNewHybridOverlayConfigLike(HybridOverlayConfig item) {
        return withNewHybridOverlayConfigLike(getHybridOverlayConfig() != null ? getHybridOverlayConfig(): item);
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public A withMtu(Integer mtu) {
        this.mtu=mtu; return (A) this;
    }

    public Boolean hasMtu() {
        return this.mtu != null;
    }

    public A withNewMtu(String arg1) {
        return (A)withMtu(new Integer(arg1));
    }

    public A withNewMtu(int arg1) {
        return (A)withMtu(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OVNKubernetesConfigFluentImpl that = (OVNKubernetesConfigFluentImpl) o;
        if (genevePort != null ? !genevePort.equals(that.genevePort) :that.genevePort != null) return false;
        if (hybridOverlayConfig != null ? !hybridOverlayConfig.equals(that.hybridOverlayConfig) :that.hybridOverlayConfig != null) return false;
        if (mtu != null ? !mtu.equals(that.mtu) :that.mtu != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(genevePort,  hybridOverlayConfig,  mtu,  super.hashCode());
    }

    public class HybridOverlayConfigNestedImpl<N> extends HybridOverlayConfigFluentImpl<OVNKubernetesConfigFluent.HybridOverlayConfigNested<N>> implements OVNKubernetesConfigFluent.HybridOverlayConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HybridOverlayConfigBuilder builder;

            HybridOverlayConfigNestedImpl(HybridOverlayConfig item) {
                this.builder = new HybridOverlayConfigBuilder(this, item);
                        
            }

            HybridOverlayConfigNestedImpl() {
                this.builder = new HybridOverlayConfigBuilder(this);
                        
            }

            public N and() {
                return (N) OVNKubernetesConfigFluentImpl.this.withHybridOverlayConfig(builder.build());
            }

            public N endHybridOverlayConfig() {
                return and();
            }
    }


}
