package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ServiceCatalogControllerManagerStatusFluent<A extends ServiceCatalogControllerManagerStatusFluent<A>> extends Fluent<A> {


    public A addToConditions(int index,OperatorCondition item);
    public A setToConditions(int index,OperatorCondition item);
    public A addToConditions(OperatorCondition... items);
    public A addAllToConditions(Collection<OperatorCondition> items);
    public A removeFromConditions(OperatorCondition... items);
    public A removeAllFromConditions(Collection<OperatorCondition> items);
    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions();
    public List<OperatorCondition> buildConditions();
    public OperatorCondition buildCondition(int index);
    public OperatorCondition buildFirstCondition();
    public OperatorCondition buildLastCondition();
    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public A withConditions(List<OperatorCondition> conditions);
    public A withConditions(OperatorCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public ServiceCatalogControllerManagerStatusFluent.ConditionsNested<A> addNewCondition();
    public ServiceCatalogControllerManagerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
    public ServiceCatalogControllerManagerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
    public ServiceCatalogControllerManagerStatusFluent.ConditionsNested<A> editCondition(int index);
    public ServiceCatalogControllerManagerStatusFluent.ConditionsNested<A> editFirstCondition();
    public ServiceCatalogControllerManagerStatusFluent.ConditionsNested<A> editLastCondition();
    public ServiceCatalogControllerManagerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public A addToGenerations(int index,GenerationStatus item);
    public A setToGenerations(int index,GenerationStatus item);
    public A addToGenerations(GenerationStatus... items);
    public A addAllToGenerations(Collection<GenerationStatus> items);
    public A removeFromGenerations(GenerationStatus... items);
    public A removeAllFromGenerations(Collection<GenerationStatus> items);
    public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGenerations instead.
 * @return The buildable object.
 */
@Deprecated public List<GenerationStatus> getGenerations();
    public List<GenerationStatus> buildGenerations();
    public GenerationStatus buildGeneration(int index);
    public GenerationStatus buildFirstGeneration();
    public GenerationStatus buildLastGeneration();
    public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public Boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public A withGenerations(List<GenerationStatus> generations);
    public A withGenerations(GenerationStatus... generations);
    public Boolean hasGenerations();
    public ServiceCatalogControllerManagerStatusFluent.GenerationsNested<A> addNewGeneration();
    public ServiceCatalogControllerManagerStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item);
    public ServiceCatalogControllerManagerStatusFluent.GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item);
    public ServiceCatalogControllerManagerStatusFluent.GenerationsNested<A> editGeneration(int index);
    public ServiceCatalogControllerManagerStatusFluent.GenerationsNested<A> editFirstGeneration();
    public ServiceCatalogControllerManagerStatusFluent.GenerationsNested<A> editLastGeneration();
    public ServiceCatalogControllerManagerStatusFluent.GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(String arg1);
    public A withNewObservedGeneration(long arg1);
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public A withNewReadyReplicas(String arg1);
    public A withNewReadyReplicas(int arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorConditionFluent<ServiceCatalogControllerManagerStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface GenerationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenerationStatusFluent<ServiceCatalogControllerManagerStatusFluent.GenerationsNested<N>> {

            public N and();
            public N endGeneration();    }


}
