package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DNSStatusBuilder extends io.fabric8.openshift.api.model.operator.v1.DNSStatusFluentImpl<io.fabric8.openshift.api.model.operator.v1.DNSStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.DNSStatus,io.fabric8.openshift.api.model.operator.v1.DNSStatusBuilder>{
  public DNSStatusBuilder() {
    this(false);
  }
  public DNSStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new DNSStatus(), validationEnabled);
  }
  public DNSStatusBuilder(io.fabric8.openshift.api.model.operator.v1.DNSStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSStatusBuilder(io.fabric8.openshift.api.model.operator.v1.DNSStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DNSStatus(), validationEnabled);
  }
  public DNSStatusBuilder(io.fabric8.openshift.api.model.operator.v1.DNSStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.DNSStatus instance) {
    this(fluent, instance, false);
  }
  public DNSStatusBuilder(io.fabric8.openshift.api.model.operator.v1.DNSStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.DNSStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterDomain(instance.getClusterDomain()); 
    fluent.withClusterIP(instance.getClusterIP()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DNSStatusBuilder(io.fabric8.openshift.api.model.operator.v1.DNSStatus instance) {
    this(instance,false);
  }
  public DNSStatusBuilder(io.fabric8.openshift.api.model.operator.v1.DNSStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterDomain(instance.getClusterDomain()); 
    this.withClusterIP(instance.getClusterIP()); 
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.operator.v1.DNSStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.operator.v1.DNSStatus build() {
    DNSStatus buildable = new DNSStatus(fluent.getClusterDomain(),fluent.getClusterIP(),fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSStatusBuilder that = (DNSStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}