package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ImagePrunerSpecFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent<A>{
  public ImagePrunerSpecFluentImpl() {
  }
  public ImagePrunerSpecFluentImpl(io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpec instance) {
    this.withAffinity(instance.getAffinity()); 
    this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit()); 
    this.withIgnoreInvalidImageReferences(instance.getIgnoreInvalidImageReferences()); 
    this.withKeepTagRevisions(instance.getKeepTagRevisions()); 
    this.withKeepYoungerThan(instance.getKeepYoungerThan()); 
    this.withKeepYoungerThanDuration(instance.getKeepYoungerThanDuration()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withResources(instance.getResources()); 
    this.withSchedule(instance.getSchedule()); 
    this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit()); 
    this.withSuspend(instance.getSuspend()); 
    this.withTolerations(instance.getTolerations()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private io.fabric8.kubernetes.api.model.Affinity affinity;
  private java.lang.Integer failedJobsHistoryLimit;
  private java.lang.Boolean ignoreInvalidImageReferences;
  private java.lang.Integer keepTagRevisions;
  private java.lang.Long keepYoungerThan;
  private io.fabric8.kubernetes.api.model.Duration keepYoungerThanDuration;
  private java.lang.String logLevel;
  private java.util.Map<java.lang.String,java.lang.String> nodeSelector;
  private io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder resources;
  private java.lang.String schedule;
  private java.lang.Integer successfulJobsHistoryLimit;
  private java.lang.Boolean suspend;
  private java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public io.fabric8.kubernetes.api.model.Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(io.fabric8.kubernetes.api.model.Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public java.lang.Boolean hasAffinity() {
    return this.affinity != null;
  }
  public java.lang.Integer getFailedJobsHistoryLimit() {
    return this.failedJobsHistoryLimit;
  }
  public A withFailedJobsHistoryLimit(java.lang.Integer failedJobsHistoryLimit) {
    this.failedJobsHistoryLimit=failedJobsHistoryLimit; return (A) this;
  }
  public java.lang.Boolean hasFailedJobsHistoryLimit() {
    return this.failedJobsHistoryLimit != null;
  }
  public java.lang.Boolean getIgnoreInvalidImageReferences() {
    return this.ignoreInvalidImageReferences;
  }
  public A withIgnoreInvalidImageReferences(java.lang.Boolean ignoreInvalidImageReferences) {
    this.ignoreInvalidImageReferences=ignoreInvalidImageReferences; return (A) this;
  }
  public java.lang.Boolean hasIgnoreInvalidImageReferences() {
    return this.ignoreInvalidImageReferences != null;
  }
  public java.lang.Integer getKeepTagRevisions() {
    return this.keepTagRevisions;
  }
  public A withKeepTagRevisions(java.lang.Integer keepTagRevisions) {
    this.keepTagRevisions=keepTagRevisions; return (A) this;
  }
  public java.lang.Boolean hasKeepTagRevisions() {
    return this.keepTagRevisions != null;
  }
  public java.lang.Long getKeepYoungerThan() {
    return this.keepYoungerThan;
  }
  public A withKeepYoungerThan(java.lang.Long keepYoungerThan) {
    this.keepYoungerThan=keepYoungerThan; return (A) this;
  }
  public java.lang.Boolean hasKeepYoungerThan() {
    return this.keepYoungerThan != null;
  }
  public io.fabric8.kubernetes.api.model.Duration getKeepYoungerThanDuration() {
    return this.keepYoungerThanDuration;
  }
  public A withKeepYoungerThanDuration(io.fabric8.kubernetes.api.model.Duration keepYoungerThanDuration) {
    this.keepYoungerThanDuration=keepYoungerThanDuration; return (A) this;
  }
  public java.lang.Boolean hasKeepYoungerThanDuration() {
    return this.keepYoungerThanDuration != null;
  }
  public java.lang.String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(java.lang.String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public java.lang.Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  /**
   * Method is deprecated. use withLogLevel instead.
   */
  @java.lang.Deprecated
  public A withNewLogLevel(java.lang.String arg0) {
    return (A)withLogLevel(new String(arg0));
  }
  public A addToNodeSelector(java.lang.String key,java.lang.String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new java.util.LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(java.lang.String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(java.util.Map<java.lang.String,java.lang.String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new java.util.LinkedHashMap(nodeSelector);} return (A) this;
  }
  public java.lang.Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
    return this.resources!=null?this.resources.build():null;
  }
  public io.fabric8.kubernetes.api.model.ResourceRequirements buildResources() {
    return this.resources!=null?this.resources.build():null;
  }
  public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return this.resources != null;
  }
  public io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent.ResourcesNested<A> withNewResources() {
    return new io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return new io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder().build());
  }
  public io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public java.lang.String getSchedule() {
    return this.schedule;
  }
  public A withSchedule(java.lang.String schedule) {
    this.schedule=schedule; return (A) this;
  }
  public java.lang.Boolean hasSchedule() {
    return this.schedule != null;
  }
  
  /**
   * Method is deprecated. use withSchedule instead.
   */
  @java.lang.Deprecated
  public A withNewSchedule(java.lang.String arg0) {
    return (A)withSchedule(new String(arg0));
  }
  public java.lang.Integer getSuccessfulJobsHistoryLimit() {
    return this.successfulJobsHistoryLimit;
  }
  public A withSuccessfulJobsHistoryLimit(java.lang.Integer successfulJobsHistoryLimit) {
    this.successfulJobsHistoryLimit=successfulJobsHistoryLimit; return (A) this;
  }
  public java.lang.Boolean hasSuccessfulJobsHistoryLimit() {
    return this.successfulJobsHistoryLimit != null;
  }
  public java.lang.Boolean getSuspend() {
    return this.suspend;
  }
  public A withSuspend(java.lang.Boolean suspend) {
    this.suspend=suspend; return (A) this;
  }
  public java.lang.Boolean hasSuspend() {
    return this.suspend != null;
  }
  public A addToTolerations(java.lang.Integer index,io.fabric8.kubernetes.api.model.Toleration item) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(java.lang.Integer index,io.fabric8.kubernetes.api.model.Toleration item) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Toleration> getTolerations() {
    return this.tolerations;
  }
  public io.fabric8.kubernetes.api.model.Toleration getToleration(java.lang.Integer index) {
    return this.tolerations.get(index);
  }
  public io.fabric8.kubernetes.api.model.Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public io.fabric8.kubernetes.api.model.Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Toleration getMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
    for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
    for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear();}
    if (tolerations != null) {for (io.fabric8.kubernetes.api.model.Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public java.lang.Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,java.lang.Long tolerationSeconds,java.lang.String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImagePrunerSpecFluentImpl that = (ImagePrunerSpecFluentImpl) o;
    if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
    if (failedJobsHistoryLimit != null ? !failedJobsHistoryLimit.equals(that.failedJobsHistoryLimit) :that.failedJobsHistoryLimit != null) return false;
    if (ignoreInvalidImageReferences != null ? !ignoreInvalidImageReferences.equals(that.ignoreInvalidImageReferences) :that.ignoreInvalidImageReferences != null) return false;
    if (keepTagRevisions != null ? !keepTagRevisions.equals(that.keepTagRevisions) :that.keepTagRevisions != null) return false;
    if (keepYoungerThan != null ? !keepYoungerThan.equals(that.keepYoungerThan) :that.keepYoungerThan != null) return false;
    if (keepYoungerThanDuration != null ? !keepYoungerThanDuration.equals(that.keepYoungerThanDuration) :that.keepYoungerThanDuration != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (schedule != null ? !schedule.equals(that.schedule) :that.schedule != null) return false;
    if (successfulJobsHistoryLimit != null ? !successfulJobsHistoryLimit.equals(that.successfulJobsHistoryLimit) :that.successfulJobsHistoryLimit != null) return false;
    if (suspend != null ? !suspend.equals(that.suspend) :that.suspend != null) return false;
    if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(affinity,  failedJobsHistoryLimit,  ignoreInvalidImageReferences,  keepTagRevisions,  keepYoungerThan,  keepYoungerThanDuration,  logLevel,  nodeSelector,  resources,  schedule,  successfulJobsHistoryLimit,  suspend,  tolerations,  additionalProperties,  super.hashCode());
  }
  public class ResourcesNestedImpl<N> extends io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl<io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent.ResourcesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ImagePrunerSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourcesNestedImpl(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder builder;
    public N and() {
      return (N) ImagePrunerSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  
}