package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
public class NetworkSpecFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<A>{
  public NetworkSpecFluentImpl() {
  }
  public NetworkSpecFluentImpl(io.fabric8.openshift.api.model.operator.v1.NetworkSpec instance) {
    this.withAdditionalNetworks(instance.getAdditionalNetworks()); 
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withDefaultNetwork(instance.getDefaultNetwork()); 
    this.withDeployKubeProxy(instance.getDeployKubeProxy()); 
    this.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
    this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics()); 
    this.withExportNetworkFlows(instance.getExportNetworkFlows()); 
    this.withKubeProxyConfig(instance.getKubeProxyConfig()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withMigration(instance.getMigration()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> additionalNetworks =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();
  private java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> clusterNetwork =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();
  private io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder defaultNetwork;
  private java.lang.Boolean deployKubeProxy;
  private java.lang.Boolean disableMultiNetwork;
  private java.lang.Boolean disableNetworkDiagnostics;
  private io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder exportNetworkFlows;
  private io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder kubeProxyConfig;
  private java.lang.String logLevel;
  private java.lang.String managementState;
  private io.fabric8.openshift.api.model.operator.v1.NetworkMigrationBuilder migration;
  private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> observedConfig;
  private java.lang.String operatorLogLevel;
  private java.util.List<java.lang.String> serviceNetwork = new java.util.ArrayList<java.lang.String>();
  private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> unsupportedConfigOverrides;
  private java.lang.Boolean useMultiNetworkPolicy;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToAdditionalNetworks(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(index >= 0 ? index : _visitables.get("additionalNetworks").size(), builder);this.additionalNetworks.add(index >= 0 ? index : additionalNetworks.size(), builder); return (A)this;
  }
  public A setToAdditionalNetworks(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);
    if (index < 0 || index >= _visitables.get("additionalNetworks").size()) { _visitables.get("additionalNetworks").add(builder); } else { _visitables.get("additionalNetworks").set(index, builder);}
    if (index < 0 || index >= additionalNetworks.size()) { additionalNetworks.add(builder); } else { additionalNetworks.set(index, builder);}
     return (A)this;
  }
  public A addToAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : items) {io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
  }
  public A addAllToAdditionalNetworks(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> items) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : items) {io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
  }
  public A removeFromAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
    for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : items) {io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalNetworks(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> items) {
    for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : items) {io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalNetworks(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> predicate) {
    if (additionalNetworks == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> each = additionalNetworks.iterator();
    final List visitables = _visitables.get("additionalNetworks");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalNetworks instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> getAdditionalNetworks() {
    return build(additionalNetworks);
  }
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> buildAdditionalNetworks() {
    return build(additionalNetworks);
  }
  public io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition buildAdditionalNetwork(java.lang.Integer index) {
    return this.additionalNetworks.get(index).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition buildFirstAdditionalNetwork() {
    return this.additionalNetworks.get(0).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition buildLastAdditionalNetwork() {
    return this.additionalNetworks.get(additionalNetworks.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition buildMatchingAdditionalNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingAdditionalNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalNetworks(java.util.List<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> additionalNetworks) {
    if (this.additionalNetworks != null) { _visitables.get("additionalNetworks").removeAll(this.additionalNetworks);}
    if (additionalNetworks != null) {this.additionalNetworks = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : additionalNetworks){this.addToAdditionalNetworks(item);}} else { this.additionalNetworks = null;} return (A) this;
  }
  public A withAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... additionalNetworks) {
    if (this.additionalNetworks != null) {this.additionalNetworks.clear();}
    if (additionalNetworks != null) {for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item :additionalNetworks){ this.addToAdditionalNetworks(item);}} return (A) this;
  }
  public java.lang.Boolean hasAdditionalNetworks() {
    return additionalNetworks != null && !additionalNetworks.isEmpty();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AdditionalNetworksNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AdditionalNetworksNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AdditionalNetworksNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(java.lang.Integer index) {
    if (additionalNetworks.size() <= index) throw new RuntimeException("Can't edit additionalNetworks. Index exceeds size.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork() {
    if (additionalNetworks.size() == 0) throw new RuntimeException("Can't edit first additionalNetworks. The list is empty.");
    return setNewAdditionalNetworkLike(0, buildAdditionalNetwork(0));
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork() {
    int index = additionalNetworks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalNetworks. The list is empty.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalNetworks.size();i++) { 
    if (predicate.test(additionalNetworks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalNetworks. No match found.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public A addToClusterNetwork(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
  }
  public A setToClusterNetwork(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
    if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
     return (A)this;
  }
  public A addToClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A addAllToClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> items) {
    for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> getClusterNetwork() {
    return build(clusterNetwork);
  }
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> buildClusterNetwork() {
    return build(clusterNetwork);
  }
  public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildClusterNetwork(java.lang.Integer index) {
    return this.clusterNetwork.get(index).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetwork(java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
    if (clusterNetwork != null) {this.clusterNetwork = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
  }
  public A withClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
    if (clusterNetwork != null) {for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
  }
  public java.lang.Boolean hasClusterNetwork() {
    return clusterNetwork != null && !clusterNetwork.isEmpty();
  }
  public A addNewClusterNetwork(java.lang.String cidr,java.lang.Integer hostPrefix) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterNetworkNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterNetworkNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterNetworkNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(java.lang.Integer index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultNetwork instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition getDefaultNetwork() {
    return this.defaultNetwork!=null?this.defaultNetwork.build():null;
  }
  public io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition buildDefaultNetwork() {
    return this.defaultNetwork!=null?this.defaultNetwork.build():null;
  }
  public A withDefaultNetwork(io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition defaultNetwork) {
    _visitables.get("defaultNetwork").remove(this.defaultNetwork);
    if (defaultNetwork!=null){ this.defaultNetwork= new io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder(defaultNetwork); _visitables.get("defaultNetwork").add(this.defaultNetwork);} return (A) this;
  }
  public java.lang.Boolean hasDefaultNetwork() {
    return this.defaultNetwork != null;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DefaultNetworkNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DefaultNetworkNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork() {
    return withNewDefaultNetworkLike(getDefaultNetwork());
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork() {
    return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): new io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder().build());
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition item) {
    return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): item);
  }
  public java.lang.Boolean getDeployKubeProxy() {
    return this.deployKubeProxy;
  }
  public A withDeployKubeProxy(java.lang.Boolean deployKubeProxy) {
    this.deployKubeProxy=deployKubeProxy; return (A) this;
  }
  public java.lang.Boolean hasDeployKubeProxy() {
    return this.deployKubeProxy != null;
  }
  public java.lang.Boolean getDisableMultiNetwork() {
    return this.disableMultiNetwork;
  }
  public A withDisableMultiNetwork(java.lang.Boolean disableMultiNetwork) {
    this.disableMultiNetwork=disableMultiNetwork; return (A) this;
  }
  public java.lang.Boolean hasDisableMultiNetwork() {
    return this.disableMultiNetwork != null;
  }
  public java.lang.Boolean getDisableNetworkDiagnostics() {
    return this.disableNetworkDiagnostics;
  }
  public A withDisableNetworkDiagnostics(java.lang.Boolean disableNetworkDiagnostics) {
    this.disableNetworkDiagnostics=disableNetworkDiagnostics; return (A) this;
  }
  public java.lang.Boolean hasDisableNetworkDiagnostics() {
    return this.disableNetworkDiagnostics != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExportNetworkFlows instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows getExportNetworkFlows() {
    return this.exportNetworkFlows!=null?this.exportNetworkFlows.build():null;
  }
  public io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows buildExportNetworkFlows() {
    return this.exportNetworkFlows!=null?this.exportNetworkFlows.build():null;
  }
  public A withExportNetworkFlows(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows exportNetworkFlows) {
    _visitables.get("exportNetworkFlows").remove(this.exportNetworkFlows);
    if (exportNetworkFlows!=null){ this.exportNetworkFlows= new io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder(exportNetworkFlows); _visitables.get("exportNetworkFlows").add(this.exportNetworkFlows);} return (A) this;
  }
  public java.lang.Boolean hasExportNetworkFlows() {
    return this.exportNetworkFlows != null;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ExportNetworkFlowsNested<A> withNewExportNetworkFlows() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ExportNetworkFlowsNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ExportNetworkFlowsNested<A> withNewExportNetworkFlowsLike(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ExportNetworkFlowsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ExportNetworkFlowsNested<A> editExportNetworkFlows() {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows());
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ExportNetworkFlowsNested<A> editOrNewExportNetworkFlows() {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows() != null ? getExportNetworkFlows(): new io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder().build());
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ExportNetworkFlowsNested<A> editOrNewExportNetworkFlowsLike(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows item) {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows() != null ? getExportNetworkFlows(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubeProxyConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.operator.v1.ProxyConfig getKubeProxyConfig() {
    return this.kubeProxyConfig!=null?this.kubeProxyConfig.build():null;
  }
  public io.fabric8.openshift.api.model.operator.v1.ProxyConfig buildKubeProxyConfig() {
    return this.kubeProxyConfig!=null?this.kubeProxyConfig.build():null;
  }
  public A withKubeProxyConfig(io.fabric8.openshift.api.model.operator.v1.ProxyConfig kubeProxyConfig) {
    _visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig);
    if (kubeProxyConfig!=null){ this.kubeProxyConfig= new io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder(kubeProxyConfig); _visitables.get("kubeProxyConfig").add(this.kubeProxyConfig);} return (A) this;
  }
  public java.lang.Boolean hasKubeProxyConfig() {
    return this.kubeProxyConfig != null;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeProxyConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(io.fabric8.openshift.api.model.operator.v1.ProxyConfig item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeProxyConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig() {
    return withNewKubeProxyConfigLike(getKubeProxyConfig());
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig() {
    return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): new io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder().build());
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(io.fabric8.openshift.api.model.operator.v1.ProxyConfig item) {
    return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): item);
  }
  public java.lang.String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(java.lang.String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public java.lang.Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  /**
   * Method is deprecated. use withLogLevel instead.
   */
  @java.lang.Deprecated
  public A withNewLogLevel(java.lang.String arg0) {
    return (A)withLogLevel(new String(arg0));
  }
  public java.lang.String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(java.lang.String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public java.lang.Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * Method is deprecated. use withManagementState instead.
   */
  @java.lang.Deprecated
  public A withNewManagementState(java.lang.String arg0) {
    return (A)withManagementState(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMigration instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.operator.v1.NetworkMigration getMigration() {
    return this.migration!=null?this.migration.build():null;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkMigration buildMigration() {
    return this.migration!=null?this.migration.build():null;
  }
  public A withMigration(io.fabric8.openshift.api.model.operator.v1.NetworkMigration migration) {
    _visitables.get("migration").remove(this.migration);
    if (migration!=null){ this.migration= new io.fabric8.openshift.api.model.operator.v1.NetworkMigrationBuilder(migration); _visitables.get("migration").add(this.migration);} return (A) this;
  }
  public java.lang.Boolean hasMigration() {
    return this.migration != null;
  }
  public A withNewMigration(java.lang.String networkType) {
    return (A)withMigration(new NetworkMigration(networkType));
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.MigrationNested<A> withNewMigration() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.MigrationNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.MigrationNested<A> withNewMigrationLike(io.fabric8.openshift.api.model.operator.v1.NetworkMigration item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.MigrationNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.MigrationNested<A> editMigration() {
    return withNewMigrationLike(getMigration());
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.MigrationNested<A> editOrNewMigration() {
    return withNewMigrationLike(getMigration() != null ? getMigration(): new io.fabric8.openshift.api.model.operator.v1.NetworkMigrationBuilder().build());
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.MigrationNested<A> editOrNewMigrationLike(io.fabric8.openshift.api.model.operator.v1.NetworkMigration item) {
    return withNewMigrationLike(getMigration() != null ? getMigration(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObservedConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.HasMetadata getObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public A withObservedConfig(io.fabric8.kubernetes.api.model.HasMetadata observedConfig) {
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ImagePruner){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder((io.fabric8.openshift.api.model.operator.v1.ImagePruner)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.KubeControllerManager){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Storage){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.StorageBuilder((io.fabric8.openshift.api.model.operator.v1.Storage)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder((io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCA){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCA)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Config){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ConfigBuilder((io.fabric8.openshift.api.model.operator.v1.Config)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){ this.observedConfig= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.KubeAPIServer){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.IngressController){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder((io.fabric8.openshift.api.model.operator.v1.IngressController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder((io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Console){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder((io.fabric8.openshift.api.model.operator.v1.Console)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder((io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Etcd){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder((io.fabric8.openshift.api.model.operator.v1.Etcd)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.CloudCredential){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder((io.fabric8.openshift.api.model.operator.v1.CloudCredential)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.KubeScheduler){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeScheduler)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Network){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder((io.fabric8.openshift.api.model.operator.v1.Network)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck){ this.observedConfig= new io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder((io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.CSISnapshotController){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder((io.fabric8.openshift.api.model.operator.v1.CSISnapshotController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.DNS){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.DNSBuilder((io.fabric8.openshift.api.model.operator.v1.DNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.DNSRecord){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder((io.fabric8.openshift.api.model.operator.v1.DNSRecord)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Authentication){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder((io.fabric8.openshift.api.model.operator.v1.Authentication)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    return (A) this;
  }
  public java.lang.Boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  public A withImagePrunerObservedConfig(io.fabric8.openshift.api.model.operator.v1.ImagePruner imagePrunerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(imagePrunerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ImagePrunerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ImagePruner item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ImagePrunerObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerObservedConfig(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager kubeControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(kubeControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl(item);
  }
  public A withStorageObservedConfig(io.fabric8.openshift.api.model.operator.v1.Storage storageObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.StorageBuilder(storageObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.StorageObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Storage item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.StorageObservedConfigNestedImpl(item);
  }
  public A withImageContentSourcePolicyObservedConfig(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy imageContentSourcePolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imageContentSourcePolicyObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(imageContentSourcePolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl(item);
  }
  public A withServiceCAObservedConfig(io.fabric8.openshift.api.model.operator.v1.ServiceCA serviceCAObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCAObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(serviceCAObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCAObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ServiceCA item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCAObservedConfigNestedImpl(item);
  }
  public A withConfigObservedConfig(io.fabric8.openshift.api.model.operator.v1.Config configObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ConfigBuilder(configObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ConfigObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Config item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ConfigObservedConfigNestedImpl(item);
  }
  public A withPersistentVolumeClaimObservedConfig(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (persistentVolumeClaimObservedConfig!=null){ this.observedConfig= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaimObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerObservedConfig(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer kubeAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(kubeAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl(item);
  }
  public A withIngressControllerObservedConfig(io.fabric8.openshift.api.model.operator.v1.IngressController ingressControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(ingressControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.IngressControllerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.IngressController item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.IngressControllerObservedConfigNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorObservedConfig(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl(item);
  }
  public A withConsoleObservedConfig(io.fabric8.openshift.api.model.operator.v1.Console consoleObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(consoleObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ConsoleObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Console item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ConsoleObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverObservedConfig(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver clusterCSIDriverObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder(clusterCSIDriverObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerObservedConfig(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager openShiftControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(openShiftControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl(item);
  }
  public A withEtcdObservedConfig(io.fabric8.openshift.api.model.operator.v1.Etcd etcdObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(etcdObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.EtcdObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Etcd item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.EtcdObservedConfigNestedImpl(item);
  }
  public A withCloudCredentialObservedConfig(io.fabric8.openshift.api.model.operator.v1.CloudCredential cloudCredentialObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder(cloudCredentialObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.CloudCredentialObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.CloudCredential item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.CloudCredentialObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerObservedConfig(io.fabric8.openshift.api.model.operator.v1.KubeScheduler kubeSchedulerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(kubeSchedulerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.KubeScheduler item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl(item);
  }
  public A withNetworkObservedConfig(io.fabric8.openshift.api.model.operator.v1.Network networkObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(networkObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.NetworkObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Network item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.NetworkObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogAPIServerObservedConfig(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckObservedConfig(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck podNetworkConnectivityCheckObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfigLike(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerObservedConfig(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController cSISnapshotControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(cSISnapshotControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerObservedConfig(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl(item);
  }
  public A withDNSObservedConfig(io.fabric8.openshift.api.model.operator.v1.DNS dNSObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(dNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DNSObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.DNS item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DNSObservedConfigNestedImpl(item);
  }
  public A withDNSRecordObservedConfig(io.fabric8.openshift.api.model.operator.v1.DNSRecord dNSRecordObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(dNSRecordObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DNSRecordObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.DNSRecord item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DNSRecordObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerObservedConfig(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer openShiftAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(openShiftAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl(item);
  }
  public A withAuthenticationObservedConfig(io.fabric8.openshift.api.model.operator.v1.Authentication authenticationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(authenticationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AuthenticationObservedConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Authentication item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AuthenticationObservedConfigNestedImpl(item);
  }
  public java.lang.String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(java.lang.String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public java.lang.Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  /**
   * Method is deprecated. use withOperatorLogLevel instead.
   */
  @java.lang.Deprecated
  public A withNewOperatorLogLevel(java.lang.String arg0) {
    return (A)withOperatorLogLevel(new String(arg0));
  }
  public A addToServiceNetwork(java.lang.Integer index,java.lang.String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  public A setToServiceNetwork(java.lang.Integer index,java.lang.String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A addAllToServiceNetwork(java.util.Collection<java.lang.String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A removeFromServiceNetwork(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceNetwork(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  public java.lang.String getServiceNetwork(java.lang.Integer index) {
    return this.serviceNetwork.get(index);
  }
  public java.lang.String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  public java.lang.String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  public java.lang.String getMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceNetwork(java.util.List<java.lang.String> serviceNetwork) {
    if (serviceNetwork != null) {this.serviceNetwork = new java.util.ArrayList(); for (java.lang.String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
  }
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
    if (serviceNetwork != null) {for (java.lang.String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
  }
  public java.lang.Boolean hasServiceNetwork() {
    return serviceNetwork != null && !serviceNetwork.isEmpty();
  }
  public A addNewServiceNetwork(java.lang.String arg0) {
    return (A)addToServiceNetwork(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.HasMetadata getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(io.fabric8.kubernetes.api.model.HasMetadata unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ImagePruner){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder((io.fabric8.openshift.api.model.operator.v1.ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.KubeControllerManager){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Storage){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.StorageBuilder((io.fabric8.openshift.api.model.operator.v1.Storage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder((io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCA){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Config){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ConfigBuilder((io.fabric8.openshift.api.model.operator.v1.Config)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){ this.unsupportedConfigOverrides= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.KubeAPIServer){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.IngressController){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder((io.fabric8.openshift.api.model.operator.v1.IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder((io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Console){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder((io.fabric8.openshift.api.model.operator.v1.Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder((io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Etcd){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder((io.fabric8.openshift.api.model.operator.v1.Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.CloudCredential){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder((io.fabric8.openshift.api.model.operator.v1.CloudCredential)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.KubeScheduler){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Network){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder((io.fabric8.openshift.api.model.operator.v1.Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder((io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.CSISnapshotController){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder((io.fabric8.openshift.api.model.operator.v1.CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.DNS){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.DNSBuilder((io.fabric8.openshift.api.model.operator.v1.DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.DNSRecord){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder((io.fabric8.openshift.api.model.operator.v1.DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Authentication){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder((io.fabric8.openshift.api.model.operator.v1.Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    return (A) this;
  }
  public java.lang.Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A withImagePrunerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ImagePruner imagePrunerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ImagePruner item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Storage storageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.StorageBuilder(storageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Storage item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ServiceCA serviceCAUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ServiceCA item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Config configUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ConfigBuilder(configUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Config item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.IngressController ingressControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.IngressController item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Console consoleUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Console item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder(clusterCSIDriverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Etcd etcdUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Etcd item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCloudCredentialUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.CloudCredential cloudCredentialUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder(cloudCredentialUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.CloudCredential item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.KubeScheduler item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Network networkUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Network item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.DNS dNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.DNS item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSRecordUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.DNSRecord dNSRecordUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.DNSRecord item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Authentication authenticationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Authentication item) {
    return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
  }
  public java.lang.Boolean getUseMultiNetworkPolicy() {
    return this.useMultiNetworkPolicy;
  }
  public A withUseMultiNetworkPolicy(java.lang.Boolean useMultiNetworkPolicy) {
    this.useMultiNetworkPolicy=useMultiNetworkPolicy; return (A) this;
  }
  public java.lang.Boolean hasUseMultiNetworkPolicy() {
    return this.useMultiNetworkPolicy != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkSpecFluentImpl that = (NetworkSpecFluentImpl) o;
    if (additionalNetworks != null ? !additionalNetworks.equals(that.additionalNetworks) :that.additionalNetworks != null) return false;
    if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
    if (defaultNetwork != null ? !defaultNetwork.equals(that.defaultNetwork) :that.defaultNetwork != null) return false;
    if (deployKubeProxy != null ? !deployKubeProxy.equals(that.deployKubeProxy) :that.deployKubeProxy != null) return false;
    if (disableMultiNetwork != null ? !disableMultiNetwork.equals(that.disableMultiNetwork) :that.disableMultiNetwork != null) return false;
    if (disableNetworkDiagnostics != null ? !disableNetworkDiagnostics.equals(that.disableNetworkDiagnostics) :that.disableNetworkDiagnostics != null) return false;
    if (exportNetworkFlows != null ? !exportNetworkFlows.equals(that.exportNetworkFlows) :that.exportNetworkFlows != null) return false;
    if (kubeProxyConfig != null ? !kubeProxyConfig.equals(that.kubeProxyConfig) :that.kubeProxyConfig != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
    if (migration != null ? !migration.equals(that.migration) :that.migration != null) return false;
    if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
    if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
    if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    if (useMultiNetworkPolicy != null ? !useMultiNetworkPolicy.equals(that.useMultiNetworkPolicy) :that.useMultiNetworkPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalNetworks,  clusterNetwork,  defaultNetwork,  deployKubeProxy,  disableMultiNetwork,  disableNetworkDiagnostics,  exportNetworkFlows,  kubeProxyConfig,  logLevel,  managementState,  migration,  observedConfig,  operatorLogLevel,  serviceNetwork,  unsupportedConfigOverrides,  useMultiNetworkPolicy,  additionalProperties,  super.hashCode());
  }
  public class AdditionalNetworksNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AdditionalNetworksNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworksNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.setToAdditionalNetworks(index,builder.build());
    }
    public N endAdditionalNetwork() {
      return and();
    }
    
  }
  public class ClusterNetworkNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterNetworkNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.setToClusterNetwork(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  public class DefaultNetworkNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DefaultNetworkNestedImpl(io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withDefaultNetwork(builder.build());
    }
    public N endDefaultNetwork() {
      return and();
    }
    
  }
  public class ExportNetworkFlowsNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ExportNetworkFlowsNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ExportNetworkFlowsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ExportNetworkFlowsNestedImpl(io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withExportNetworkFlows(builder.build());
    }
    public N endExportNetworkFlows() {
      return and();
    }
    
  }
  public class KubeProxyConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeProxyConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ProxyConfig item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder(this, item);
    }
    KubeProxyConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withKubeProxyConfig(builder.build());
    }
    public N endKubeProxyConfig() {
      return and();
    }
    
  }
  public class MigrationNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.NetworkMigrationFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.MigrationNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.MigrationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MigrationNestedImpl(io.fabric8.openshift.api.model.operator.v1.NetworkMigration item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkMigrationBuilder(this, item);
    }
    MigrationNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkMigrationBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.NetworkMigrationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withMigration(builder.build());
    }
    public N endMigration() {
      return and();
    }
    
  }
  public class ImagePrunerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ImagePrunerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImagePrunerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImagePrunerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImagePrunerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ImagePruner item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(this, item);
    }
    ImagePrunerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerObservedConfig() {
      return and();
    }
    
  }
  public class KubeControllerManagerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeControllerManagerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeControllerManagerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerObservedConfig() {
      return and();
    }
    
  }
  public class StorageObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.StorageFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.StorageObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.StorageObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StorageObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Storage item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StorageBuilder(this, item);
    }
    StorageObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StorageBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.StorageBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageObservedConfig() {
      return and();
    }
    
  }
  public class ImageContentSourcePolicyObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageContentSourcePolicyObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImageContentSourcePolicyObservedConfig() {
      return and();
    }
    
  }
  public class ServiceCAObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCAFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCAObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCAObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceCAObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCA item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(this, item);
    }
    ServiceCAObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCAObservedConfig() {
      return and();
    }
    
  }
  public class ConfigObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConfigObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConfigObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Config item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ConfigBuilder(this, item);
    }
    ConfigObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigObservedConfig() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimObservedConfigNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimObservedConfigNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObservedConfigNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPersistentVolumeClaimObservedConfig() {
      return and();
    }
    
  }
  public class KubeAPIServerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeAPIServerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeAPIServerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerObservedConfig() {
      return and();
    }
    
  }
  public class IngressControllerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.IngressControllerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.IngressControllerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressControllerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.IngressController item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(this, item);
    }
    IngressControllerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerObservedConfig() {
      return and();
    }
    
  }
  public class KubeStorageVersionMigratorObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeStorageVersionMigratorObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorObservedConfig() {
      return and();
    }
    
  }
  public class ConsoleObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConsoleFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConsoleObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConsoleObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConsoleObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Console item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(this, item);
    }
    ConsoleObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleObservedConfig() {
      return and();
    }
    
  }
  public class ClusterCSIDriverObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterCSIDriverObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverObservedConfig() {
      return and();
    }
    
  }
  public class OpenShiftControllerManagerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OpenShiftControllerManagerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerObservedConfig() {
      return and();
    }
    
  }
  public class EtcdObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.EtcdFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.EtcdObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.EtcdObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EtcdObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Etcd item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(this, item);
    }
    EtcdObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.EtcdBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdObservedConfig() {
      return and();
    }
    
  }
  public class CloudCredentialObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.CloudCredentialFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CloudCredentialObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CloudCredentialObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CloudCredentialObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.CloudCredential item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder(this, item);
    }
    CloudCredentialObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialObservedConfig() {
      return and();
    }
    
  }
  public class KubeSchedulerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeSchedulerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeSchedulerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeSchedulerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeSchedulerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeScheduler item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerObservedConfig() {
      return and();
    }
    
  }
  public class NetworkObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.NetworkFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.NetworkObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.NetworkObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetworkObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Network item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(this, item);
    }
    NetworkObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.NetworkBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkObservedConfig() {
      return and();
    }
    
  }
  public class ServiceCatalogAPIServerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceCatalogAPIServerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerObservedConfig() {
      return and();
    }
    
  }
  public class PodNetworkConnectivityCheckObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodNetworkConnectivityCheckObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck item) {
      this.builder = new io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckObservedConfig() {
      return and();
    }
    
  }
  public class CSISnapshotControllerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CSISnapshotControllerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerObservedConfig() {
      return and();
    }
    
  }
  public class ServiceCatalogControllerManagerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceCatalogControllerManagerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerObservedConfig() {
      return and();
    }
    
  }
  public class DNSObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DNSObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.DNS item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(this, item);
    }
    DNSObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.DNSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSObservedConfig() {
      return and();
    }
    
  }
  public class DNSRecordObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSRecordFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSRecordObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSRecordObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DNSRecordObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.DNSRecord item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(this, item);
    }
    DNSRecordObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordObservedConfig() {
      return and();
    }
    
  }
  public class OpenShiftAPIServerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OpenShiftAPIServerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerObservedConfig() {
      return and();
    }
    
  }
  public class AuthenticationObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.AuthenticationFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AuthenticationObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AuthenticationObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AuthenticationObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Authentication item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(this, item);
    }
    AuthenticationObservedConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationObservedConfig() {
      return and();
    }
    
  }
  public class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ImagePrunerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ImagePruner item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(this, item);
    }
    ImagePrunerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StorageUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.StorageFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StorageUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Storage item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StorageBuilder(this, item);
    }
    StorageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.StorageBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.StorageBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCAFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceCAUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCA item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(this, item);
    }
    ServiceCAUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConfigUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Config item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ConfigBuilder(this, item);
    }
    ConfigUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressControllerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.IngressController item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(this, item);
    }
    IngressControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConsoleFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConsoleUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Console item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(this, item);
    }
    ConsoleUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ClusterCSIDriverUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class EtcdUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.EtcdFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EtcdUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Etcd item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(this, item);
    }
    EtcdUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.EtcdBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CloudCredentialUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.CloudCredentialFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.CloudCredential item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder(this, item);
    }
    CloudCredentialUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeSchedulerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeScheduler item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NetworkUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.NetworkFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetworkUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Network item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(this, item);
    }
    NetworkUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.NetworkBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck item) {
      this.builder = new io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DNSUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.DNS item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(this, item);
    }
    DNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.DNSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSRecordFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DNSRecordUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.DNSRecord item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(this, item);
    }
    DNSRecordUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.AuthenticationFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AuthenticationUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Authentication item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(this, item);
    }
    AuthenticationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}