package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NodePlacementBuilder extends io.fabric8.openshift.api.model.operator.v1.NodePlacementFluentImpl<io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.NodePlacement,io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder>{
  public NodePlacementBuilder() {
    this(false);
  }
  public NodePlacementBuilder(java.lang.Boolean validationEnabled) {
    this(new NodePlacement(), validationEnabled);
  }
  public NodePlacementBuilder(io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public NodePlacementBuilder(io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodePlacement(), validationEnabled);
  }
  public NodePlacementBuilder(io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.NodePlacement instance) {
    this(fluent, instance, false);
  }
  public NodePlacementBuilder(io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.NodePlacement instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withTolerations(instance.getTolerations()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodePlacementBuilder(io.fabric8.openshift.api.model.operator.v1.NodePlacement instance) {
    this(instance,false);
  }
  public NodePlacementBuilder(io.fabric8.openshift.api.model.operator.v1.NodePlacement instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withTolerations(instance.getTolerations()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.operator.v1.NodePlacement build() {
    NodePlacement buildable = new NodePlacement(fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodePlacementBuilder that = (NodePlacementBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}