package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OpenShiftAPIServerBuilder extends io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer,io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder>{
  public OpenShiftAPIServerBuilder() {
    this(false);
  }
  public OpenShiftAPIServerBuilder(java.lang.Boolean validationEnabled) {
    this(new OpenShiftAPIServer(), validationEnabled);
  }
  public OpenShiftAPIServerBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftAPIServerBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OpenShiftAPIServer(), validationEnabled);
  }
  public OpenShiftAPIServerBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer instance) {
    this(fluent, instance, false);
  }
  public OpenShiftAPIServerBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftAPIServerBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer instance) {
    this(instance,false);
  }
  public OpenShiftAPIServerBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer build() {
    OpenShiftAPIServer buildable = new OpenShiftAPIServer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenShiftAPIServerBuilder that = (OpenShiftAPIServerBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}