package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class UpstreamBuilder extends io.fabric8.openshift.api.model.operator.v1.UpstreamFluentImpl<io.fabric8.openshift.api.model.operator.v1.UpstreamBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.Upstream,io.fabric8.openshift.api.model.operator.v1.UpstreamBuilder>{
  public UpstreamBuilder() {
    this(false);
  }
  public UpstreamBuilder(java.lang.Boolean validationEnabled) {
    this(new Upstream(), validationEnabled);
  }
  public UpstreamBuilder(io.fabric8.openshift.api.model.operator.v1.UpstreamFluent<?> fluent) {
    this(fluent, false);
  }
  public UpstreamBuilder(io.fabric8.openshift.api.model.operator.v1.UpstreamFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Upstream(), validationEnabled);
  }
  public UpstreamBuilder(io.fabric8.openshift.api.model.operator.v1.UpstreamFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.Upstream instance) {
    this(fluent, instance, false);
  }
  public UpstreamBuilder(io.fabric8.openshift.api.model.operator.v1.UpstreamFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.Upstream instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withPort(instance.getPort()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UpstreamBuilder(io.fabric8.openshift.api.model.operator.v1.Upstream instance) {
    this(instance,false);
  }
  public UpstreamBuilder(io.fabric8.openshift.api.model.operator.v1.Upstream instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withPort(instance.getPort()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.operator.v1.UpstreamFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.operator.v1.Upstream build() {
    Upstream buildable = new Upstream(fluent.getAddress(),fluent.getPort(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    UpstreamBuilder that = (UpstreamBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}