package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DNSRecordSpecBuilder extends io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecFluentImpl<io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.DNSRecordSpec,io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecBuilder>{
  public DNSRecordSpecBuilder() {
    this(false);
  }
  public DNSRecordSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new DNSRecordSpec(), validationEnabled);
  }
  public DNSRecordSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSRecordSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DNSRecordSpec(), validationEnabled);
  }
  public DNSRecordSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.DNSRecordSpec instance) {
    this(fluent, instance, false);
  }
  public DNSRecordSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.DNSRecordSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDnsName(instance.getDnsName()); 
    fluent.withRecordTTL(instance.getRecordTTL()); 
    fluent.withRecordType(instance.getRecordType()); 
    fluent.withTargets(instance.getTargets()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DNSRecordSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSRecordSpec instance) {
    this(instance,false);
  }
  public DNSRecordSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSRecordSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDnsName(instance.getDnsName()); 
    this.withRecordTTL(instance.getRecordTTL()); 
    this.withRecordType(instance.getRecordType()); 
    this.withTargets(instance.getTargets()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.operator.v1.DNSRecordSpec build() {
    DNSRecordSpec buildable = new DNSRecordSpec(fluent.getDnsName(),fluent.getRecordTTL(),fluent.getRecordType(),fluent.getTargets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSRecordSpecBuilder that = (DNSRecordSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}