package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSRecordBuilder extends DNSRecordFluentImpl<DNSRecordBuilder> implements VisitableBuilder<DNSRecord,DNSRecordBuilder> {

    DNSRecordFluent<?> fluent;
    Boolean validationEnabled;

    public DNSRecordBuilder() {
        this(true);
    }

    public DNSRecordBuilder(Boolean validationEnabled) {
        this(new DNSRecord(), validationEnabled);
    }

    public DNSRecordBuilder(DNSRecordFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSRecordBuilder(DNSRecordFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSRecord(), validationEnabled);
    }

    public DNSRecordBuilder(DNSRecordFluent<?> fluent,DNSRecord instance) {
        this(fluent, instance, true);
    }

    public DNSRecordBuilder(DNSRecordFluent<?> fluent,DNSRecord instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSRecordBuilder(DNSRecord instance) {
        this(instance,true);
    }

    public DNSRecordBuilder(DNSRecord instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSRecord build() {
        DNSRecord buildable = new DNSRecord(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSRecordBuilder that = (DNSRecordBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
