package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HostNetworkStrategyBuilder extends HostNetworkStrategyFluentImpl<HostNetworkStrategyBuilder> implements VisitableBuilder<HostNetworkStrategy,HostNetworkStrategyBuilder> {

    HostNetworkStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public HostNetworkStrategyBuilder() {
        this(true);
    }

    public HostNetworkStrategyBuilder(Boolean validationEnabled) {
        this(new HostNetworkStrategy(), validationEnabled);
    }

    public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new HostNetworkStrategy(), validationEnabled);
    }

    public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,HostNetworkStrategy instance) {
        this(fluent, instance, true);
    }

    public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,HostNetworkStrategy instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public HostNetworkStrategyBuilder(HostNetworkStrategy instance) {
        this(instance,true);
    }

    public HostNetworkStrategyBuilder(HostNetworkStrategy instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public HostNetworkStrategy build() {
        HostNetworkStrategy buildable = new HostNetworkStrategy();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HostNetworkStrategyBuilder that = (HostNetworkStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
