package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerSpecBuilder extends IngressControllerSpecFluentImpl<IngressControllerSpecBuilder> implements VisitableBuilder<IngressControllerSpec,IngressControllerSpecBuilder> {

    IngressControllerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerSpecBuilder() {
        this(true);
    }

    public IngressControllerSpecBuilder(Boolean validationEnabled) {
        this(new IngressControllerSpec(), validationEnabled);
    }

    public IngressControllerSpecBuilder(IngressControllerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressControllerSpecBuilder(IngressControllerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressControllerSpec(), validationEnabled);
    }

    public IngressControllerSpecBuilder(IngressControllerSpecFluent<?> fluent,IngressControllerSpec instance) {
        this(fluent, instance, true);
    }

    public IngressControllerSpecBuilder(IngressControllerSpecFluent<?> fluent,IngressControllerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDefaultCertificate(instance.getDefaultCertificate()); 
        fluent.withDomain(instance.getDomain()); 
        fluent.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
        fluent.withHttpHeaders(instance.getHttpHeaders()); 
        fluent.withLogging(instance.getLogging()); 
        fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
        fluent.withNodePlacement(instance.getNodePlacement()); 
        fluent.withReplicas(instance.getReplicas()); 
        fluent.withRouteAdmission(instance.getRouteAdmission()); 
        fluent.withRouteSelector(instance.getRouteSelector()); 
        fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerSpecBuilder(IngressControllerSpec instance) {
        this(instance,true);
    }

    public IngressControllerSpecBuilder(IngressControllerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDefaultCertificate(instance.getDefaultCertificate()); 
        this.withDomain(instance.getDomain()); 
        this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
        this.withHttpHeaders(instance.getHttpHeaders()); 
        this.withLogging(instance.getLogging()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withNodePlacement(instance.getNodePlacement()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRouteAdmission(instance.getRouteAdmission()); 
        this.withRouteSelector(instance.getRouteSelector()); 
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerSpec build() {
        IngressControllerSpec buildable = new IngressControllerSpec(fluent.getDefaultCertificate(),fluent.getDomain(),fluent.getEndpointPublishingStrategy(),fluent.getHttpHeaders(),fluent.getLogging(),fluent.getNamespaceSelector(),fluent.getNodePlacement(),fluent.getReplicas(),fluent.getRouteAdmission(),fluent.getRouteSelector(),fluent.getTlsSecurityProfile());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressControllerSpecBuilder that = (IngressControllerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
