package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

public interface KubeAPIServerSpecFluent<A extends KubeAPIServerSpecFluent<A>> extends Fluent<A> {


    public Integer getFailedRevisionLimit();
    public A withFailedRevisionLimit(Integer failedRevisionLimit);
    public Boolean hasFailedRevisionLimit();
    public String getForceRedeploymentReason();
    public A withForceRedeploymentReason(String forceRedeploymentReason);
    public Boolean hasForceRedeploymentReason();
    public A withNewForceRedeploymentReason(String arg1);
    public A withNewForceRedeploymentReason(StringBuilder arg1);
    public A withNewForceRedeploymentReason(StringBuffer arg1);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public String getManagementState();
    public A withManagementState(String managementState);
    public Boolean hasManagementState();
    public A withNewManagementState(String arg1);
    public A withNewManagementState(StringBuilder arg1);
    public A withNewManagementState(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildObservedConfig instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getObservedConfig();
    public HasMetadata buildObservedConfig();
    public A withObservedConfig(HasMetadata observedConfig);
    public Boolean hasObservedConfig();
    public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig);
    public KubeAPIServerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig();
    public KubeAPIServerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item);
    public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig);
    public KubeAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig();
    public KubeAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item);
    public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig);
    public KubeAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig();
    public KubeAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item);
    public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig);
    public KubeAPIServerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig();
    public KubeAPIServerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item);
    public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig);
    public KubeAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig();
    public KubeAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item);
    public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig);
    public KubeAPIServerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig();
    public KubeAPIServerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item);
    public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig);
    public KubeAPIServerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig();
    public KubeAPIServerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item);
    public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig);
    public KubeAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig();
    public KubeAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item);
    public A withConsoleObservedConfig(Console consoleObservedConfig);
    public KubeAPIServerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig();
    public KubeAPIServerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item);
    public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig);
    public KubeAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig();
    public KubeAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item);
    public A withEtcdObservedConfig(Etcd etcdObservedConfig);
    public KubeAPIServerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig();
    public KubeAPIServerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item);
    public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig);
    public KubeAPIServerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig();
    public KubeAPIServerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item);
    public A withNetworkObservedConfig(Network networkObservedConfig);
    public KubeAPIServerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig();
    public KubeAPIServerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item);
    public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig);
    public KubeAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig();
    public KubeAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig);
    public KubeAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig();
    public KubeAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig);
    public KubeAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig();
    public KubeAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item);
    public A withDNSObservedConfig(DNS dNSObservedConfig);
    public KubeAPIServerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig();
    public KubeAPIServerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item);
    public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig);
    public KubeAPIServerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig();
    public KubeAPIServerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item);
    public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig);
    public KubeAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig();
    public KubeAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item);
    public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig);
    public KubeAPIServerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig();
    public KubeAPIServerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item);
    public String getOperatorLogLevel();
    public A withOperatorLogLevel(String operatorLogLevel);
    public Boolean hasOperatorLogLevel();
    public A withNewOperatorLogLevel(String arg1);
    public A withNewOperatorLogLevel(StringBuilder arg1);
    public A withNewOperatorLogLevel(StringBuffer arg1);
    public Integer getSucceededRevisionLimit();
    public A withSucceededRevisionLimit(Integer succeededRevisionLimit);
    public Boolean hasSucceededRevisionLimit();
    
/**
 * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getUnsupportedConfigOverrides();
    public HasMetadata buildUnsupportedConfigOverrides();
    public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides);
    public Boolean hasUnsupportedConfigOverrides();
    public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item);
    public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item);
    public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item);
    public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item);
    public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item);
    public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item);
    public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item);
    public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item);
    public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item);
    public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item);
    public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item);
    public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item);
    public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item);
    public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item);
    public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item);
    public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item);
    public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item);
    public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides);
    public KubeAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides();
    public KubeAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item);
    public interface ImagePrunerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<KubeAPIServerSpecFluent.ImagePrunerObservedConfigNested<N>> {

            public N and();
            public N endImagePrunerObservedConfig();    }


    public interface KubeControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<KubeAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<N>> {

            public N and();
            public N endKubeControllerManagerObservedConfig();    }


    public interface ImageContentSourcePolicyObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<KubeAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> {

            public N and();
            public N endImageContentSourcePolicyObservedConfig();    }


    public interface ServiceCAObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<KubeAPIServerSpecFluent.ServiceCAObservedConfigNested<N>> {

            public N and();
            public N endServiceCAObservedConfig();    }


    public interface PersistentVolumeClaimObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<KubeAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> {

            public N and();
            public N endPersistentVolumeClaimObservedConfig();    }


    public interface KubeAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<KubeAPIServerSpecFluent.KubeAPIServerObservedConfigNested<N>> {

            public N and();
            public N endKubeAPIServerObservedConfig();    }


    public interface IngressControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<KubeAPIServerSpecFluent.IngressControllerObservedConfigNested<N>> {

            public N and();
            public N endIngressControllerObservedConfig();    }


    public interface KubeStorageVersionMigratorObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<KubeAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> {

            public N and();
            public N endKubeStorageVersionMigratorObservedConfig();    }


    public interface ConsoleObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<KubeAPIServerSpecFluent.ConsoleObservedConfigNested<N>> {

            public N and();
            public N endConsoleObservedConfig();    }


    public interface OpenShiftControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<KubeAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> {

            public N and();
            public N endOpenShiftControllerManagerObservedConfig();    }


    public interface EtcdObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<KubeAPIServerSpecFluent.EtcdObservedConfigNested<N>> {

            public N and();
            public N endEtcdObservedConfig();    }


    public interface KubeSchedulerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<KubeAPIServerSpecFluent.KubeSchedulerObservedConfigNested<N>> {

            public N and();
            public N endKubeSchedulerObservedConfig();    }


    public interface NetworkObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<KubeAPIServerSpecFluent.NetworkObservedConfigNested<N>> {

            public N and();
            public N endNetworkObservedConfig();    }


    public interface ServiceCatalogAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<KubeAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> {

            public N and();
            public N endServiceCatalogAPIServerObservedConfig();    }


    public interface CSISnapshotControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<KubeAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<N>> {

            public N and();
            public N endCSISnapshotControllerObservedConfig();    }


    public interface ServiceCatalogControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<KubeAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> {

            public N and();
            public N endServiceCatalogControllerManagerObservedConfig();    }


    public interface DNSObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<KubeAPIServerSpecFluent.DNSObservedConfigNested<N>> {

            public N and();
            public N endDNSObservedConfig();    }


    public interface DNSRecordObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<KubeAPIServerSpecFluent.DNSRecordObservedConfigNested<N>> {

            public N and();
            public N endDNSRecordObservedConfig();    }


    public interface OpenShiftAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<KubeAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> {

            public N and();
            public N endOpenShiftAPIServerObservedConfig();    }


    public interface AuthenticationObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<KubeAPIServerSpecFluent.AuthenticationObservedConfigNested<N>> {

            public N and();
            public N endAuthenticationObservedConfig();    }


    public interface ImagePrunerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<KubeAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endImagePrunerUnsupportedConfigOverrides();    }


    public interface KubeControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<KubeAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endKubeControllerManagerUnsupportedConfigOverrides();    }


    public interface ImageContentSourcePolicyUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<KubeAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endImageContentSourcePolicyUnsupportedConfigOverrides();    }


    public interface ServiceCAUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<KubeAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endServiceCAUnsupportedConfigOverrides();    }


    public interface PersistentVolumeClaimUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<KubeAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endPersistentVolumeClaimUnsupportedConfigOverrides();    }


    public interface KubeAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<KubeAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endKubeAPIServerUnsupportedConfigOverrides();    }


    public interface IngressControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<KubeAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endIngressControllerUnsupportedConfigOverrides();    }


    public interface KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<KubeAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endKubeStorageVersionMigratorUnsupportedConfigOverrides();    }


    public interface ConsoleUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<KubeAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endConsoleUnsupportedConfigOverrides();    }


    public interface OpenShiftControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<KubeAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endOpenShiftControllerManagerUnsupportedConfigOverrides();    }


    public interface EtcdUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<KubeAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endEtcdUnsupportedConfigOverrides();    }


    public interface KubeSchedulerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<KubeAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endKubeSchedulerUnsupportedConfigOverrides();    }


    public interface NetworkUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<KubeAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endNetworkUnsupportedConfigOverrides();    }


    public interface ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<KubeAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endServiceCatalogAPIServerUnsupportedConfigOverrides();    }


    public interface CSISnapshotControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<KubeAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endCSISnapshotControllerUnsupportedConfigOverrides();    }


    public interface ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<KubeAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endServiceCatalogControllerManagerUnsupportedConfigOverrides();    }


    public interface DNSUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<KubeAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endDNSUnsupportedConfigOverrides();    }


    public interface DNSRecordUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<KubeAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endDNSRecordUnsupportedConfigOverrides();    }


    public interface OpenShiftAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<KubeAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endOpenShiftAPIServerUnsupportedConfigOverrides();    }


    public interface AuthenticationUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<KubeAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> {

            public N and();
            public N endAuthenticationUnsupportedConfigOverrides();    }


}
