package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeStorageVersionMigratorStatusBuilder extends KubeStorageVersionMigratorStatusFluentImpl<KubeStorageVersionMigratorStatusBuilder> implements VisitableBuilder<KubeStorageVersionMigratorStatus,KubeStorageVersionMigratorStatusBuilder> {

    KubeStorageVersionMigratorStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KubeStorageVersionMigratorStatusBuilder() {
        this(true);
    }

    public KubeStorageVersionMigratorStatusBuilder(Boolean validationEnabled) {
        this(new KubeStorageVersionMigratorStatus(), validationEnabled);
    }

    public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KubeStorageVersionMigratorStatus(), validationEnabled);
    }

    public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatusFluent<?> fluent,KubeStorageVersionMigratorStatus instance) {
        this(fluent, instance, true);
    }

    public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatusFluent<?> fluent,KubeStorageVersionMigratorStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatus instance) {
        this(instance,true);
    }

    public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeStorageVersionMigratorStatus build() {
        KubeStorageVersionMigratorStatus buildable = new KubeStorageVersionMigratorStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeStorageVersionMigratorStatusBuilder that = (KubeStorageVersionMigratorStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
