package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CustomTLSProfileFluent<A extends CustomTLSProfileFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToCiphers(int index,String item);
    public A setToCiphers(int index,String item);
    public A addToCiphers(String... items);
    public A addAllToCiphers(Collection<String> items);
    public A removeFromCiphers(String... items);
    public A removeAllFromCiphers(Collection<String> items);
    public List<String> getCiphers();
    public String getCipher(int index);
    public String getFirstCipher();
    public String getLastCipher();
    public String getMatchingCipher(Predicate<String> predicate);
    public Boolean hasMatchingCipher(Predicate<String> predicate);
    public A withCiphers(List<String> ciphers);
    public A withCiphers(String... ciphers);
    public Boolean hasCiphers();
    public A addNewCipher(StringBuilder arg1);
    public A addNewCipher(int[] arg1,int arg2,int arg3);
    public A addNewCipher(char[] arg1);
    public A addNewCipher(StringBuffer arg1);
    public A addNewCipher(byte[] arg1,int arg2);
    public A addNewCipher(byte[] arg1);
    public A addNewCipher(char[] arg1,int arg2,int arg3);
    public A addNewCipher(byte[] arg1,int arg2,int arg3);
    public A addNewCipher(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewCipher(String arg1);
    public String getMinTLSVersion();
    public A withMinTLSVersion(String minTLSVersion);
    public Boolean hasMinTLSVersion();
    public A withNewMinTLSVersion(StringBuilder arg1);
    public A withNewMinTLSVersion(int[] arg1,int arg2,int arg3);
    public A withNewMinTLSVersion(char[] arg1);
    public A withNewMinTLSVersion(StringBuffer arg1);
    public A withNewMinTLSVersion(byte[] arg1,int arg2);
    public A withNewMinTLSVersion(byte[] arg1);
    public A withNewMinTLSVersion(char[] arg1,int arg2,int arg3);
    public A withNewMinTLSVersion(byte[] arg1,int arg2,int arg3);
    public A withNewMinTLSVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewMinTLSVersion(String arg1);
}
