package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class AWSLoadBalancerParametersFluentImpl<A extends AWSLoadBalancerParametersFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AWSLoadBalancerParametersFluent<A> {

    private AWSClassicLoadBalancerParametersBuilder classicLoadBalancer;
    private AWSNetworkLoadBalancerParametersBuilder networkLoadBalancer;
    private String type;

    public AWSLoadBalancerParametersFluentImpl() {
    }

    public AWSLoadBalancerParametersFluentImpl(AWSLoadBalancerParameters instance) {
        this.withClassicLoadBalancer(instance.getClassicLoadBalancer()); 
        this.withNetworkLoadBalancer(instance.getNetworkLoadBalancer()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildClassicLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public AWSClassicLoadBalancerParameters getClassicLoadBalancer() {
        return this.classicLoadBalancer!=null?this.classicLoadBalancer.build():null;
    }

    public AWSClassicLoadBalancerParameters buildClassicLoadBalancer() {
        return this.classicLoadBalancer!=null?this.classicLoadBalancer.build():null;
    }

    public A withClassicLoadBalancer(AWSClassicLoadBalancerParameters classicLoadBalancer) {
        _visitables.get("classicLoadBalancer").remove(this.classicLoadBalancer);
        if (classicLoadBalancer!=null){ this.classicLoadBalancer= new AWSClassicLoadBalancerParametersBuilder(classicLoadBalancer); _visitables.get("classicLoadBalancer").add(this.classicLoadBalancer);} return (A) this;
    }

    public Boolean hasClassicLoadBalancer() {
        return this.classicLoadBalancer != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.ClassicLoadBalancerNested<A> withNewClassicLoadBalancer() {
        return new ClassicLoadBalancerNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.ClassicLoadBalancerNested<A> withNewClassicLoadBalancerLike(AWSClassicLoadBalancerParameters item) {
        return new ClassicLoadBalancerNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.ClassicLoadBalancerNested<A> editClassicLoadBalancer() {
        return withNewClassicLoadBalancerLike(getClassicLoadBalancer());
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.ClassicLoadBalancerNested<A> editOrNewClassicLoadBalancer() {
        return withNewClassicLoadBalancerLike(getClassicLoadBalancer() != null ? getClassicLoadBalancer(): new AWSClassicLoadBalancerParametersBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.ClassicLoadBalancerNested<A> editOrNewClassicLoadBalancerLike(AWSClassicLoadBalancerParameters item) {
        return withNewClassicLoadBalancerLike(getClassicLoadBalancer() != null ? getClassicLoadBalancer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNetworkLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public AWSNetworkLoadBalancerParameters getNetworkLoadBalancer() {
        return this.networkLoadBalancer!=null?this.networkLoadBalancer.build():null;
    }

    public AWSNetworkLoadBalancerParameters buildNetworkLoadBalancer() {
        return this.networkLoadBalancer!=null?this.networkLoadBalancer.build():null;
    }

    public A withNetworkLoadBalancer(AWSNetworkLoadBalancerParameters networkLoadBalancer) {
        _visitables.get("networkLoadBalancer").remove(this.networkLoadBalancer);
        if (networkLoadBalancer!=null){ this.networkLoadBalancer= new AWSNetworkLoadBalancerParametersBuilder(networkLoadBalancer); _visitables.get("networkLoadBalancer").add(this.networkLoadBalancer);} return (A) this;
    }

    public Boolean hasNetworkLoadBalancer() {
        return this.networkLoadBalancer != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.NetworkLoadBalancerNested<A> withNewNetworkLoadBalancer() {
        return new NetworkLoadBalancerNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.NetworkLoadBalancerNested<A> withNewNetworkLoadBalancerLike(AWSNetworkLoadBalancerParameters item) {
        return new NetworkLoadBalancerNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.NetworkLoadBalancerNested<A> editNetworkLoadBalancer() {
        return withNewNetworkLoadBalancerLike(getNetworkLoadBalancer());
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.NetworkLoadBalancerNested<A> editOrNewNetworkLoadBalancer() {
        return withNewNetworkLoadBalancerLike(getNetworkLoadBalancer() != null ? getNetworkLoadBalancer(): new AWSNetworkLoadBalancerParametersBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.NetworkLoadBalancerNested<A> editOrNewNetworkLoadBalancerLike(AWSNetworkLoadBalancerParameters item) {
        return withNewNetworkLoadBalancerLike(getNetworkLoadBalancer() != null ? getNetworkLoadBalancer(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AWSLoadBalancerParametersFluentImpl that = (AWSLoadBalancerParametersFluentImpl) o;
        if (classicLoadBalancer != null ? !classicLoadBalancer.equals(that.classicLoadBalancer) :that.classicLoadBalancer != null) return false;
        if (networkLoadBalancer != null ? !networkLoadBalancer.equals(that.networkLoadBalancer) :that.networkLoadBalancer != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(classicLoadBalancer,  networkLoadBalancer,  type,  super.hashCode());
    }

    public class ClassicLoadBalancerNestedImpl<N> extends AWSClassicLoadBalancerParametersFluentImpl<io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.ClassicLoadBalancerNested<N>> implements io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.ClassicLoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AWSClassicLoadBalancerParametersBuilder builder;

            ClassicLoadBalancerNestedImpl(AWSClassicLoadBalancerParameters item) {
                this.builder = new AWSClassicLoadBalancerParametersBuilder(this, item);
                        
            }

            ClassicLoadBalancerNestedImpl() {
                this.builder = new AWSClassicLoadBalancerParametersBuilder(this);
                        
            }

            public N and() {
                return (N) AWSLoadBalancerParametersFluentImpl.this.withClassicLoadBalancer(builder.build());
            }

            public N endClassicLoadBalancer() {
                return and();
            }
    }


    public class NetworkLoadBalancerNestedImpl<N> extends AWSNetworkLoadBalancerParametersFluentImpl<io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.NetworkLoadBalancerNested<N>> implements io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent.NetworkLoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AWSNetworkLoadBalancerParametersBuilder builder;

            NetworkLoadBalancerNestedImpl(AWSNetworkLoadBalancerParameters item) {
                this.builder = new AWSNetworkLoadBalancerParametersBuilder(this, item);
                        
            }

            NetworkLoadBalancerNestedImpl() {
                this.builder = new AWSNetworkLoadBalancerParametersBuilder(this);
                        
            }

            public N and() {
                return (N) AWSLoadBalancerParametersFluentImpl.this.withNetworkLoadBalancer(builder.build());
            }

            public N endNetworkLoadBalancer() {
                return and();
            }
    }


}
